Liferay.Loader.define('analytics-reports-web$lodash-es@4.17.15/methodOf', ['module', 'exports', 'require'], function (module, exports, require) {
  var define = undefined;
  import baseInvoke from './_baseInvoke.js';
  import baseRest from './_baseRest.js';

  /**
   * The opposite of `_.method`; this method creates a function that invokes
   * the method at a given path of `object`. Any additional arguments are
   * provided to the invoked method.
   *
   * @static
   * @memberOf _
   * @since 3.7.0
   * @category Util
   * @param {Object} object The object to query.
   * @param {...*} [args] The arguments to invoke the method with.
   * @returns {Function} Returns the new invoker function.
   * @example
   *
   * var array = _.times(3, _.constant),
   *     object = { 'a': array, 'b': array, 'c': array };
   *
   * _.map(['a[2]', 'c[0]'], _.methodOf(object));
   * // => [2, 0]
   *
   * _.map([['a', '2'], ['c', '0']], _.methodOf(object));
   * // => [2, 0]
   */
  var methodOf = baseRest(function (object, args) {
    return function (path) {
      return baseInvoke(object, path, args);
    };
  });

  export default methodOf;
});
//# sourceMappingURL=methodOf.js.map