Liferay.Loader.define('analytics-reports-web$lodash-es@4.17.15/isWeakMap', ['module', 'exports', 'require'], function (module, exports, require) {
  var define = undefined;
  import getTag from './_getTag.js';
  import isObjectLike from './isObjectLike.js';

  /** `Object#toString` result references. */
  var weakMapTag = '[object WeakMap]';

  /**
   * Checks if `value` is classified as a `WeakMap` object.
   *
   * @static
   * @memberOf _
   * @since 4.3.0
   * @category Lang
   * @param {*} value The value to check.
   * @returns {boolean} Returns `true` if `value` is a weak map, else `false`.
   * @example
   *
   * _.isWeakMap(new WeakMap);
   * // => true
   *
   * _.isWeakMap(new Map);
   * // => false
   */
  function isWeakMap(value) {
    return isObjectLike(value) && getTag(value) == weakMapTag;
  }

  export default isWeakMap;
});
//# sourceMappingURL=isWeakMap.js.map