Liferay.Loader.define('analytics-reports-web$lodash-es@4.17.15/_baseMatchesProperty', ['module', 'exports', 'require'], function (module, exports, require) {
  var define = undefined;
  import baseIsEqual from './_baseIsEqual.js';
  import get from './get.js';
  import hasIn from './hasIn.js';
  import isKey from './_isKey.js';
  import isStrictComparable from './_isStrictComparable.js';
  import matchesStrictComparable from './_matchesStrictComparable.js';
  import toKey from './_toKey.js';

  /** Used to compose bitmasks for value comparisons. */
  var COMPARE_PARTIAL_FLAG = 1,
      COMPARE_UNORDERED_FLAG = 2;

  /**
   * The base implementation of `_.matchesProperty` which doesn't clone `srcValue`.
   *
   * @private
   * @param {string} path The path of the property to get.
   * @param {*} srcValue The value to match.
   * @returns {Function} Returns the new spec function.
   */
  function baseMatchesProperty(path, srcValue) {
    if (isKey(path) && isStrictComparable(srcValue)) {
      return matchesStrictComparable(toKey(path), srcValue);
    }
    return function (object) {
      var objValue = get(object, path);
      return objValue === undefined && objValue === srcValue ? hasIn(object, path) : baseIsEqual(srcValue, objValue, COMPARE_PARTIAL_FLAG | COMPARE_UNORDERED_FLAG);
    };
  }

  export default baseMatchesProperty;
});
//# sourceMappingURL=_baseMatchesProperty.js.map