'use strict';

Liferay.Loader.define('analytics-reports-web$core-js@2.6.11/modules/_regexp-exec-abstract', ['module', 'exports', 'require', './_classof'], function (module, exports, require) {
  var define = undefined;
  var classof = require('./_classof');
  var builtinExec = RegExp.prototype.exec;

  // `RegExpExec` abstract operation
  // https://tc39.github.io/ecma262/#sec-regexpexec
  module.exports = function (R, S) {
    var exec = R.exec;
    if (typeof exec === 'function') {
      var result = exec.call(R, S);
      if (typeof result !== 'object') {
        throw new TypeError('RegExp exec method returned something other than an Object or null');
      }
      return result;
    }
    if (classof(R) !== 'RegExp') {
      throw new TypeError('RegExp#exec called on incompatible receiver');
    }
    return builtinExec.call(R, S);
  };
});
//# sourceMappingURL=_regexp-exec-abstract.js.map