Liferay.Loader.define("analytics-reports-web@1.0.2/js/utils/APIService", ['module', 'exports', 'require', 'frontend-js-web'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports._getFormDataRequest = _getFormDataRequest;
  exports["default"] = void 0;

  var _frontendJsWeb = require("frontend-js-web");

  function _slicedToArray(arr, i) {
    return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest();
  }

  function _nonIterableRest() {
    throw new TypeError("Invalid attempt to destructure non-iterable instance");
  }

  function _iterableToArrayLimit(arr, i) {
    if (!(Symbol.iterator in Object(arr) || Object.prototype.toString.call(arr) === "[object Arguments]")) {
      return;
    }var _arr = [];var _n = true;var _d = false;var _e = undefined;try {
      for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) {
        _arr.push(_s.value);if (i && _arr.length === i) break;
      }
    } catch (err) {
      _d = true;_e = err;
    } finally {
      try {
        if (!_n && _i["return"] != null) _i["return"]();
      } finally {
        if (_d) throw _e;
      }
    }return _arr;
  }

  function _arrayWithHoles(arr) {
    if (Array.isArray(arr)) return arr;
  }

  var MOCK_TRAFFIC_SOURCES_DETAILS = {
    organic: {
      keywords: [{
        position: 1,
        title: 'commerce',
        value: 90000,
        volume: 12300
      }, {
        position: 2,
        title: 'e-commerce',
        value: 14800,
        volume: 9800
      }, {
        position: 3,
        title: 'what is commerce',
        value: 14000,
        volume: 9500
      }, {
        position: 4,
        title: 'what is e-commerce',
        value: 12100,
        volume: 8700
      }, {
        position: 5,
        title: 'commerce definition for new business strategy',
        value: 10100,
        volume: 7100
      }],
      title: 'Organic Traffic'
    },
    paid: {
      keywords: [{
        position: 1,
        title: 'commerce',
        value: 90000,
        volume: 12300
      }, {
        position: 2,
        title: 'e-commerce',
        value: 14800,
        volume: 9800
      }, {
        position: 3,
        title: 'what is commerce',
        value: 14000,
        volume: 9500
      }, {
        position: 4,
        title: 'what is e-commerce',
        value: 12100,
        volume: 8700
      }, {
        position: 5,
        title: 'commerce definition for new business strategy',
        value: 10100,
        volume: 7100
      }],
      title: 'Paid Traffic'
    }
  };

  function APIService(_ref) {
    var endpoints = _ref.endpoints,
        namespace = _ref.namespace,
        page = _ref.page;
    var getAnalyticsReportsHistoricalReadsURL = endpoints.getAnalyticsReportsHistoricalReadsURL,
        getAnalyticsReportsHistoricalViewsURL = endpoints.getAnalyticsReportsHistoricalViewsURL,
        getAnalyticsReportsTotalReadsURL = endpoints.getAnalyticsReportsTotalReadsURL,
        getAnalyticsReportsTotalViewsURL = endpoints.getAnalyticsReportsTotalViewsURL;
    var plid = page.plid;

    return {
      getHistoricalReads: function getHistoricalReads(_ref2) {
        var timeSpanKey = _ref2.timeSpanKey,
            timeSpanOffset = _ref2.timeSpanOffset;

        return _fetchWithError(getAnalyticsReportsHistoricalReadsURL, {
          body: _getFormDataRequest({
            plid: plid,
            timeSpanKey: timeSpanKey,
            timeSpanOffset: timeSpanOffset
          }, namespace),
          credentials: 'include',
          method: 'POST'
        });
      },
      getHistoricalViews: function getHistoricalViews(_ref3) {
        var timeSpanKey = _ref3.timeSpanKey,
            timeSpanOffset = _ref3.timeSpanOffset;

        return _fetchWithError(getAnalyticsReportsHistoricalViewsURL, {
          body: _getFormDataRequest({
            plid: plid,
            timeSpanKey: timeSpanKey,
            timeSpanOffset: timeSpanOffset
          }, namespace),
          credentials: 'include',
          method: 'POST'
        });
      },
      getTotalReads: function getTotalReads() {
        return _fetchWithError(getAnalyticsReportsTotalReadsURL, {
          body: _getFormDataRequest({
            plid: plid
          }, namespace),
          credentials: 'include',
          method: 'POST'
        });
      },
      getTotalViews: function getTotalViews() {
        return _fetchWithError(getAnalyticsReportsTotalViewsURL, {
          body: _getFormDataRequest({
            plid: plid
          }, namespace),
          credentials: 'include',
          method: 'POST'
        });
      },
      getTrafficSourceDetails: function getTrafficSourceDetails(name) {
        // TODO remove frontend mock
        return new Promise(function (resolve) {
          return setTimeout(function () {
            resolve(MOCK_TRAFFIC_SOURCES_DETAILS[name]);
          }, 900);
        });
      }
    };
  }

  var _default = APIService;
  /**
   *
   *
   * @export
   * @param {Object} body
   * @param {string} prefix
   * @param {FormData} [formData=new FormData()]
   * @returns {FormData}
   */

  exports["default"] = _default;

  function _getFormDataRequest(body, prefix) {
    var formData = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : new FormData();
    Object.entries(body).forEach(function (_ref4) {
      var _ref5 = _slicedToArray(_ref4, 2),
          key = _ref5[0],
          value = _ref5[1];

      formData.append("".concat(prefix).concat(key), value);
    });
    return formData;
  }
  /**
   * Wrapper to `fetch` function throwing an error when `error` is present in the response
   */

  function _fetchWithError(url) {
    var options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
    return (0, _frontendJsWeb.fetch)(url, options).then(function (response) {
      return response.json();
    }).then(function (objectResponse) {
      if (objectResponse.error) {
        throw objectResponse.error;
      }

      return objectResponse;
    });
  }
  //# sourceMappingURL=APIService.js.map
});
//# sourceMappingURL=APIService.js.map