Liferay.Loader.define("analytics-reports-web@1.0.13/js/components/CustomDots", ['module', 'exports', 'require', 'frontend-js-react-web$prop-types', 'frontend-js-react-web$react'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports["default"] = CustomDot;
  exports.ActiveDot = ActiveDot;
  exports.Dot = Dot;

  var _propTypes = _interopRequireDefault(require("frontend-js-react-web$prop-types"));

  var _react = _interopRequireDefault(require("frontend-js-react-web$react"));

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : { "default": obj };
  }

  /**
   * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
   *
   * The contents of this file are subject to the terms of the Liferay Enterprise
   * Subscription License ("License"). You may not use this file except in
   * compliance with the License. You can obtain a copy of the License by
   * contacting Liferay, Inc. See the License for the specific language governing
   * permissions and limitations under the License, including but not limited to
   * distribution rights of the Software.
   */
  function CustomDot(props) {
    return props.active ? _react["default"].createElement(ActiveDot, props) : _react["default"].createElement(Dot, props);
  }
  /**
   * Component to customize the content of recharts Line#ActiveDot
   * http://recharts.org/en-US/api/Line#activeDot
   */

  function ActiveDot(props) {
    var cx = props.cx,
        cy = props.cy,
        fill = props.fill,
        r = props.r,
        shape = props.shape,
        _props$strokeWidth = props.strokeWidth,
        strokeWidth = _props$strokeWidth === void 0 ? 0 : _props$strokeWidth;

    if (cy === null) {
      return null;
    } else if (shape === 'square') {
      var squareSize = r * 2;
      return _react["default"].createElement("rect", {
        fill: fill,
        height: squareSize,
        strokeWidth: strokeWidth,
        width: squareSize,
        x: cx - r,
        y: cy - r
      });
    } else {
      return _react["default"].createElement("circle", {
        cx: cx,
        cy: cy,
        fill: fill,
        r: r,
        strokeWidth: strokeWidth
      });
    }
  }

  ActiveDot.proptypes = {
    cx: _propTypes["default"].number.required,
    cy: _propTypes["default"].number.required,
    fill: _propTypes["default"].string.required,
    r: _propTypes["default"].number.required,
    shape: _propTypes["default"].oneOf(['square', 'circle']),
    strokeWidth: _propTypes["default"].number.required
  };
  /**
   * Component to customize the content of recharts Line#dot
   * http://recharts.org/en-US/api/Line#dot
   */

  function Dot(props) {
    var cx = props.cx,
        cy = props.cy,
        fill = props.fill,
        r = props.r,
        shape = props.shape;

    if (cy === null) {
      return null;
    } else if (shape === 'square') {
      var squareSize = r * 2;
      return _react["default"].createElement("rect", {
        fill: fill,
        height: squareSize,
        width: squareSize,
        x: cx - r,
        y: cy - r
      });
    } else {
      return _react["default"].createElement("circle", {
        cx: cx,
        cy: cy,
        fill: fill,
        r: r
      });
    }
  }

  Dot.proptypes = {
    cx: _propTypes["default"].number.required,
    cy: _propTypes["default"].number.required,
    fill: _propTypes["default"].string.required,
    r: _propTypes["default"].number.required,
    shape: _propTypes["default"].oneOf(['circle', 'square'])
  };
  //# sourceMappingURL=CustomDots.js.map
});
//# sourceMappingURL=CustomDots.js.map