Liferay.Loader.define('analytics-reports-web$lodash-es@4.17.15/_baseFill', ['module', 'exports', 'require'], function (module, exports, require) {
  var define = undefined;
  import toInteger from './toInteger.js';
  import toLength from './toLength.js';

  /**
   * The base implementation of `_.fill` without an iteratee call guard.
   *
   * @private
   * @param {Array} array The array to fill.
   * @param {*} value The value to fill `array` with.
   * @param {number} [start=0] The start position.
   * @param {number} [end=array.length] The end position.
   * @returns {Array} Returns `array`.
   */
  function baseFill(array, value, start, end) {
    var length = array.length;

    start = toInteger(start);
    if (start < 0) {
      start = -start > length ? 0 : length + start;
    }
    end = end === undefined || end > length ? length : toInteger(end);
    if (end < 0) {
      end += length;
    }
    end = start > end ? 0 : toLength(end);
    while (start < end) {
      array[start++] = value;
    }
    return array;
  }

  export default baseFill;
});
//# sourceMappingURL=_baseFill.js.map