/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.analytics.reports.document.library.internal.info.item;

import com.liferay.analytics.reports.info.item.AnalyticsReportsInfoItem;
import com.liferay.analytics.reports.layout.display.page.info.item.LayoutDisplayPageObjectProviderAnalyticsReportsInfoItem;
import com.liferay.document.library.kernel.service.DLFileEntryLocalService;
import com.liferay.info.field.InfoFieldValue;
import com.liferay.info.item.InfoItemFieldValues;
import com.liferay.info.item.InfoItemReference;
import com.liferay.info.item.InfoItemServiceTracker;
import com.liferay.info.item.provider.InfoItemFieldValuesProvider;
import com.liferay.info.type.WebImage;
import com.liferay.layout.display.page.LayoutDisplayPageObjectProvider;
import com.liferay.layout.display.page.LayoutDisplayPageProvider;
import com.liferay.layout.display.page.LayoutDisplayPageProviderTracker;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.UserModel;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.service.LayoutLocalService;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.Portal;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={AnalyticsReportsInfoItem.class})
public class FileEntryAnalyticsReportsInfoItem
implements AnalyticsReportsInfoItem<FileEntry> {
    @Reference
    private DLFileEntryLocalService _dlFileEntryLocalService;
    @Reference
    private InfoItemServiceTracker _infoItemServiceTracker;
    @Reference
    private LayoutDisplayPageObjectProviderAnalyticsReportsInfoItem _layoutDisplayPageObjectProviderAnalyticsReportsInfoItem;
    @Reference
    private LayoutDisplayPageProviderTracker _layoutDisplayPageProviderTracker;
    @Reference
    private LayoutLocalService _layoutLocalService;
    @Reference
    private Portal _portal;
    @Reference
    private UserLocalService _userLocalService;

    public List<AnalyticsReportsInfoItem.Action> getActions() {
        return Arrays.asList(AnalyticsReportsInfoItem.Action.HISTORICAL_VIEWS, AnalyticsReportsInfoItem.Action.TOTAL_VIEWS, AnalyticsReportsInfoItem.Action.TRAFFIC_CHANNELS);
    }

    public String getAuthorName(FileEntry fileEntry) {
        return this._getUser(fileEntry).map(User::getFullName).orElse("");
    }

    public long getAuthorUserId(FileEntry fileEntity) {
        return this._getUser(fileEntity).map(UserModel::getUserId).orElse(0L);
    }

    public WebImage getAuthorWebImage(FileEntry fileEntry, Locale locale) {
        InfoItemFieldValuesProvider infoItemFieldValuesProvider = (InfoItemFieldValuesProvider)this._infoItemServiceTracker.getFirstInfoItemService(InfoItemFieldValuesProvider.class, FileEntry.class.getName());
        InfoItemFieldValues infoItemFieldValues = infoItemFieldValuesProvider.getInfoItemFieldValues((Object)fileEntry);
        InfoFieldValue authorProfileImageInfoFieldValue = infoItemFieldValues.getInfoFieldValue("authorProfileImage");
        return (WebImage)authorProfileImageInfoFieldValue.getValue(locale);
    }

    public List<Locale> getAvailableLocales(FileEntry fileEntry) {
        return this._layoutDisplayPageObjectProviderAnalyticsReportsInfoItem.getAvailableLocales(this._getLayoutDisplayPageObjectProvider(fileEntry));
    }

    public String getCanonicalURL(FileEntry fileEntry, Locale locale) {
        return this._layoutDisplayPageObjectProviderAnalyticsReportsInfoItem.getCanonicalURL(this._getLayoutDisplayPageObjectProvider(fileEntry), locale);
    }

    public Locale getDefaultLocale(FileEntry fileEntry) {
        return this._layoutDisplayPageObjectProviderAnalyticsReportsInfoItem.getDefaultLocale(this._getLayoutDisplayPageObjectProvider(fileEntry));
    }

    public Date getPublishDate(FileEntry fileEntry) {
        return this._layoutDisplayPageObjectProviderAnalyticsReportsInfoItem.getPublishDate(this._getLayoutDisplayPageObjectProvider(fileEntry));
    }

    public String getTitle(FileEntry fileEntry, Locale locale) {
        return this._layoutDisplayPageObjectProviderAnalyticsReportsInfoItem.getTitle(this._getLayoutDisplayPageObjectProvider(fileEntry), locale);
    }

    public boolean isShow(FileEntry fileEntry) {
        return this._layoutDisplayPageObjectProviderAnalyticsReportsInfoItem.isShow(this._getLayoutDisplayPageObjectProvider(fileEntry));
    }

    private LayoutDisplayPageObjectProvider<FileEntry> _getLayoutDisplayPageObjectProvider(FileEntry fileEntry) {
        LayoutDisplayPageProvider layoutDisplayPageProvider = this._layoutDisplayPageProviderTracker.getLayoutDisplayPageProviderByClassName(FileEntry.class.getName());
        if (layoutDisplayPageProvider == null) {
            return null;
        }
        return layoutDisplayPageProvider.getLayoutDisplayPageObjectProvider(new InfoItemReference(FileEntry.class.getName(), fileEntry.getPrimaryKey()));
    }

    private Optional<User> _getUser(FileEntry fileEntry) {
        return Optional.ofNullable(this._userLocalService.fetchUser(fileEntry.getUserId()));
    }
}

