/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.analytics.reports.document.library.internal.info.item;

import com.liferay.analytics.reports.info.item.AnalyticsReportsInfoItem;
import com.liferay.info.field.InfoFieldValue;
import com.liferay.info.item.InfoItemFieldValues;
import com.liferay.info.item.InfoItemReference;
import com.liferay.info.item.InfoItemServiceRegistry;
import com.liferay.info.item.provider.InfoItemFieldValuesProvider;
import com.liferay.info.type.WebImage;
import com.liferay.layout.display.page.LayoutDisplayPageObjectProvider;
import com.liferay.layout.display.page.LayoutDisplayPageProvider;
import com.liferay.layout.display.page.LayoutDisplayPageProviderRegistry;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.Portal;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={AnalyticsReportsInfoItem.class})
public class FileEntryAnalyticsReportsInfoItem
implements AnalyticsReportsInfoItem<FileEntry> {
    @Reference
    private InfoItemServiceRegistry _infoItemServiceRegistry;
    @Reference(target="(model.class.name=com.liferay.layout.display.page.LayoutDisplayPageObjectProvider)")
    private AnalyticsReportsInfoItem<LayoutDisplayPageObjectProvider> _layoutDisplayPageObjectProviderAnalyticsReportsInfoItem;
    @Reference
    private LayoutDisplayPageProviderRegistry _layoutDisplayPageProviderRegistry;
    @Reference
    private Portal _portal;
    @Reference
    private UserLocalService _userLocalService;

    public List<AnalyticsReportsInfoItem.Action> getActions() {
        return Arrays.asList(AnalyticsReportsInfoItem.Action.HISTORICAL_VIEWS, AnalyticsReportsInfoItem.Action.TOTAL_VIEWS, AnalyticsReportsInfoItem.Action.TRAFFIC_CHANNELS);
    }

    public String getAuthorName(FileEntry fileEntry) {
        User user = this._getUser(fileEntry);
        if (user == null) {
            return "";
        }
        return user.getFullName();
    }

    public long getAuthorUserId(FileEntry fileEntity) {
        User user = this._getUser(fileEntity);
        if (user == null) {
            return 0L;
        }
        return user.getUserId();
    }

    public WebImage getAuthorWebImage(FileEntry fileEntry, Locale locale) {
        InfoItemFieldValuesProvider infoItemFieldValuesProvider = (InfoItemFieldValuesProvider)this._infoItemServiceRegistry.getFirstInfoItemService(InfoItemFieldValuesProvider.class, FileEntry.class.getName());
        InfoItemFieldValues infoItemFieldValues = infoItemFieldValuesProvider.getInfoItemFieldValues((Object)fileEntry);
        InfoFieldValue authorProfileImageInfoFieldValue = infoItemFieldValues.getInfoFieldValue("authorProfileImage");
        return (WebImage)authorProfileImageInfoFieldValue.getValue(locale);
    }

    public List<Locale> getAvailableLocales(FileEntry fileEntry) {
        return this._layoutDisplayPageObjectProviderAnalyticsReportsInfoItem.getAvailableLocales(this._getLayoutDisplayPageObjectProvider(fileEntry));
    }

    public String getCanonicalURL(FileEntry fileEntry, Locale locale) {
        return this._layoutDisplayPageObjectProviderAnalyticsReportsInfoItem.getCanonicalURL(this._getLayoutDisplayPageObjectProvider(fileEntry), locale);
    }

    public Locale getDefaultLocale(FileEntry fileEntry) {
        return this._layoutDisplayPageObjectProviderAnalyticsReportsInfoItem.getDefaultLocale(this._getLayoutDisplayPageObjectProvider(fileEntry));
    }

    public Date getPublishDate(FileEntry fileEntry) {
        return this._layoutDisplayPageObjectProviderAnalyticsReportsInfoItem.getPublishDate(this._getLayoutDisplayPageObjectProvider(fileEntry));
    }

    public String getTitle(FileEntry fileEntry, Locale locale) {
        return this._layoutDisplayPageObjectProviderAnalyticsReportsInfoItem.getTitle(this._getLayoutDisplayPageObjectProvider(fileEntry), locale);
    }

    public boolean isShow(FileEntry fileEntry) {
        return this._layoutDisplayPageObjectProviderAnalyticsReportsInfoItem.isShow(this._getLayoutDisplayPageObjectProvider(fileEntry));
    }

    private LayoutDisplayPageObjectProvider<FileEntry> _getLayoutDisplayPageObjectProvider(FileEntry fileEntry) {
        LayoutDisplayPageProvider layoutDisplayPageProvider = this._layoutDisplayPageProviderRegistry.getLayoutDisplayPageProviderByClassName(FileEntry.class.getName());
        if (layoutDisplayPageProvider == null) {
            return null;
        }
        return layoutDisplayPageProvider.getLayoutDisplayPageObjectProvider(new InfoItemReference(FileEntry.class.getName(), fileEntry.getPrimaryKey()));
    }

    private User _getUser(FileEntry fileEntry) {
        return this._userLocalService.fetchUser(fileEntry.getUserId());
    }
}

