/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.analytics.cms.rest.internal.resource.v1_0;

import com.liferay.analytics.cms.rest.dto.v1_0.ConnectionInfo;
import com.liferay.analytics.cms.rest.internal.resource.v1_0.BaseConnectionInfoResourceImpl;
import com.liferay.analytics.cms.rest.resource.v1_0.ConnectionInfoResource;
import com.liferay.analytics.settings.configuration.AnalyticsConfiguration;
import com.liferay.analytics.settings.rest.manager.AnalyticsSettingsManager;
import com.liferay.depot.model.DepotEntryGroupRelModel;
import com.liferay.depot.service.DepotEntryGroupRelLocalService;
import com.liferay.depot.service.DepotEntryLocalService;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(properties={"OSGI-INF/liferay/rest/v1_0/connection-info.properties"}, scope=ServiceScope.PROTOTYPE, service={ConnectionInfoResource.class})
public class ConnectionInfoResourceImpl
extends BaseConnectionInfoResourceImpl {
    @Reference
    private AnalyticsSettingsManager _analyticsSettingsManager;
    @Reference
    private DepotEntryGroupRelLocalService _depotEntryGroupRelLocalService;
    @Reference
    private DepotEntryLocalService _depotEntryLocalService;

    @Override
    public ConnectionInfo getConnectionInfo(Long depotEntryGroupId) throws Exception {
        AnalyticsConfiguration analyticsConfiguration = this._analyticsSettingsManager.getAnalyticsConfiguration(this.contextUser.getCompanyId());
        List<Long> groupIds = this.transform(this._depotEntryGroupRelLocalService.getDepotEntryGroupRels(this._depotEntryLocalService.getGroupDepotEntry(depotEntryGroupId.longValue())), DepotEntryGroupRelModel::getToGroupId);
        return this._toConnectionInfo(this.roleLocalService.hasUserRole(this.contextUser.getUserId(), this.contextUser.getCompanyId(), "Administrator", true), !Validator.isBlank((String)analyticsConfiguration.token()), !groupIds.isEmpty(), this._hasSitesSyncedToAnalyticsCloud(analyticsConfiguration.syncedGroupIds(), groupIds));
    }

    private boolean _hasSitesSyncedToAnalyticsCloud(String[] analyticsCloudSyncedGroupIds, List<Long> groupIds) {
        for (long groupId : groupIds) {
            if (!ArrayUtil.contains((Object[])analyticsCloudSyncedGroupIds, (Object)String.valueOf(groupId))) continue;
            return true;
        }
        return false;
    }

    private ConnectionInfo _toConnectionInfo(boolean admin, boolean connectedToAnalyticsCloud, boolean connectedToSpace, boolean siteSyncedToAnalyticsCloud) {
        ConnectionInfo connectionInfo = new ConnectionInfo();
        connectionInfo.setAdmin(() -> admin);
        connectionInfo.setConnectedToAnalyticsCloud(() -> connectedToAnalyticsCloud);
        connectionInfo.setConnectedToSpace(() -> connectedToSpace);
        connectionInfo.setSiteSyncedToAnalyticsCloud(() -> siteSyncedToAnalyticsCloud);
        return connectionInfo;
    }
}

