/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.analytics.cms.rest.internal.resource.v1_0;

import com.liferay.analytics.cms.rest.dto.v1_0.Overview;
import com.liferay.analytics.cms.rest.dto.v1_0.Trend;
import com.liferay.analytics.cms.rest.internal.resource.v1_0.BaseOverviewResourceImpl;
import com.liferay.analytics.cms.rest.resource.v1_0.OverviewResource;
import com.liferay.asset.entry.rel.model.AssetEntryAssetCategoryRelTable;
import com.liferay.asset.kernel.model.AssetCategoryTable;
import com.liferay.asset.kernel.model.AssetEntries_AssetTagsTable;
import com.liferay.asset.kernel.model.AssetEntryTable;
import com.liferay.asset.kernel.model.AssetTagGroupRelTable;
import com.liferay.asset.kernel.model.AssetTagTable;
import com.liferay.asset.kernel.model.AssetVocabularyGroupRelTable;
import com.liferay.asset.kernel.model.AssetVocabularyTable;
import com.liferay.depot.model.DepotEntry;
import com.liferay.depot.model.DepotEntryGroupRel;
import com.liferay.depot.service.DepotEntryGroupRelLocalService;
import com.liferay.depot.service.DepotEntryService;
import com.liferay.object.model.ObjectDefinitionTable;
import com.liferay.object.model.ObjectEntryTable;
import com.liferay.object.model.ObjectEntryVersionTable;
import com.liferay.object.model.ObjectFolderTable;
import com.liferay.object.service.ObjectEntryLocalService;
import com.liferay.petra.sql.dsl.DSLFunctionFactoryUtil;
import com.liferay.petra.sql.dsl.DSLQueryFactoryUtil;
import com.liferay.petra.sql.dsl.Table;
import com.liferay.petra.sql.dsl.expression.Expression;
import com.liferay.petra.sql.dsl.expression.Predicate;
import com.liferay.petra.sql.dsl.query.DSLQuery;
import com.liferay.petra.sql.dsl.query.GroupByStep;
import com.liferay.petra.sql.dsl.spi.expression.DSLFunction;
import com.liferay.petra.sql.dsl.spi.expression.DSLFunctionType;
import com.liferay.petra.sql.dsl.spi.expression.Scalar;
import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.dao.db.DBManagerUtil;
import com.liferay.portal.kernel.dao.db.DBType;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.DateFormatFactoryUtil;
import com.liferay.portal.kernel.util.DateUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.vulcan.pagination.Pagination;
import com.liferay.portal.vulcan.util.SearchUtil;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(properties={"OSGI-INF/liferay/rest/v1_0/overview.properties"}, scope=ServiceScope.PROTOTYPE, service={OverviewResource.class})
public class OverviewResourceImpl
extends BaseOverviewResourceImpl {
    private static final Log _log = LogFactoryUtil.getLog(OverviewResourceImpl.class);
    @Reference
    private DepotEntryGroupRelLocalService _depotEntryGroupRelLocalService;
    @Reference
    private DepotEntryService _depotEntryService;
    @Reference
    private ObjectEntryLocalService _objectEntryLocalService;

    @Override
    public Overview getContentOverview(Long depotEntryId, String languageId, String rangeEnd, Integer rangeKey, String rangeStart) throws Exception {
        List<DepotEntry> depotEntries = this._getDepotEntries(depotEntryId);
        if (depotEntries.isEmpty()) {
            return this._toOverview(0L, Trend.Classification.NEUTRAL, 0.0, 0L, 0L, 0L);
        }
        Long[] groupIds = this._getGroupIds(depotEntries);
        return this._toOverview(this._getOverviewObjects("L_CMS_CONTENT_STRUCTURES", groupIds, languageId, rangeEnd, rangeKey, rangeStart), this._getPreviousTotalCount("L_CMS_CONTENT_STRUCTURES", groupIds, languageId, rangeEnd, rangeKey, rangeStart));
    }

    @Override
    public Overview getFileOverview(Long depotEntryId, String languageId, String rangeEnd, Integer rangeKey, String rangeStart) throws Exception {
        List<DepotEntry> depotEntries = this._getDepotEntries(depotEntryId);
        if (depotEntries.isEmpty()) {
            return this._toOverview(0L, Trend.Classification.NEUTRAL, 0.0, 0L, 0L, 0L);
        }
        Long[] groupIds = this._getGroupIds(depotEntries);
        return this._toOverview(this._getOverviewObjects("L_CMS_FILE_TYPES", groupIds, languageId, rangeEnd, rangeKey, rangeStart), this._getPreviousTotalCount("L_CMS_FILE_TYPES", groupIds, languageId, rangeEnd, rangeKey, rangeStart));
    }

    private DateFormat _getDateFormat() {
        return DateFormatFactoryUtil.getSimpleDateFormat((String)"yyyy-MM-dd");
    }

    private List<DepotEntry> _getDepotEntries(Long depotEntryId) throws Exception {
        ArrayList<DepotEntry> depotEntries = new ArrayList<DepotEntry>();
        if (depotEntryId == null) {
            depotEntries.addAll(this._getViewableDepotEntries());
        } else {
            depotEntries.add(this._depotEntryService.getDepotEntry(depotEntryId.longValue()));
        }
        return depotEntries;
    }

    private Date _getEndDate(String rangeEnd) {
        try {
            Calendar calendar = Calendar.getInstance();
            DateFormat dateFormat = this._getDateFormat();
            calendar.setTime(dateFormat.parse(rangeEnd));
            calendar.set(11, 23);
            calendar.set(14, 59);
            calendar.set(12, 59);
            calendar.set(13, 59);
            return calendar.getTime();
        }
        catch (ParseException parseException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)parseException);
            }
            return null;
        }
    }

    private Long[] _getGroupIds(List<DepotEntry> depotEntries) {
        Object[] groupIds = new Long[]{};
        for (DepotEntry depotEntry : depotEntries) {
            groupIds = (Long[])ArrayUtil.append((Object[])groupIds, (Object)depotEntry.getGroupId());
            List depotEntryGroupRels = this._depotEntryGroupRelLocalService.getDepotEntryGroupRels(depotEntry);
            for (DepotEntryGroupRel depotEntryGroupRel : depotEntryGroupRels) {
                groupIds = (Long[])ArrayUtil.append((Object[])groupIds, (Object)depotEntryGroupRel.getGroupId());
            }
        }
        return groupIds;
    }

    private Object[] _getOverviewObjects(String externalReferenceCode, Long[] groupIds, String languageId, String rangeEnd, Integer rangeKey, String rangeStart) {
        GroupByStep dslQuery;
        List results;
        AssetCategoryTable assetCategoryTable = AssetCategoryTable.INSTANCE;
        AssetEntries_AssetTagsTable assetEntriesAssetTagsTable = AssetEntries_AssetTagsTable.INSTANCE;
        AssetEntryAssetCategoryRelTable assetEntryAssetCategoryRelTable = AssetEntryAssetCategoryRelTable.INSTANCE;
        AssetEntryTable assetEntryTable = AssetEntryTable.INSTANCE;
        AssetTagTable assetTagTable = AssetTagTable.INSTANCE;
        AssetTagGroupRelTable assetTagGroupRelTable = AssetTagGroupRelTable.INSTANCE;
        AssetVocabularyTable assetVocabularyTable = AssetVocabularyTable.INSTANCE;
        AssetVocabularyGroupRelTable assetVocabularyGroupRelTable = AssetVocabularyGroupRelTable.INSTANCE;
        ObjectDefinitionTable objectDefinitionTable = ObjectDefinitionTable.INSTANCE;
        ObjectEntryTable objectEntryTable = ObjectEntryTable.INSTANCE;
        ObjectEntryVersionTable objectEntryVersionTable = ObjectEntryVersionTable.INSTANCE;
        ObjectFolderTable objectFolderTable = ObjectFolderTable.INSTANCE;
        Object[] assetGroupIds = groupIds;
        if (ArrayUtil.isNotEmpty((Object[])groupIds)) {
            assetGroupIds = (Long[])ArrayUtil.append((Object[])assetGroupIds, (Object)-1L);
        }
        if ((results = (List)this._objectEntryLocalService.dslQuery((DSLQuery)(dslQuery = DSLQueryFactoryUtil.select((Expression[])new Expression[]{DSLFunctionFactoryUtil.countDistinct((Expression)assetEntryAssetCategoryRelTable.assetCategoryId).as("categoriesCount"), DSLFunctionFactoryUtil.countDistinct((Expression)assetEntriesAssetTagsTable.tagId).as("tagsCount"), DSLFunctionFactoryUtil.count((Expression)objectEntryTable.objectEntryId).as("totalCount"), DSLFunctionFactoryUtil.countDistinct((Expression)assetCategoryTable.vocabularyId).as("vocabulariesCount")}).from((Table)objectFolderTable).innerJoinON((Table)objectDefinitionTable, objectDefinitionTable.objectFolderId.eq((Expression)objectFolderTable.objectFolderId)).innerJoinON((Table)objectEntryTable, objectEntryTable.objectDefinitionId.eq((Expression)objectDefinitionTable.objectDefinitionId)).innerJoinON((Table)objectEntryVersionTable, objectEntryVersionTable.objectEntryId.eq((Expression)objectEntryTable.objectEntryId).and((Expression)objectEntryVersionTable.version.eq((Expression)objectEntryTable.version)).and((Expression)objectEntryVersionTable.status.eq((Object)0))).innerJoinON((Table)assetEntryTable, assetEntryTable.classPK.eq((Expression)objectEntryTable.objectEntryId)).leftJoinOn((Table)assetEntriesAssetTagsTable, assetEntriesAssetTagsTable.entryId.eq((Expression)assetEntryTable.entryId)).leftJoinOn((Table)assetTagTable, assetTagTable.tagId.eq((Expression)assetEntriesAssetTagsTable.tagId)).leftJoinOn((Table)assetTagGroupRelTable, assetTagGroupRelTable.tagId.eq((Expression)assetTagTable.tagId).and((Expression)assetTagGroupRelTable.groupId.in(assetGroupIds))).leftJoinOn((Table)assetEntryAssetCategoryRelTable, assetEntryAssetCategoryRelTable.assetEntryId.eq((Expression)assetEntryTable.entryId)).leftJoinOn((Table)assetCategoryTable, assetCategoryTable.categoryId.eq((Expression)assetEntryAssetCategoryRelTable.assetCategoryId)).leftJoinOn((Table)assetVocabularyTable, assetVocabularyTable.vocabularyId.eq((Expression)assetCategoryTable.vocabularyId)).leftJoinOn((Table)assetVocabularyGroupRelTable, assetVocabularyGroupRelTable.vocabularyId.eq((Expression)assetVocabularyTable.vocabularyId).and((Expression)assetVocabularyGroupRelTable.groupId.in(assetGroupIds))).where(this._getWhereClause(externalReferenceCode, groupIds, languageId, false, rangeEnd, rangeKey, rangeStart))))).isEmpty()) {
            return new Object[]{0, 0, 0, 0};
        }
        return (Object[])results.get(0);
    }

    private Date _getPreviousStartDate(String rangeEnd, Integer rangeKey, String rangeStart) {
        Calendar calendar = Calendar.getInstance();
        if (Validator.isNotNull((String)rangeEnd) && Validator.isNotNull((String)rangeStart)) {
            try {
                calendar.setTime(this._getStartDate(null, rangeStart));
                DateFormat dateFormat = this._getDateFormat();
                int delta = DateUtil.getDaysBetween((Date)dateFormat.parse(rangeStart), (Date)dateFormat.parse(rangeEnd));
                calendar.add(5, -delta);
            }
            catch (ParseException parseException) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Throwable)parseException);
                }
            }
        } else {
            calendar.add(5, -(rangeKey * 2));
        }
        calendar.set(11, 0);
        calendar.set(14, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        return calendar.getTime();
    }

    private long _getPreviousTotalCount(String externalReferenceCode, Long[] groupIds, String languageId, String rangeEnd, Integer rangeKey, String rangeStart) {
        AssetEntryTable assetEntryTable = AssetEntryTable.INSTANCE;
        ObjectDefinitionTable objectDefinitionTable = ObjectDefinitionTable.INSTANCE;
        ObjectEntryTable objectEntryTable = ObjectEntryTable.INSTANCE;
        ObjectEntryVersionTable objectEntryVersionTable = ObjectEntryVersionTable.INSTANCE;
        ObjectFolderTable objectFolderTable = ObjectFolderTable.INSTANCE;
        GroupByStep dslQuery = DSLQueryFactoryUtil.select((Expression[])new Expression[]{DSLFunctionFactoryUtil.count((Expression)objectEntryTable.objectEntryId).as("totalCount")}).from((Table)objectFolderTable).innerJoinON((Table)objectDefinitionTable, objectDefinitionTable.objectFolderId.eq((Expression)objectFolderTable.objectFolderId)).innerJoinON((Table)objectEntryTable, objectEntryTable.objectDefinitionId.eq((Expression)objectDefinitionTable.objectDefinitionId)).innerJoinON((Table)objectEntryVersionTable, objectEntryVersionTable.objectEntryId.eq((Expression)objectEntryTable.objectEntryId).and((Expression)objectEntryVersionTable.version.eq((Expression)objectEntryTable.version)).and((Expression)objectEntryVersionTable.status.eq((Object)0))).innerJoinON((Table)assetEntryTable, assetEntryTable.classPK.eq((Expression)objectEntryTable.objectEntryId)).where(this._getWhereClause(externalReferenceCode, groupIds, languageId, true, rangeEnd, rangeKey, rangeStart));
        List results = (List)this._objectEntryLocalService.dslQuery((DSLQuery)dslQuery);
        if (results.isEmpty()) {
            return 0L;
        }
        return GetterUtil.getLong(results.get(0));
    }

    private <T> Expression<T> _getPropertyValueExpression(Expression<T> expression, String propertyName) {
        DB db = DBManagerUtil.getDB();
        if (db.getDBType() == DBType.MYSQL || db.getDBType() == DBType.MARIADB) {
            return new DSLFunction(new DSLFunctionType("JSON_EXTRACT(", ")"), new Expression[]{expression, new Scalar((Object)propertyName)});
        }
        return new DSLFunction(new DSLFunctionType("JSON_QUERY(", ")"), new Expression[]{expression, new Scalar((Object)propertyName)});
    }

    private Date _getStartDate(Integer rangeKey, String rangeStart) {
        Calendar calendar = Calendar.getInstance();
        if (Validator.isNotNull((String)rangeStart)) {
            try {
                DateFormat dateFormat = this._getDateFormat();
                calendar.setTime(dateFormat.parse(rangeStart));
            }
            catch (ParseException parseException) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Throwable)parseException);
                }
            }
        } else {
            calendar.add(5, -rangeKey.intValue());
        }
        calendar.set(11, 0);
        calendar.set(14, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        return calendar.getTime();
    }

    private List<DepotEntry> _getViewableDepotEntries() throws Exception {
        ArrayList<DepotEntry> depotEntries = new ArrayList<DepotEntry>();
        SearchUtil.search(Collections.emptyMap(), booleanQuery -> {}, null, (String)DepotEntry.class.getName(), null, (Pagination)Pagination.of((int)-1, (int)-1), queryConfig -> {}, searchContext -> searchContext.setCompanyId(this.contextCompany.getCompanyId()), null, document -> {
            block2: {
                try {
                    depotEntries.add(this._depotEntryService.getDepotEntry(GetterUtil.getLong((String)document.get("entryClassPK"))));
                }
                catch (PortalException portalException) {
                    if (!_log.isInfoEnabled()) break block2;
                    _log.info((Object)("User does not have access to view space " + document.get("entryClassPK")), (Throwable)portalException);
                }
            }
            return null;
        });
        return depotEntries;
    }

    private Predicate _getWhereClause(String externalReferenceCode, Long[] groupIds, String languageId, boolean previous, String rangeEnd, Integer rangeKey, String rangeStart) {
        Predicate predicate = ObjectFolderTable.INSTANCE.externalReferenceCode.eq((Object)externalReferenceCode);
        predicate = predicate.and((Expression)ObjectEntryTable.INSTANCE.status.neq((Object)8));
        if (ArrayUtil.isNotEmpty((Object[])groupIds)) {
            predicate = predicate.and((Expression)ObjectEntryTable.INSTANCE.groupId.in((Object[])groupIds));
        }
        if (!Validator.isBlank((String)languageId)) {
            predicate = predicate.and((Expression)this._getPropertyValueExpression((Expression)ObjectEntryVersionTable.INSTANCE.content, "$.properties").like("%\"" + languageId + "\":%"));
        }
        if (!previous) {
            predicate = predicate.and((Expression)ObjectEntryTable.INSTANCE.createDate.gte((Object)this._getStartDate(rangeKey, rangeStart)));
            if (Validator.isNotNull((String)rangeEnd)) {
                predicate = predicate.and((Expression)ObjectEntryTable.INSTANCE.createDate.lte((Object)this._getEndDate(rangeEnd)));
            }
        } else {
            predicate = predicate.and((Expression)ObjectEntryTable.INSTANCE.createDate.gte((Object)this._getPreviousStartDate(rangeEnd, rangeKey, rangeStart))).and((Expression)ObjectEntryTable.INSTANCE.createDate.lt((Object)this._getStartDate(rangeKey, rangeStart)));
        }
        return predicate;
    }

    private Overview _toOverview(long categoriesCount, Trend.Classification classification, double percentage, long tagsCount, long totalCount, long vocabulariesCount) {
        Overview overview = new Overview();
        overview.setCategoriesCount(() -> categoriesCount);
        overview.setTagsCount(() -> tagsCount);
        overview.setTotalCount(() -> totalCount);
        Trend trend = new Trend();
        trend.setClassification(() -> classification);
        trend.setPercentage(() -> percentage);
        overview.setTrend(() -> trend);
        overview.setVocabulariesCount(() -> vocabulariesCount);
        return overview;
    }

    private Overview _toOverview(Object[] objects, long previousTotalCount) {
        long categoriesCount = (Long)objects[0];
        long tagsCount = (Long)objects[1];
        long totalCount = (Long)objects[2];
        long vocabulariesCount = (Long)objects[3];
        Trend.Classification classification = Trend.Classification.NEUTRAL;
        double percentage = 0.0;
        if (previousTotalCount > 0L) {
            double diff = totalCount - previousTotalCount;
            percentage = diff / (double)previousTotalCount * 100.0;
            if (percentage > 0.0) {
                classification = Trend.Classification.POSITIVE;
            } else if (percentage < 0.0) {
                classification = Trend.Classification.NEGATIVE;
            }
        } else if (totalCount > 0L) {
            classification = Trend.Classification.POSITIVE;
            percentage = 100.0;
        }
        return this._toOverview(categoriesCount, classification, percentage, tagsCount, totalCount, vocabulariesCount);
    }
}

