/*
 * Decompiled with CFR 0.152.
 */
package graphql.normalized;

import graphql.Assert;
import graphql.Internal;
import graphql.Mutable;
import graphql.collect.ImmutableKit;
import graphql.com.google.common.collect.ImmutableList;
import graphql.com.google.common.collect.ImmutableMap;
import graphql.introspection.Introspection;
import graphql.language.Argument;
import graphql.normalized.NormalizedInputValue;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLInterfaceType;
import graphql.schema.GraphQLNamedOutputType;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLSchema;
import graphql.schema.GraphQLType;
import graphql.schema.GraphQLTypeUtil;
import graphql.schema.GraphQLUnionType;
import graphql.util.FpKit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Internal
@Mutable
public class ExecutableNormalizedField {
    private final String alias;
    private final ImmutableMap<String, NormalizedInputValue> normalizedArguments;
    private final LinkedHashMap<String, Object> resolvedArguments;
    private final ImmutableList<Argument> astArguments;
    private final LinkedHashSet<String> objectTypeNames;
    private final ArrayList<ExecutableNormalizedField> children;
    private ExecutableNormalizedField parent;
    private final String fieldName;
    private final int level;

    private ExecutableNormalizedField(Builder builder) {
        this.alias = builder.alias;
        this.resolvedArguments = builder.resolvedArguments;
        this.normalizedArguments = builder.normalizedArguments;
        this.astArguments = builder.astArguments;
        this.objectTypeNames = builder.objectTypeNames;
        this.fieldName = Assert.assertNotNull(builder.fieldName);
        this.children = builder.children;
        this.level = builder.level;
        this.parent = builder.parent;
    }

    public boolean isConditional(@NotNull GraphQLSchema schema) {
        if (this.parent == null) {
            return false;
        }
        ImmutableList<GraphQLType> parentTypes = ImmutableKit.map(this.parent.getFieldDefinitions(schema), fd -> GraphQLTypeUtil.unwrapAll(fd.getType()));
        LinkedHashSet interfacesImplementedByAllParents = null;
        for (GraphQLType parentType : parentTypes) {
            ArrayList<GraphQLNamedOutputType> toAdd = new ArrayList<GraphQLNamedOutputType>();
            if (parentType instanceof GraphQLObjectType) {
                toAdd.addAll(((GraphQLObjectType)parentType).getInterfaces());
            } else if (parentType instanceof GraphQLInterfaceType) {
                toAdd.add((GraphQLInterfaceType)parentType);
                toAdd.addAll(((GraphQLInterfaceType)parentType).getInterfaces());
            }
            if (interfacesImplementedByAllParents == null) {
                interfacesImplementedByAllParents = new LinkedHashSet(toAdd);
                continue;
            }
            interfacesImplementedByAllParents.retainAll(toAdd);
        }
        for (GraphQLInterfaceType parentInterfaceType : interfacesImplementedByAllParents) {
            List<GraphQLObjectType> implementations = schema.getImplementations(parentInterfaceType);
            if (this.fieldName.equals(Introspection.TypeNameMetaFieldDef.getName()) && implementations.size() == this.objectTypeNames.size()) {
                return false;
            }
            if (parentInterfaceType.getField(this.fieldName) == null || implementations.size() != this.objectTypeNames.size()) continue;
            return false;
        }
        List<GraphQLFieldDefinition> fieldDefinitions = this.parent.getFieldDefinitions(schema);
        if (GraphQLTypeUtil.unwrapAll(fieldDefinitions.get(0).getType()) instanceof GraphQLUnionType) {
            GraphQLUnionType parentOutputTypeAsUnion = (GraphQLUnionType)GraphQLTypeUtil.unwrapAll(fieldDefinitions.get(0).getType());
            if (this.fieldName.equals(Introspection.TypeNameMetaFieldDef.getName()) && this.objectTypeNames.size() == parentOutputTypeAsUnion.getTypes().size()) {
                return false;
            }
        }
        if (this.objectTypeNames.size() > 1) {
            return true;
        }
        if (this.parent.objectTypeNames.size() > 1) {
            return true;
        }
        GraphQLObjectType oneObjectType = (GraphQLObjectType)schema.getType((String)this.objectTypeNames.iterator().next());
        return GraphQLTypeUtil.unwrapAll(this.parent.getFieldDefinitions(schema).get(0).getType()) != oneObjectType;
    }

    public boolean hasChildren() {
        return this.children.size() > 0;
    }

    public GraphQLOutputType getType(GraphQLSchema schema) {
        List<GraphQLFieldDefinition> fieldDefinitions = this.getFieldDefinitions(schema);
        Set fieldTypes = fieldDefinitions.stream().map(fd -> GraphQLTypeUtil.simplePrint(fd.getType())).collect(Collectors.toSet());
        Assert.assertTrue(fieldTypes.size() == 1, () -> "More than one type ... use getTypes");
        return fieldDefinitions.get(0).getType();
    }

    public List<GraphQLOutputType> getTypes(GraphQLSchema schema) {
        ImmutableList<GraphQLOutputType> fieldTypes = ImmutableKit.map(this.getFieldDefinitions(schema), fd -> fd.getType());
        return fieldTypes;
    }

    public List<GraphQLFieldDefinition> getFieldDefinitions(GraphQLSchema schema) {
        GraphQLFieldDefinition fieldDefinition = ExecutableNormalizedField.resolveIntrospectionField(schema, this.objectTypeNames, this.fieldName);
        if (fieldDefinition != null) {
            return ImmutableList.of(fieldDefinition);
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        for (String objectTypeName : this.objectTypeNames) {
            GraphQLObjectType type = (GraphQLObjectType)Assert.assertNotNull(schema.getType(objectTypeName));
            builder.add(Assert.assertNotNull(type.getField(this.fieldName), () -> String.format("no field %s found for type %s", this.fieldName, this.objectTypeNames.iterator().next())));
        }
        return builder.build();
    }

    private static GraphQLFieldDefinition resolveIntrospectionField(GraphQLSchema schema, Set<String> objectTypeNames, String fieldName) {
        if (fieldName.equals(schema.getIntrospectionTypenameFieldDefinition().getName())) {
            return schema.getIntrospectionTypenameFieldDefinition();
        }
        if (objectTypeNames.size() == 1 && objectTypeNames.iterator().next().equals(schema.getQueryType().getName())) {
            if (fieldName.equals(schema.getIntrospectionSchemaFieldDefinition().getName())) {
                return schema.getIntrospectionSchemaFieldDefinition();
            }
            if (fieldName.equals(schema.getIntrospectionTypeFieldDefinition().getName())) {
                return schema.getIntrospectionTypeFieldDefinition();
            }
        }
        return null;
    }

    public void addObjectTypeNames(Collection<String> objectTypeNames) {
        this.objectTypeNames.addAll(objectTypeNames);
    }

    public void setObjectTypeNames(Collection<String> objectTypeNames) {
        this.objectTypeNames.clear();
        this.objectTypeNames.addAll(objectTypeNames);
    }

    public void addChild(ExecutableNormalizedField executableNormalizedField) {
        this.children.add(executableNormalizedField);
    }

    public void clearChildren() {
        this.children.clear();
    }

    public String getName() {
        return this.getFieldName();
    }

    public String getResultKey() {
        if (this.alias != null) {
            return this.alias;
        }
        return this.getName();
    }

    public String getAlias() {
        return this.alias;
    }

    public ImmutableList<Argument> getAstArguments() {
        return this.astArguments;
    }

    public NormalizedInputValue getNormalizedArgument(String name) {
        return this.normalizedArguments.get(name);
    }

    public ImmutableMap<String, NormalizedInputValue> getNormalizedArguments() {
        return this.normalizedArguments;
    }

    public LinkedHashMap<String, Object> getResolvedArguments() {
        return this.resolvedArguments;
    }

    public static Builder newNormalizedField() {
        return new Builder();
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public ExecutableNormalizedField transform(Consumer<Builder> builderConsumer) {
        Builder builder = new Builder(this);
        builderConsumer.accept(builder);
        return builder.build();
    }

    public Set<String> getObjectTypeNames() {
        return this.objectTypeNames;
    }

    public String getSingleObjectTypeName() {
        return (String)this.objectTypeNames.iterator().next();
    }

    public String printDetails() {
        StringBuilder result = new StringBuilder();
        if (this.getAlias() != null) {
            result.append(this.getAlias()).append(": ");
        }
        return result + this.objectTypeNamesToString() + "." + this.fieldName;
    }

    public String objectTypeNamesToString() {
        if (this.objectTypeNames.size() == 1) {
            return (String)this.objectTypeNames.iterator().next();
        }
        return this.objectTypeNames.toString();
    }

    public List<String> getListOfResultKeys() {
        LinkedList<String> list = new LinkedList<String>();
        ExecutableNormalizedField current = this;
        while (current != null) {
            list.addFirst(current.getResultKey());
            current = current.parent;
        }
        return list;
    }

    public List<ExecutableNormalizedField> getChildren() {
        return this.children;
    }

    public List<ExecutableNormalizedField> getChildrenWithSameResultKey(String resultKey) {
        return FpKit.filterList(this.children, child -> child.getResultKey().equals(resultKey));
    }

    public int getLevel() {
        return this.level;
    }

    public ExecutableNormalizedField getParent() {
        return this.parent;
    }

    public void replaceParent(ExecutableNormalizedField newParent) {
        this.parent = newParent;
    }

    public String toString() {
        return "NormalizedField{" + this.objectTypeNamesToString() + "." + this.fieldName + ", alias=" + this.alias + ", level=" + this.level + ", children=" + this.children.stream().map(ExecutableNormalizedField::toString).collect(Collectors.joining("\n")) + '}';
    }

    public List<ExecutableNormalizedField> getChildren(int includingRelativeLevel) {
        ArrayList<ExecutableNormalizedField> result = new ArrayList<ExecutableNormalizedField>();
        Assert.assertTrue(includingRelativeLevel >= 1, () -> "relative level must be >= 1");
        this.getChildren().forEach(child -> this.traverseImpl((ExecutableNormalizedField)child, result::add, 1, includingRelativeLevel));
        return result;
    }

    public void traverseSubTree(Consumer<ExecutableNormalizedField> consumer) {
        this.getChildren().forEach(child -> this.traverseImpl((ExecutableNormalizedField)child, consumer, 1, Integer.MAX_VALUE));
    }

    private void traverseImpl(ExecutableNormalizedField root, Consumer<ExecutableNormalizedField> consumer, int curRelativeLevel, int abortAfter) {
        if (curRelativeLevel > abortAfter) {
            return;
        }
        consumer.accept(root);
        root.getChildren().forEach(child -> this.traverseImpl((ExecutableNormalizedField)child, consumer, curRelativeLevel + 1, abortAfter));
    }

    public static class Builder {
        private LinkedHashSet<String> objectTypeNames = new LinkedHashSet();
        private String fieldName;
        private ArrayList<ExecutableNormalizedField> children = new ArrayList();
        private int level;
        private ExecutableNormalizedField parent;
        private String alias;
        private ImmutableMap<String, NormalizedInputValue> normalizedArguments = ImmutableKit.emptyMap();
        private LinkedHashMap<String, Object> resolvedArguments = new LinkedHashMap();
        private ImmutableList<Argument> astArguments = ImmutableKit.emptyList();

        private Builder() {
        }

        private Builder(ExecutableNormalizedField existing) {
            this.alias = existing.alias;
            this.normalizedArguments = existing.normalizedArguments;
            this.astArguments = existing.astArguments;
            this.resolvedArguments = existing.resolvedArguments;
            this.objectTypeNames = new LinkedHashSet<String>(existing.getObjectTypeNames());
            this.fieldName = existing.getFieldName();
            this.children = new ArrayList(existing.children);
            this.level = existing.getLevel();
            this.parent = existing.getParent();
        }

        public Builder clearObjectTypesNames() {
            this.objectTypeNames.clear();
            return this;
        }

        public Builder objectTypeNames(List<String> objectTypeNames) {
            this.objectTypeNames.addAll(objectTypeNames);
            return this;
        }

        public Builder alias(String alias) {
            this.alias = alias;
            return this;
        }

        public Builder normalizedArguments(@Nullable Map<String, NormalizedInputValue> arguments) {
            this.normalizedArguments = arguments == null ? ImmutableKit.emptyMap() : ImmutableMap.copyOf(arguments);
            return this;
        }

        public Builder resolvedArguments(@Nullable Map<String, Object> arguments) {
            this.resolvedArguments = arguments == null ? new LinkedHashMap() : new LinkedHashMap<String, Object>(arguments);
            return this;
        }

        public Builder astArguments(@NotNull List<Argument> astArguments) {
            this.astArguments = ImmutableList.copyOf(astArguments);
            return this;
        }

        public Builder fieldName(String fieldName) {
            this.fieldName = fieldName;
            return this;
        }

        public Builder children(List<ExecutableNormalizedField> children) {
            this.children.clear();
            this.children.addAll(children);
            return this;
        }

        public Builder level(int level) {
            this.level = level;
            return this;
        }

        public Builder parent(ExecutableNormalizedField parent) {
            this.parent = parent;
            return this;
        }

        public ExecutableNormalizedField build() {
            return new ExecutableNormalizedField(this);
        }
    }
}

