/*
 * Decompiled with CFR 0.152.
 */
package graphql.analysis;

import graphql.ExecutionResult;
import graphql.PublicApi;
import graphql.analysis.QueryDepthInfo;
import graphql.analysis.QueryTraverser;
import graphql.analysis.QueryVisitorFieldEnvironment;
import graphql.execution.AbortExecutionException;
import graphql.execution.ExecutionContext;
import graphql.execution.instrumentation.InstrumentationContext;
import graphql.execution.instrumentation.SimpleInstrumentation;
import graphql.execution.instrumentation.SimpleInstrumentationContext;
import graphql.execution.instrumentation.parameters.InstrumentationExecuteOperationParameters;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PublicApi
public class MaxQueryDepthInstrumentation
extends SimpleInstrumentation {
    private static final Logger log = LoggerFactory.getLogger(MaxQueryDepthInstrumentation.class);
    private final int maxDepth;
    private final Function<QueryDepthInfo, Boolean> maxQueryDepthExceededFunction;

    public MaxQueryDepthInstrumentation(int maxDepth) {
        this(maxDepth, queryDepthInfo -> true);
    }

    public MaxQueryDepthInstrumentation(int maxDepth, Function<QueryDepthInfo, Boolean> maxQueryDepthExceededFunction) {
        this.maxDepth = maxDepth;
        this.maxQueryDepthExceededFunction = maxQueryDepthExceededFunction;
    }

    @Override
    public InstrumentationContext<ExecutionResult> beginExecuteOperation(InstrumentationExecuteOperationParameters parameters) {
        QueryDepthInfo queryDepthInfo;
        boolean throwAbortException;
        QueryTraverser queryTraverser = this.newQueryTraverser(parameters.getExecutionContext());
        int depth = queryTraverser.reducePreOrder((env, acc) -> Math.max(this.getPathLength(env.getParentEnvironment()), acc), 0);
        if (log.isDebugEnabled()) {
            log.debug("Query depth info: {}", (Object)depth);
        }
        if (depth > this.maxDepth && (throwAbortException = this.maxQueryDepthExceededFunction.apply(queryDepthInfo = QueryDepthInfo.newQueryDepthInfo().depth(depth).build()).booleanValue())) {
            throw this.mkAbortException(depth, this.maxDepth);
        }
        return SimpleInstrumentationContext.noOp();
    }

    protected AbortExecutionException mkAbortException(int depth, int maxDepth) {
        return new AbortExecutionException("maximum query depth exceeded " + depth + " > " + maxDepth);
    }

    QueryTraverser newQueryTraverser(ExecutionContext executionContext) {
        return QueryTraverser.newQueryTraverser().schema(executionContext.getGraphQLSchema()).document(executionContext.getDocument()).operationName(executionContext.getExecutionInput().getOperationName()).coercedVariables(executionContext.getCoercedVariables()).build();
    }

    private int getPathLength(QueryVisitorFieldEnvironment path) {
        int length = 1;
        while (path != null) {
            path = path.getParentEnvironment();
            ++length;
        }
        return length;
    }
}

