/*
 * Decompiled with CFR 0.152.
 */
package com.documentum.services.config.util;

import com.documentum.services.config.util.Trace;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

public final class StringUtil {
    static final char[] s_digits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z'};

    public static String replaceAll(String string, char c, char c2) {
        StringBuffer stringBuffer = new StringBuffer(128);
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == c) {
                stringBuffer.append(c2);
                continue;
            }
            stringBuffer.append(string.charAt(i));
        }
        return stringBuffer.toString();
    }

    public static String replace(String string, char[] cArray, char c) {
        StringBuffer stringBuffer = new StringBuffer(string);
        for (int i = 0; i < stringBuffer.length(); ++i) {
            for (int j = 0; j < cArray.length; ++j) {
                if (stringBuffer.charAt(i) != cArray[j]) continue;
                stringBuffer.setCharAt(i, c);
            }
        }
        return stringBuffer.toString();
    }

    public static String replace(String string, String string2, String string3) {
        if (string == null || string2 == null || string3 == null) {
            throw new IllegalArgumentException("StringUtil.replace(...) null paramater passed");
        }
        int n = string.indexOf(string2);
        if (n == -1) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(string.length());
        int n2 = string2.length();
        int n3 = 0;
        do {
            if (n > n3) {
                stringBuffer.append(string.substring(n3, n));
            }
            n3 = n + n2;
            stringBuffer.append(string3);
        } while ((n = string.indexOf(string2, n3)) != -1);
        if (n3 < string.length()) {
            stringBuffer.append(string.substring(n3));
        }
        return stringBuffer.toString();
    }

    public static String[] split(String string, String string2) {
        String[] stringArray = null;
        int n = string.indexOf(string2);
        if (n == -1) {
            stringArray = new String[]{string};
        } else {
            ArrayList<String> arrayList = new ArrayList<String>(5);
            int n2 = 0;
            String string3 = null;
            while (n != -1) {
                string3 = string.substring(n2, n);
                arrayList.add(string3);
                n2 = n + string2.length();
                if ((n = string.indexOf(string2, n2)) != -1) continue;
                string3 = string.substring(n2);
                arrayList.add(string3);
            }
            stringArray = new String[arrayList.size()];
            arrayList.toArray(stringArray);
        }
        return stringArray;
    }

    public static Vector splitString(String string, String string2) {
        Vector<String> vector = new Vector<String>();
        int n = string.indexOf(string2);
        if (n == -1) {
            vector.addElement(string);
        } else {
            int n2 = 0;
            String string3 = null;
            while (n != -1) {
                string3 = string.substring(n2, n);
                vector.addElement(string3);
                n2 = n + string2.length();
                if ((n = string.indexOf(string2, n2)) != -1) continue;
                string3 = string.substring(n2);
                vector.addElement(string3);
            }
        }
        return vector;
    }

    public static String escape(String string, char c) {
        int n;
        if (string != null && (n = string.indexOf(c)) > -1) {
            int n2 = string.length();
            StringBuffer stringBuffer = new StringBuffer(n2 + 10);
            int n3 = 0;
            for (int i = 0; i < n2; ++i) {
                char c2 = string.charAt(i);
                if (n3 != 92 && c2 == c) {
                    stringBuffer.append('\\');
                }
                stringBuffer.append(c2);
                n3 = c2;
            }
            string = stringBuffer.toString();
        }
        return string;
    }

    public static String unicodeEscape(String string) {
        StringBuffer stringBuffer = new StringBuffer(string.length() + 16);
        char[] cArray = string.toCharArray();
        block4: for (int i = 0; i < cArray.length; ++i) {
            if (cArray[i] == '%') {
                stringBuffer.append("%25");
                continue;
            }
            String string2 = Integer.toHexString(cArray[i]);
            switch (string2.length()) {
                case 1: 
                case 2: {
                    if (cArray[i] >= '\u0000' && cArray[i] < '\u0080') {
                        stringBuffer.append(cArray[i]);
                        continue block4;
                    }
                    stringBuffer.append('%').append(string2);
                    continue block4;
                }
                case 3: {
                    stringBuffer.append("%u0").append(string2);
                    continue block4;
                }
                default: {
                    stringBuffer.append("%u").append(string2);
                }
            }
        }
        return stringBuffer.toString();
    }

    public static String unicodeUnescape(String string) {
        int n = string.length();
        char[] cArray = new char[n];
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            char c = string.charAt(n3);
            boolean bl = false;
            if (c == '%' && n3 < n - 2) {
                char c2;
                String string2;
                if (string.charAt(n3 + 1) != 'u') {
                    try {
                        string2 = string.substring(n3 + 1, n3 + 3);
                        c2 = (char)Integer.parseInt(string2, 16);
                        bl = true;
                        n3 += 3;
                        cArray[n2] = c2;
                        ++n2;
                    }
                    catch (NumberFormatException numberFormatException) {}
                } else if (n3 < n - 5) {
                    try {
                        string2 = string.substring(n3 + 2, n3 + 6);
                        c2 = (char)Integer.parseInt(string2, 16);
                        bl = true;
                        n3 += 6;
                        cArray[n2] = c2;
                        ++n2;
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            }
            if (bl) continue;
            cArray[n2] = c;
            ++n2;
            ++n3;
        }
        return new String(cArray, 0, n2);
    }

    public static boolean isIntegerString(String string, String string2) {
        try {
            Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            Trace.error(StringUtil.class, string2 + ": " + string, numberFormatException);
            return false;
        }
        return true;
    }

    public static boolean isLongString(String string, String string2) {
        try {
            Long.parseLong(string);
        }
        catch (NumberFormatException numberFormatException) {
            Trace.error(StringUtil.class, string2 + ": " + string, numberFormatException);
            return false;
        }
        return true;
    }

    public static String toUnsignedString(int n, int n2) {
        char[] cArray = new char[32];
        int n3 = 32;
        int n4 = 1 << n2;
        int n5 = n4 - 1;
        do {
            cArray[--n3] = s_digits[n & n5];
        } while ((n >>>= n2) != 0);
        return new String(cArray, n3, 32 - n3);
    }

    public static String toUnsignedString(long l, int n) {
        char[] cArray = new char[64];
        int n2 = 64;
        int n3 = 1 << n;
        long l2 = n3 - 1;
        do {
            cArray[--n2] = s_digits[(int)(l & l2)];
        } while ((l >>>= n) != 0L);
        return new String(cArray, n2, 64 - n2);
    }

    public static String concatenate(String[] stringArray, char c) {
        if (stringArray == null || stringArray.length == 0) {
            return null;
        }
        String string = null;
        if (stringArray.length == 1) {
            string = stringArray[0];
        } else {
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < stringArray.length; ++i) {
                stringBuffer.append(c);
                stringBuffer.append(stringArray[i]);
            }
            string = stringBuffer.substring(1);
        }
        return string;
    }

    public static String join(List list, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        if (list != null && list.size() > 0) {
            for (int i = 0; i < list.size() - 1; ++i) {
                stringBuffer.append(list.get(i));
                stringBuffer.append(string);
            }
            stringBuffer.append(list.get(list.size() - 1));
        }
        return stringBuffer.toString();
    }
}

