/*
 * Decompiled with CFR 0.152.
 */
package com.documentum.services.config.role;

import com.documentum.services.config.IConfigElement;
import com.documentum.services.config.IConfigService;
import com.documentum.services.config.IConfigServiceConsumer;
import com.documentum.services.config.IContext;
import com.documentum.services.config.IRoleModelAdaptor;
import com.documentum.services.config.common.Context;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RoleService {
    private static IRoleModelAdaptor s_iRoleModel = null;
    private static boolean s_fIsInitilizing = false;
    private static String s_strDomainName = null;
    private static final String[] EMPTY_ROLES_ARRAY = new String[0];

    public static String getParentRole(String string, IConfigService iConfigService) {
        String string2 = null;
        if (RoleService.isInitialized(iConfigService)) {
            String string3 = RoleService.getUsername(iConfigService);
            string2 = RoleService.getRoleModel(iConfigService).getParentRole(string3, string);
        }
        return string2;
    }

    public static String getUserRole(String string, IConfigService iConfigService) {
        String string2 = null;
        if (RoleService.isInitialized(iConfigService)) {
            if (string == null || string.length() < 1) {
                string = RoleService.getUsername(iConfigService);
            }
            string2 = RoleService.getRoleModel(iConfigService).getUserRole(string);
        }
        return string2;
    }

    public static boolean isUserAssignedRole(String string, String string2, IConfigService iConfigService, IContext iContext) {
        boolean bl = false;
        if (RoleService.isInitialized(iConfigService)) {
            if (string == null || string.length() == 0) {
                string = RoleService.getUsername(iConfigService);
            }
            bl = RoleService.getRoleModel(iConfigService).isUserAssignedRole(string, string2, iContext);
        }
        return bl;
    }

    public static String[] getUserRoles(String string, IConfigService iConfigService) {
        String[] stringArray = EMPTY_ROLES_ARRAY;
        if (RoleService.isInitialized(iConfigService)) {
            if (string == null || string.length() < 1) {
                string = RoleService.getUsername(iConfigService);
            }
            stringArray = RoleService.getRoleModel(iConfigService).getUserRoles(string);
        }
        return stringArray;
    }

    public static List<String> getUserAllRoles(String string, IConfigService iConfigService) {
        ArrayList<String> arrayList = new ArrayList<String>();
        String[] stringArray = RoleService.getUserRoles(string, iConfigService);
        if (stringArray != null && stringArray.length > 0) {
            ArrayList<String> arrayList2;
            List<String> list = Arrays.asList(stringArray);
            arrayList.addAll(list);
            do {
                arrayList2 = new ArrayList<String>();
                for (String string2 : list) {
                    String string3 = RoleService.getParentRole(string2, iConfigService);
                    if (string3 == null || arrayList.contains(string3)) continue;
                    arrayList.add(string3);
                    arrayList2.add(string3);
                }
            } while ((list = arrayList2).size() > 0);
        }
        return arrayList;
    }

    public static String getDomain() {
        return s_strDomainName;
    }

    private static synchronized IRoleModelAdaptor getRoleModel(IConfigService iConfigService) {
        if (s_iRoleModel == null) {
            s_fIsInitilizing = true;
            IConfigElement iConfigElement = iConfigService.getConfigLookup().lookupElement("application.rolemodel", (IContext)Context.getApplicationContext());
            if (iConfigElement == null) {
                throw new RuntimeException("application.rolemodel not specified in app.xml");
            }
            String string = iConfigElement.getChildValue("class");
            if (string == null) {
                throw new RuntimeException("application.rolemodel.class not specified in app.xml");
            }
            RoleService.initDomain(iConfigService);
            try {
                Class<?> clazz = Class.forName(string);
                s_iRoleModel = (IRoleModelAdaptor)clazz.newInstance();
                if (s_iRoleModel instanceof IConfigServiceConsumer) {
                    ((IConfigServiceConsumer)s_iRoleModel).setConfigService(iConfigService);
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new RuntimeException(classNotFoundException.getMessage());
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new RuntimeException(illegalAccessException.getMessage());
            }
            catch (InstantiationException instantiationException) {
                throw new RuntimeException(instantiationException.getMessage());
            }
            s_fIsInitilizing = false;
        }
        return s_iRoleModel;
    }

    private static String getUsername(IConfigService iConfigService) {
        return iConfigService.getDocbaseContext().getCurrentUserName();
    }

    private static synchronized boolean isInitialized(IConfigService iConfigService) {
        return !s_fIsInitilizing && iConfigService.getDocbaseContext().isCurrentDocbaseConnected();
    }

    private static void initDomain(IConfigService iConfigService) {
        String string = iConfigService.getConfigLookup().lookupString("application.rolemodel.domain", (IContext)Context.getApplicationContext());
        if (string != null && (string = string.trim()).length() > 0) {
            s_strDomainName = string;
        }
    }
}

