/*
 * Decompiled with CFR 0.152.
 */
package com.documentum.services.config.reader;

import com.documentum.com.DfClientX;
import com.documentum.fc.client.DfService;
import com.documentum.fc.client.DfServiceException;
import com.documentum.fc.client.IDfEnumeration;
import com.documentum.fc.client.IDfFolder;
import com.documentum.fc.client.IDfPersistentObject;
import com.documentum.fc.client.IDfSession;
import com.documentum.fc.client.IDfSysObject;
import com.documentum.fc.common.DfException;
import com.documentum.fc.common.DfUtil;
import com.documentum.fc.common.IDfId;
import com.documentum.fc.common.IDfList;
import com.documentum.operations.IDfExportNode;
import com.documentum.operations.IDfExportOperation;
import com.documentum.services.config.ConfigException;
import com.documentum.services.config.IConfigFile;
import com.documentum.services.config.IConfigService;
import com.documentum.services.config.IDocbaseConfigReader;
import com.documentum.services.config.util.Trace;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DocbaseConfigReader
extends DfService
implements IDocbaseConfigReader {
    private IConfigService m_configService;
    private String m_primaryAppFolderName;
    private String m_docbaseRootFolderPath;
    private String m_localRootFolderPath;
    private String m_docbaseName;
    private static DfClientX m_dfClient = new DfClientX();

    public void initialize(String string, String string2, String string3) {
        if (string == null) {
            throw new ConfigException("A docbase name is required.");
        }
        this.m_docbaseName = string;
        this.initialize(string2, string3);
        this.m_localRootFolderPath = this.getLocalRootFolderPath(string2);
    }

    public void initialize(String string, String string2) {
        this.m_docbaseRootFolderPath = string;
        this.m_primaryAppFolderName = string2;
    }

    public String getAppName() {
        return this.m_primaryAppFolderName;
    }

    public String getRootFolderPath() {
        return this.m_localRootFolderPath;
    }

    private String getLocalRootFolderPath(String string) throws ConfigException {
        try {
            IDfExportOperation iDfExportOperation = m_dfClient.getExportOperation();
            String string2 = iDfExportOperation.getDefaultDestinationDirectory();
            File file = new File(string2, string);
            if (!file.exists()) {
                file.mkdirs();
            }
            return file.getAbsolutePath();
        }
        catch (Exception exception) {
            throw new ConfigException("Can not get local root folder path for export.", (Throwable)exception);
        }
    }

    public IConfigFile loadAppConfigFile(String string) {
        IDfSession iDfSession = null;
        try {
            iDfSession = this.getSession(this.m_docbaseName);
            String string2 = string + "/app.xml";
            IDfPersistentObject iDfPersistentObject = iDfSession.getObjectByPath(this.m_docbaseRootFolderPath + string2);
            if (iDfPersistentObject == null) {
                throw new ConfigException("App Config file is missing!");
            }
            IDfExportOperation iDfExportOperation = m_dfClient.getExportOperation();
            iDfExportOperation.setSession(iDfSession);
            IDfExportNode iDfExportNode = (IDfExportNode)iDfExportOperation.add((Object)iDfPersistentObject);
            File file = new File(this.m_localRootFolderPath, string2);
            File file2 = file.getParentFile();
            if (!file2.exists()) {
                file2.mkdirs();
            }
            iDfExportNode.setFilePath(file.getAbsolutePath());
            if (iDfExportOperation.execute()) {
                IConfigFile iConfigFile = this.m_configService.newConfigFile(iDfExportNode.getFilePath());
                return iConfigFile;
            }
        }
        catch (Exception exception) {
            throw new ConfigException("Could not load export operation.", (Throwable)exception);
        }
        finally {
            this.releaseDfSession(iDfSession);
        }
        return null;
    }

    public Iterable<IConfigFile> loadConfigFiles(String string) {
        IDfSession iDfSession = null;
        ArrayList<IConfigFile> arrayList = new ArrayList<IConfigFile>(100);
        try {
            IDfId iDfId;
            iDfSession = this.getSession(this.m_docbaseName);
            List<IDfSysObject> list = this.queryFileList(string, iDfSession);
            IDfExportOperation iDfExportOperation = m_dfClient.getExportOperation();
            iDfExportOperation.setSession(iDfSession);
            String string2 = iDfExportOperation.getDefaultDestinationDirectory();
            for (IDfSysObject iDfSysObject : list) {
                iDfId = iDfSysObject.getFolderId(0);
                IDfFolder iDfFolder = (IDfFolder)iDfSession.getObject(iDfId);
                String string3 = iDfFolder.getFolderPath(0);
                File file = new File(string2, string3 + "/" + iDfSysObject.getObjectName());
                File file2 = file.getParentFile();
                if (!file2.exists()) {
                    file2.mkdirs();
                }
                IDfExportNode iDfExportNode = (IDfExportNode)iDfExportOperation.add((Object)iDfSysObject);
                iDfExportNode.setFilePath(file.getAbsolutePath());
            }
            if (iDfExportOperation.execute()) {
                IDfList iDfList = iDfExportOperation.getNodes();
                for (int i = 0; i < iDfList.getCount(); ++i) {
                    iDfId = (IDfExportNode)iDfList.get(i);
                    arrayList.add(this.m_configService.newConfigFile(iDfId.getFilePath()));
                }
            }
        }
        catch (DfException dfException) {
            throw new ConfigException("Could not load export operation.", (Throwable)dfException);
        }
        finally {
            this.releaseDfSession(iDfSession);
        }
        return arrayList;
    }

    public void setConfigService(IConfigService iConfigService) {
        this.m_configService = iConfigService;
    }

    private List<IDfSysObject> queryFileList(String string, IDfSession iDfSession) throws DfException {
        ArrayList<IDfSysObject> arrayList = new ArrayList<IDfSysObject>(100);
        String string2 = "select for read r_object_id,r_object_type,r_aspect_name,i_is_reference,i_is_replica,i_vstamp from dm_document where folder('" + this.m_docbaseRootFolderPath + DfUtil.escapeQuotedString((String)string) + "/config', descend) " + "and a_content_type='xml'";
        IDfEnumeration iDfEnumeration = iDfSession.getObjectsByQuery(string2, "dm_document");
        while (iDfEnumeration.hasMoreElements()) {
            arrayList.add((IDfSysObject)iDfEnumeration.nextElement());
        }
        return arrayList;
    }

    private void releaseDfSession(IDfSession iDfSession) {
        try {
            if (iDfSession != null) {
                this.releaseSession(iDfSession);
            }
        }
        catch (DfServiceException dfServiceException) {
            Trace.println((Object)this, "Fail to release IDfSession: " + dfServiceException.getMessage());
        }
    }
}

