/*
 * Decompiled with CFR 0.152.
 */
package com.documentum.services.config.qualifiers;

import com.documentum.fc.client.DfService;
import com.documentum.services.config.IConfigElement;
import com.documentum.services.config.IConfigLookup;
import com.documentum.services.config.IConfigRefreshListener;
import com.documentum.services.config.IConfigService;
import com.documentum.services.config.IConfigServiceConsumer;
import com.documentum.services.config.IContext;
import com.documentum.services.config.IQualifier;
import com.documentum.services.config.common.Context;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;

public final class VersionQualifier
extends DfService
implements IQualifier,
IConfigRefreshListener,
IConfigServiceConsumer {
    public static final String PREFERRED_VERSION = "preferredVersion";
    private static final String SUPPORTED_VERSIONS_CONFIG_PATH = "application.supported_versions";
    private static final String VERSION_ELEMENT = "version";
    private static Map s_olderVersionMap = null;
    private static boolean s_fIsInitilizing = false;
    private static final String[] CONTEXT_NAMES = new String[]{"preferredVersion"};
    private IConfigService m_configService;

    public String[] getContextNames() {
        return CONTEXT_NAMES;
    }

    public String getScopeName() {
        return VERSION_ELEMENT;
    }

    public String getScopeValue(IContext iContext) {
        String string = iContext.get(PREFERRED_VERSION);
        string = string != null && string.length() > 0 && !string.equals("latest") ? "fixed_" + string : "latest";
        return string;
    }

    public String getParentScopeValue(String string) {
        if (string.startsWith("fixed_")) {
            return "latest";
        }
        return this.getOlderVersion(string);
    }

    public String[] getAliasScopeValues(String string) {
        return null;
    }

    public void setConfigService(IConfigService iConfigService) {
        this.m_configService = iConfigService;
    }

    private String getOlderVersion(String string) {
        boolean bl;
        if (s_olderVersionMap == null && (bl = this.initVersionMap())) {
            return null;
        }
        return (String)s_olderVersionMap.get(string);
    }

    public synchronized void onPostRefresh() {
        this.m_configService.removeRefreshListener((IConfigRefreshListener)this);
        s_olderVersionMap = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized boolean initVersionMap() {
        if (s_fIsInitilizing) {
            return true;
        }
        if (s_olderVersionMap == null) {
            s_fIsInitilizing = true;
            try {
                IConfigLookup iConfigLookup = this.m_configService.getConfigLookup();
                IConfigElement iConfigElement = iConfigLookup.lookupElement(SUPPORTED_VERSIONS_CONFIG_PATH, (IContext)new Context());
                if (iConfigElement != null) {
                    Iterator iterator = iConfigElement.getChildElements(VERSION_ELEMENT);
                    Hashtable<String, String> hashtable = new Hashtable<String, String>();
                    String string = "latest";
                    while (iterator.hasNext()) {
                        IConfigElement iConfigElement2 = (IConfigElement)iterator.next();
                        String string2 = iConfigElement2.getValue();
                        hashtable.put(string, string2);
                        string = string2;
                    }
                    if (!hashtable.isEmpty()) {
                        s_olderVersionMap = hashtable;
                        this.m_configService.addRefreshListener((IConfigRefreshListener)this);
                    }
                }
                if (s_olderVersionMap == null) {
                    throw new IllegalStateException("Missing application.supported_versions or application.supported_versions.version element in app.xml");
                }
            }
            finally {
                s_fIsInitilizing = false;
            }
        }
        return false;
    }
}

