/*
 * Decompiled with CFR 0.152.
 */
package com.documentum.services.config.qualifiers;

import com.documentum.fc.client.DfService;
import com.documentum.fc.client.IDfPersistentObject;
import com.documentum.fc.client.IDfSession;
import com.documentum.fc.client.aspect.IDfAspects;
import com.documentum.fc.common.DfException;
import com.documentum.fc.common.DfId;
import com.documentum.fc.common.IDfId;
import com.documentum.fc.common.IDfList;
import com.documentum.services.config.IConfigService;
import com.documentum.services.config.IConfigServiceConsumer;
import com.documentum.services.config.IContext;
import com.documentum.services.config.IQualifier;
import com.documentum.services.config.util.Trace;

public class AspectQualifier
extends DfService
implements IQualifier,
IConfigServiceConsumer {
    private IConfigService m_configService = null;
    private static final String ASPECT = "aspect";
    private static final String OBJECTID = "objectId";
    private static final String[] CONTEXT_NAMES = new String[]{"aspect", "objectId"};

    public String[] getContextNames() {
        return CONTEXT_NAMES;
    }

    public String getScopeName() {
        return ASPECT;
    }

    public String getScopeValue(IContext iContext) {
        String string;
        block4: {
            DfId dfId;
            String string2;
            string = iContext.get(ASPECT);
            if ((string == null || string.length() == 0) && (string2 = iContext.get(OBJECTID)) != null && string2.length() != 0 && (dfId = new DfId(string2)).isObjectId()) {
                try {
                    IDfPersistentObject iDfPersistentObject;
                    IDfSession iDfSession = this.m_configService.getDocbaseContext().getCurrentDfSession();
                    if (iDfSession != null && (iDfPersistentObject = iDfSession.getObjectWithCaching((IDfId)dfId, null, null, "check_never", false, false)) != null) {
                        string = AspectQualifier.getAspectNamesFromObj(iDfPersistentObject);
                    }
                }
                catch (DfException dfException) {
                    if (!Trace.QUALIFIER) break block4;
                    Trace.println((Object)this, "AspectQualifier.getScopeValue(...) Warning - failed to get aspect names from Id: " + string2 + ", DFC exception: " + dfException.getMessage());
                }
            }
        }
        return string;
    }

    public String getParentScopeValue(String string) {
        return null;
    }

    public String[] getAliasScopeValues(String string) {
        return null;
    }

    public void setConfigService(IConfigService iConfigService) {
        this.m_configService = iConfigService;
    }

    private static String getAspectNamesFromObj(IDfPersistentObject iDfPersistentObject) throws DfException {
        StringBuilder stringBuilder = new StringBuilder();
        if (iDfPersistentObject instanceof IDfAspects) {
            IDfList iDfList = ((IDfAspects)iDfPersistentObject).getAspects();
            for (int i = 0; i < iDfList.getCount(); ++i) {
                stringBuilder.append(iDfList.get(i));
                stringBuilder.append(",");
            }
            if (stringBuilder.length() > 0) {
                stringBuilder.deleteCharAt(stringBuilder.length() - 1);
            }
        }
        return stringBuilder.toString();
    }
}

