/*
 * Decompiled with CFR 0.152.
 */
package com.documentum.services.config.nls;

import com.documentum.services.config.INlsReader;
import com.documentum.services.config.nls.LocaleService;
import com.documentum.services.config.nls.NlsResourceClass;
import com.documentum.services.config.util.Trace;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;

public final class NlsResourceBundle
extends NlsResourceClass {
    protected String m_strBundleName;
    private static String STR_INCLUDES = "NLS_INCLUDES";
    private static HashMap s_hashCachedBundle = new HashMap(101);
    private static Map s_nlsStringCache = new Hashtable();
    private static int MAX_BUNDLES_SEARCHED = 3;
    private static final String NULL_STRING_SENTINEL = "null string sentinel";
    private static final Object BUNDLE_NOT_FOUND_SENTINEL = new Object();
    private static ResourceBundle s_bundle = null;

    public NlsResourceBundle(String string) {
        this.m_strBundleName = string;
    }

    public boolean stringExists(String string, Locale locale) {
        boolean bl = false;
        String string2 = this.getBundleName();
        if (string2 != null && string2.length() > 0) {
            bl = this.getStringInternal(string2, string, locale, new HashSet(11), false) != null;
        }
        return bl;
    }

    public String getString(String string, Locale locale) {
        return this.getString(string, locale, false);
    }

    public String getString(String string, Locale locale, boolean bl) {
        String string2 = null;
        String string3 = this.getBundleName();
        if (string3 != null && string3.length() > 0 && (string2 = this.getStringInternal(string3, string, locale, new HashSet(11), bl)) == null) {
            string2 = this.getFallbackResourceString(string, string3, locale);
        }
        return string2;
    }

    public String getString(int n, Locale locale) {
        return this.getString(Integer.toString(n), locale);
    }

    public String getBundleName() {
        return this.m_strBundleName;
    }

    private ResourceBundle loadLocaleBundle(String string, Locale locale) throws IOException {
        PropertyResourceBundle propertyResourceBundle = null;
        INlsReader iNlsReader = this.getConfigService().getNlsReader();
        if (iNlsReader != null) {
            Vector vector = NlsResourceBundle.calculateBundleNames(string, locale);
            int n = vector.size();
            for (int i = n - 1; i > -1; --i) {
                String string2 = (String)vector.elementAt(i);
                InputStream inputStream = iNlsReader.getResourceAsStream(string2);
                if (inputStream == null) continue;
                propertyResourceBundle = new PropertyResourceBundle(inputStream);
                inputStream.close();
                break;
            }
        }
        return propertyResourceBundle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResourceBundle loadBundle(String string, Locale locale) throws IOException {
        Object object;
        HashMap hashMap;
        ResourceBundle resourceBundle;
        block9: {
            resourceBundle = this.loadLocaleBundle(string, locale);
            if (resourceBundle == null && (Locale.ENGLISH.getLanguage().equals(locale.getLanguage()) || LocaleService.fallbackToEnglishLocale(this.getConfigService())) && (hashMap = this.getConfigService().getNlsReader()) != null && (object = hashMap.getResourceAsStream(string)) != null) {
                resourceBundle = new PropertyResourceBundle((InputStream)object);
                ((InputStream)object).close();
            }
            if (resourceBundle == null) {
                try {
                    resourceBundle = ResourceBundle.getBundle(string, locale);
                }
                catch (MissingResourceException missingResourceException) {
                    if (!Locale.ENGLISH.getLanguage().equals(locale.getLanguage()) && !LocaleService.fallbackToEnglishLocale(this.getConfigService())) break block9;
                    throw missingResourceException;
                }
            }
        }
        hashMap = s_hashCachedBundle;
        synchronized (hashMap) {
            object = NlsResourceBundle.getCacheKey(string, locale);
            if (resourceBundle != null) {
                s_hashCachedBundle.put(object, resourceBundle);
            } else {
                s_hashCachedBundle.put(object, BUNDLE_NOT_FOUND_SENTINEL);
            }
        }
        return resourceBundle;
    }

    public ResourceBundle getBundle(String string) {
        return this.getBundle(string, Locale.getDefault());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResourceBundle getBundle(String string, Locale locale) {
        ResourceBundle resourceBundle = null;
        try {
            String string2 = NlsResourceBundle.getCacheKey(string, locale);
            Object var5_6 = null;
            HashMap hashMap = s_hashCachedBundle;
            synchronized (hashMap) {
                var5_6 = s_hashCachedBundle.get(string2);
            }
            if (var5_6 == BUNDLE_NOT_FOUND_SENTINEL) {
                resourceBundle = null;
            } else if (var5_6 != null) {
                resourceBundle = var5_6;
            } else {
                resourceBundle = this.loadBundle(string, locale);
                if (resourceBundle == null) {
                    Trace.println("Missing resource bundle: " + string);
                }
            }
        }
        catch (IOException iOException) {
            Trace.println("Missing resource bundle: " + string);
        }
        return resourceBundle;
    }

    private String getStringInternal(String string, String string2, Locale locale, HashSet hashSet, boolean bl) {
        String string3 = new StringBuffer(string2).append(NlsResourceBundle.getCacheKey(string, locale)).toString();
        String string4 = null;
        string4 = (String)s_nlsStringCache.get(string3);
        if (string4 == null) {
            string4 = this.getStringFromBundle(string, string2, locale, hashSet, bl);
            if (string4 != null) {
                s_nlsStringCache.put(string3, string4);
            } else {
                s_nlsStringCache.put(string3, NULL_STRING_SENTINEL);
            }
        }
        if (string4 == NULL_STRING_SENTINEL) {
            return null;
        }
        return string4;
    }

    private static String getCacheKey(String string, Locale locale) {
        StringBuffer stringBuffer = new StringBuffer(string);
        String string2 = locale.toString();
        if (string2.length() != 0) {
            stringBuffer.append(string2);
        } else if (locale.getVariant().length() != 0) {
            stringBuffer.append('_').append(locale.getVariant());
        }
        return stringBuffer.toString();
    }

    private static Vector calculateBundleNames(String string, Locale locale) {
        String string2;
        int n;
        String string3;
        int n2;
        Vector<String> vector = new Vector<String>(MAX_BUNDLES_SEARCHED);
        String string4 = locale.getLanguage();
        int n3 = string4.length();
        if (n3 + (n2 = (string3 = locale.getCountry()).length()) + (n = (string2 = locale.getVariant()).length()) == 0) {
            return vector;
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        stringBuffer.append('_');
        stringBuffer.append(string4);
        vector.addElement(stringBuffer.toString());
        if (n2 + n != 0) {
            stringBuffer.append('_');
            stringBuffer.append(string3);
            vector.addElement(stringBuffer.toString());
            if (n != 0) {
                stringBuffer.append('_');
                stringBuffer.append(string2);
                vector.addElement(stringBuffer.toString());
            }
        } else if (n2 == 0) {
            String string5 = null;
            if (s_bundle != null) {
                string5 = NlsResourceBundle.lookupCountryCode(string4);
                stringBuffer.append('_');
                stringBuffer.append(string5);
                vector.addElement(stringBuffer.toString());
            }
        }
        return vector;
    }

    public static String lookupCountryCode(String string) {
        String string2 = null;
        try {
            if (s_bundle != null) {
                string2 = s_bundle.getString(string);
            }
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        return string2;
    }

    public Iterator getKeys(Locale locale) {
        HashSet hashSet = new HashSet(17);
        String string = this.getBundleName();
        if (string != null && string.length() > 0) {
            this.buildKeysInternal(hashSet, string, locale, new HashSet(11));
        }
        return hashSet.iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void clearStringCache() {
        Map map = s_nlsStringCache;
        synchronized (map) {
            s_nlsStringCache.clear();
        }
    }

    private void buildKeysInternal(HashSet hashSet, String string, Locale locale, HashSet hashSet2) {
        if (!hashSet2.contains(string)) {
            hashSet2.add(string);
            ResourceBundle resourceBundle = this.getBundle(string, locale);
            if (resourceBundle != null) {
                String string2;
                Enumeration<String> enumeration = resourceBundle.getKeys();
                while (enumeration.hasMoreElements()) {
                    string2 = enumeration.nextElement();
                    if (hashSet.contains(string2)) continue;
                    hashSet.add(string2);
                }
                string2 = null;
                try {
                    string2 = resourceBundle.getString(STR_INCLUDES);
                }
                catch (MissingResourceException missingResourceException) {
                    // empty catch block
                }
                if (string2 != null && string2.length() > 0) {
                    StringTokenizer stringTokenizer = new StringTokenizer(string2, ",;");
                    while (stringTokenizer.hasMoreTokens()) {
                        String string3 = stringTokenizer.nextToken().trim();
                        if (string3 == null || string3.length() <= 0) continue;
                        this.buildKeysInternal(hashSet, string3, locale, hashSet2);
                    }
                }
            }
        }
        hashSet.remove(STR_INCLUDES);
    }

    private String getStringFromBundle(String string, String string2, Locale locale, HashSet hashSet, boolean bl) {
        String string3;
        block7: {
            string3 = null;
            if (!hashSet.contains(string)) {
                hashSet.add(string);
                ResourceBundle resourceBundle = this.getBundle(string, locale);
                if (resourceBundle != null) {
                    try {
                        string3 = bl ? resourceBundle.getString(string2) : NlsResourceBundle.alterString(resourceBundle.getString(string2));
                    }
                    catch (MissingResourceException missingResourceException) {
                        String string4 = null;
                        try {
                            string4 = resourceBundle.getString(STR_INCLUDES);
                        }
                        catch (MissingResourceException missingResourceException2) {
                            // empty catch block
                        }
                        if (string4 == null || string4.length() <= 0) break block7;
                        StringTokenizer stringTokenizer = new StringTokenizer(string4, ",;");
                        while (string3 == null && stringTokenizer.hasMoreTokens()) {
                            String string5 = stringTokenizer.nextToken().trim();
                            if (string5 == null || string5.length() <= 0) continue;
                            string3 = this.getStringFromBundle(string5, string2, locale, hashSet, bl);
                        }
                    }
                }
            }
        }
        return string3;
    }

    static {
        if (s_bundle == null) {
            try {
                s_bundle = ResourceBundle.getBundle(NlsResourceBundle.class.getName());
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
    }
}

