/*
 * Decompiled with CFR 0.152.
 */
package com.documentum.services.config.nls;

import com.documentum.services.config.IConfigLookup;
import com.documentum.services.config.IConfigService;
import com.documentum.services.config.IContext;
import com.documentum.services.config.common.Context;
import com.documentum.services.config.nls.NlsResourceBundle;
import java.util.Locale;
import java.util.StringTokenizer;

public class LocaleService {
    private static Locale s_defaultLocale = null;
    private static Boolean s_bFallbackToEnglishLocale = null;
    private static Context s_context = null;
    private static final String LOCALE_CONFIG_PATH = "application.language.default_locale";
    private static final String FALLBACK_TO_ENGLISH_CONFIG_PATH = "application.language.fallback_to_english_locale";

    public static Locale createLocale(String string) {
        Locale locale;
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException("strLocale is a mandatory parameter");
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "_");
        String string2 = stringTokenizer.nextToken();
        if (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            if (stringTokenizer.hasMoreTokens()) {
                String string4 = stringTokenizer.nextToken();
                locale = new Locale(string2, string3, string4);
            } else {
                locale = new Locale(string2, string3);
            }
        } else {
            String string5 = NlsResourceBundle.lookupCountryCode(string2);
            locale = string5 != null && string5.length() > 0 ? new Locale(string2, string5) : new Locale(string2);
        }
        return locale;
    }

    public static synchronized Locale getDefaultLocale(IConfigService iConfigService) {
        if (s_defaultLocale == null) {
            IConfigLookup iConfigLookup = iConfigService.getConfigLookup();
            String string = iConfigLookup.lookupString(LOCALE_CONFIG_PATH, (IContext)LocaleService.getContext());
            if (string != null && string.length() > 0) {
                s_defaultLocale = LocaleService.createLocale(string);
            }
            if (s_defaultLocale == null) {
                s_defaultLocale = Locale.getDefault();
            }
        }
        return s_defaultLocale;
    }

    public static synchronized boolean fallbackToEnglishLocale(IConfigService iConfigService) {
        if (s_bFallbackToEnglishLocale == null) {
            IConfigLookup iConfigLookup;
            String string;
            if (iConfigService != null && (string = (iConfigLookup = iConfigService.getConfigLookup()).lookupString(FALLBACK_TO_ENGLISH_CONFIG_PATH, (IContext)LocaleService.getContext())) != null && string.length() > 0) {
                s_bFallbackToEnglishLocale = Boolean.valueOf(string);
            }
            if (s_bFallbackToEnglishLocale == null) {
                s_bFallbackToEnglishLocale = Boolean.TRUE;
            }
        }
        return s_bFallbackToEnglishLocale;
    }

    private static synchronized Context getContext() {
        if (s_context == null) {
            s_context = new Context();
        }
        return s_context;
    }
}

