/*
 * Decompiled with CFR 0.152.
 */
package com.documentum.services.config.impl;

import com.documentum.services.config.IQualifier;
import com.documentum.services.config.impl.ConfigKey;
import com.documentum.services.config.impl.QualifierParentIterator;
import com.documentum.services.config.impl.ScopedDictionaryEntry;
import com.documentum.services.config.impl.SearchCandidate;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;

class ScopedDictionary {
    private IQualifier[] m_qualifiers;
    private HashMap m_hashElems;
    private HashMap m_hashLookup;
    private Map<String, ArrayList<ConfigKey>> m_primElemToHashLookup;
    private SortedSet m_setPrimElems;
    private ArrayList m_configEntries;
    private int m_nNextIndex;
    public static final String STAR = "*".intern();
    public static final Object NULL_SENTINEL = new Object();

    public ScopedDictionary(int n) {
        this.m_hashElems = new HashMap(n);
        this.m_hashLookup = new HashMap(n);
        this.m_primElemToHashLookup = new HashMap<String, ArrayList<ConfigKey>>(n);
        this.m_setPrimElems = new TreeSet();
        this.m_configEntries = new ArrayList(n);
        this.m_nNextIndex = 0;
    }

    public Object get(ConfigKey configKey) {
        Object object = this.m_hashLookup.get(configKey);
        if (object == null && configKey != null) {
            ConfigKey[] configKeyArray = configKey.split();
            object = configKeyArray == null || configKeyArray.length == 1 ? this.getMostRelevant(configKey) : this.getMostRelevantForMultiKeys(configKeyArray);
            if (object != null) {
                this.m_hashLookup.put(configKey, object);
            } else {
                this.m_hashLookup.put(configKey, NULL_SENTINEL);
            }
            this.trackCache(configKey);
        }
        return object;
    }

    private Object getMostRelevantForMultiKeys(ConfigKey[] configKeyArray) {
        Comparable comparable;
        ArrayList<SearchCandidate> arrayList = new ArrayList<SearchCandidate>();
        for (int i = 0; i < configKeyArray.length; ++i) {
            comparable = configKeyArray[i];
            SearchCandidate searchCandidate = this.getBestSearchCandidate((ConfigKey)comparable);
            if (searchCandidate == null || !searchCandidate.isValid()) continue;
            arrayList.add(searchCandidate);
        }
        Object object = null;
        if (arrayList.size() > 0) {
            Collections.sort(arrayList);
            comparable = (SearchCandidate)arrayList.get(0);
            object = ((ScopedDictionaryEntry)this.m_configEntries.get((int)((SearchCandidate)comparable).getIndex())).m_configElem;
        }
        return object;
    }

    public Object getExact(ConfigKey configKey) {
        return this.m_hashElems.get(configKey);
    }

    public void remove(ConfigKey configKey) {
        this.clearCache(configKey.getPrimaryElem());
        this.m_hashElems.remove(configKey);
        int n = this.getExactIndex(configKey);
        if (n >= 0) {
            this.m_setPrimElems.remove(new StringIndexPair(configKey.m_primElem, n));
            this.m_configEntries.set(n, new ScopedDictionaryEntry(configKey, NULL_SENTINEL));
        }
    }

    public void put(ConfigKey configKey, Object object) {
        this.m_hashElems.put(configKey, object);
        this.m_hashLookup.put(configKey, object);
        this.m_configEntries.add(new ScopedDictionaryEntry(configKey, object));
        this.m_setPrimElems.add(new StringIndexPair(configKey.m_primElem, this.m_nNextIndex));
        ++this.m_nNextIndex;
    }

    public Set keySet() {
        return this.m_hashElems.keySet();
    }

    public int size() {
        return this.m_hashElems.size();
    }

    public void setQualifiers(IQualifier[] iQualifierArray) {
        this.m_qualifiers = iQualifierArray;
    }

    private void trackCache(ConfigKey configKey) {
        String string = configKey.getPrimaryElem();
        if (this.m_primElemToHashLookup.containsKey(string)) {
            this.m_primElemToHashLookup.get(string).add(configKey);
        } else {
            ArrayList<ConfigKey> arrayList = new ArrayList<ConfigKey>(4);
            arrayList.add(configKey);
            this.m_primElemToHashLookup.put(string, arrayList);
        }
    }

    private void clearCache(String string) {
        ArrayList<ConfigKey> arrayList = this.m_primElemToHashLookup.get(string);
        if (arrayList != null) {
            for (ConfigKey configKey : arrayList) {
                this.m_hashLookup.remove(configKey);
            }
            this.m_primElemToHashLookup.remove(string);
        }
    }

    protected Object getMostRelevant(ConfigKey configKey) {
        Object object = null;
        int n = this.getMostRelevantIndex(configKey);
        if (n >= 0) {
            object = ((ScopedDictionaryEntry)this.m_configEntries.get((int)n)).m_configElem;
        }
        return object;
    }

    protected int getMostRelevantIndex(ConfigKey configKey) {
        int n = -1;
        SearchCandidate searchCandidate = this.getBestSearchCandidate(configKey);
        if (searchCandidate != null) {
            n = searchCandidate.getIndex();
        }
        return n;
    }

    private int getExactIndex(ConfigKey configKey) {
        if (configKey == null) {
            return -1;
        }
        String string = configKey.m_primElem;
        StringIndexPair stringIndexPair = new StringIndexPair(string, 0);
        StringIndexPair stringIndexPair2 = new StringIndexPair(string, Integer.MAX_VALUE);
        SortedSet<StringIndexPair> sortedSet = this.m_setPrimElems.subSet(stringIndexPair, stringIndexPair2);
        for (StringIndexPair stringIndexPair3 : sortedSet) {
            ScopedDictionaryEntry scopedDictionaryEntry = (ScopedDictionaryEntry)this.m_configEntries.get(stringIndexPair3.m_index);
            if (!configKey.equals(scopedDictionaryEntry.getKey())) continue;
            return stringIndexPair3.m_index;
        }
        return -1;
    }

    protected SearchCandidate getBestSearchCandidate(ConfigKey configKey) {
        SearchCandidate searchCandidate = null;
        String string = configKey.m_primElem;
        StringIndexPair stringIndexPair = new StringIndexPair(string, 0);
        StringIndexPair stringIndexPair2 = new StringIndexPair(string, Integer.MAX_VALUE);
        SortedSet<StringIndexPair> sortedSet = this.m_setPrimElems.subSet(stringIndexPair, stringIndexPair2);
        int n = this.m_qualifiers.length;
        boolean bl = sortedSet.size() > 1;
        QualifierParentIterator[] qualifierParentIteratorArray = new QualifierParentIterator[n];
        for (int i = 0; i < n; ++i) {
            qualifierParentIteratorArray[i] = new QualifierParentIterator(configKey.m_scopeKey.m_strScopeValues[i], this.m_qualifiers[i], bl);
        }
        SearchCandidate searchCandidate2 = null;
        for (StringIndexPair stringIndexPair3 : sortedSet) {
            ScopedDictionaryEntry scopedDictionaryEntry = (ScopedDictionaryEntry)this.m_configEntries.get(stringIndexPair3.m_index);
            if (searchCandidate2 == null) {
                searchCandidate2 = new SearchCandidate(stringIndexPair3.m_index, n);
            } else {
                searchCandidate2.reset();
                searchCandidate2.setIndex(stringIndexPair3.m_index);
            }
            scopedDictionaryEntry.calculateColumnMatches(qualifierParentIteratorArray, searchCandidate2);
            if (searchCandidate2.m_bValid) {
                if (searchCandidate2.getRelevanceValue().equals(BigInteger.ZERO)) {
                    return searchCandidate2;
                }
                if (searchCandidate == null) {
                    searchCandidate = searchCandidate2;
                    searchCandidate2 = null;
                } else if (searchCandidate2.compareTo(searchCandidate) < 0) {
                    SearchCandidate searchCandidate3 = searchCandidate;
                    searchCandidate = searchCandidate2;
                    searchCandidate2 = searchCandidate3;
                }
            }
            if (!bl) continue;
            for (int i = 0; i < n; ++i) {
                qualifierParentIteratorArray[i].reset();
            }
        }
        return searchCandidate;
    }

    class StringIndexPair
    implements Comparable {
        public String m_strPrimElem;
        public int m_index;

        public StringIndexPair() {
            this.m_strPrimElem = "";
            this.m_index = 0;
        }

        public StringIndexPair(String string, int n) {
            this.m_strPrimElem = string;
            this.m_index = n;
        }

        public int compareTo(Object object) {
            StringIndexPair stringIndexPair = (StringIndexPair)object;
            int n = this.m_strPrimElem == null ? (stringIndexPair.m_strPrimElem == null ? 0 : -1) : this.m_strPrimElem.compareTo(stringIndexPair.m_strPrimElem);
            if (n == 0) {
                if (this.m_index < stringIndexPair.m_index) {
                    n = -1;
                } else if (this.m_index > stringIndexPair.m_index) {
                    n = 1;
                }
            }
            return n;
        }

        public boolean equals(Object object) {
            if (object instanceof StringIndexPair) {
                StringIndexPair stringIndexPair = (StringIndexPair)object;
                return this.m_index == stringIndexPair.m_index && this.primElemsEqual(stringIndexPair.m_strPrimElem);
            }
            return false;
        }

        protected boolean primElemsEqual(String string) {
            if (this.m_strPrimElem == null) {
                return string == null;
            }
            return this.m_strPrimElem.equals(string);
        }

        public int hashCode() {
            int n = this.m_strPrimElem == null ? 0 : this.m_strPrimElem.hashCode();
            return n > 0 ? n - this.m_index : n + this.m_index;
        }

        public String toString() {
            return this.m_strPrimElem + "::" + this.m_index;
        }
    }
}

