/*
 * Decompiled with CFR 0.152.
 */
package com.documentum.services.config.impl;

import com.documentum.services.config.IContext;
import com.documentum.services.config.IQualifier;
import com.documentum.services.config.impl.BoundedContextCache;
import com.documentum.services.config.impl.QualifierContext;
import com.documentum.services.config.impl.ScopedDictionary;
import java.util.LinkedHashSet;

final class ScopeKey
implements Comparable {
    String[] m_strScopeValues;
    boolean m_bUndefine = false;
    IQualifier[] m_qualifiers;
    private static final ScopeKey[] EMPTY_SCOPEKEY_ARRAY = new ScopeKey[0];

    private ScopeKey(IQualifier[] iQualifierArray) {
        this.m_qualifiers = iQualifierArray;
        this.m_strScopeValues = new String[this.m_qualifiers.length];
    }

    public ScopeKey(QualifierContext qualifierContext, IQualifier[] iQualifierArray) {
        this(iQualifierArray);
        for (int i = 0; i < iQualifierArray.length; ++i) {
            IQualifier iQualifier = iQualifierArray[i];
            BoundedContextCache boundedContextCache = BoundedContextCache.getInstance();
            String string = boundedContextCache != null ? boundedContextCache.retrieveQualifierScopeValue(iQualifier, qualifierContext) : iQualifier.getScopeValue((IContext)qualifierContext);
            this.m_strScopeValues[i] = string == null ? null : string.intern();
        }
    }

    public ScopeKey(String[] stringArray, IQualifier[] iQualifierArray) {
        this(iQualifierArray);
        boolean bl = false;
        for (int i = 0; i < this.m_qualifiers.length; ++i) {
            String string = stringArray[i];
            if (string != null && string.toLowerCase().startsWith("not ")) {
                string = string.substring(3).trim();
                if (bl) {
                    throw new IllegalArgumentException("Illegal use of 'not' keyword in scope tag. Occurences are permitted only within a single value.");
                }
                bl = true;
            }
            this.m_strScopeValues[i] = string == null ? null : string.intern();
        }
        this.m_bUndefine = bl;
    }

    public ScopeKey(String string, IQualifier[] iQualifierArray) {
        this(iQualifierArray);
        if (string.indexOf("application") == -1) {
            throw new IllegalStateException("ConfigService:  application='...'  is required in scope descriptor: " + string);
        }
        for (int i = 0; i < this.m_qualifiers.length; ++i) {
            int n;
            IQualifier iQualifier = this.m_qualifiers[i];
            String string2 = iQualifier.getScopeName();
            String string3 = null;
            StringBuffer stringBuffer = new StringBuffer(string2.length() + 2);
            stringBuffer.append(string2).append("='");
            int n2 = string.indexOf(stringBuffer.toString());
            if (n2 != -1 && (n = string.indexOf(39, n2 += string2.length() + 2)) != -1 && (string3 = string.substring(n2, n)).equals("*")) {
                string3 = null;
            }
            this.m_strScopeValues[i] = string3 == null ? null : string3.intern();
        }
    }

    public ScopeKey(ScopeKey scopeKey) {
        this(scopeKey.m_qualifiers);
        this.m_strScopeValues = new String[scopeKey.m_strScopeValues.length];
        for (int i = 0; i < this.m_strScopeValues.length; ++i) {
            this.m_strScopeValues[i] = scopeKey.m_strScopeValues[i];
        }
    }

    public boolean isUndefined() {
        return this.m_bUndefine;
    }

    public String getDesc() {
        StringBuffer stringBuffer = new StringBuffer(80);
        for (int i = 0; i < this.m_qualifiers.length; ++i) {
            String string = this.m_strScopeValues[i];
            if (string == null) continue;
            if (stringBuffer.length() > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(this.m_qualifiers[i].getScopeName());
            stringBuffer.append("='");
            stringBuffer.append(string);
            stringBuffer.append("'");
        }
        return stringBuffer.toString();
    }

    public String toString() {
        int n = this.m_qualifiers.length;
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            if (this.m_strScopeValues[i] != null) {
                n2 += this.m_strScopeValues[i].length();
                continue;
            }
            n2 += 4;
        }
        StringBuffer stringBuffer = new StringBuffer(n * 12 + n2);
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(this.m_qualifiers[i].getScopeName());
            stringBuffer.append("='");
            String string = this.m_strScopeValues[i];
            if (string != null) {
                stringBuffer.append(string);
            } else {
                stringBuffer.append('*');
            }
            stringBuffer.append('\'');
        }
        return stringBuffer.toString();
    }

    public int compareTo(Object object) {
        int n = 0;
        ScopeKey scopeKey = (ScopeKey)object;
        String[] stringArray = scopeKey.m_strScopeValues;
        for (int i = 0; n == 0 && i < this.m_strScopeValues.length; ++i) {
            String string = this.m_strScopeValues[i];
            if (string == null || ScopedDictionary.STAR.equals(string)) {
                n = stringArray[i] == null || ScopedDictionary.STAR.equals(stringArray[i]) ? 0 : -1;
                continue;
            }
            String string2 = stringArray[i] == null ? ScopedDictionary.STAR : stringArray[i];
            n = this.m_strScopeValues[i].compareTo(string2);
        }
        return n;
    }

    public boolean equals(Object object) {
        boolean bl = false;
        ScopeKey scopeKey = (ScopeKey)object;
        int n = this.m_strScopeValues.length;
        if (scopeKey != null && scopeKey.m_strScopeValues != null && (bl = n == scopeKey.m_strScopeValues.length)) {
            for (int i = 0; bl && i < n; ++i) {
                String string = this.m_strScopeValues[i];
                String string2 = scopeKey.m_strScopeValues[i];
                bl = string == null || ScopedDictionary.STAR.equals(string) ? string2 == null || ScopedDictionary.STAR.equals(string2) : this.m_strScopeValues[i] == scopeKey.m_strScopeValues[i];
            }
        }
        return bl;
    }

    public int hashCode() {
        int n = this.m_strScopeValues.length;
        int n2 = 0;
        long l = 0L;
        for (n2 = 0; n2 < n; ++n2) {
            String string = this.m_strScopeValues[n2];
            l += (long)(string == null || ScopedDictionary.STAR.equals(string) ? n2 : string.hashCode());
        }
        return (int)(0xFFFFFFFFFFFFFFFFL & l);
    }

    ScopeKey[] split() {
        LinkedHashSet<ScopeKey> linkedHashSet = null;
        for (int i = 0; i < this.m_strScopeValues.length; ++i) {
            if (this.m_strScopeValues[i] == null || this.m_strScopeValues[i].indexOf(",") == -1) continue;
            if (linkedHashSet == null) {
                linkedHashSet = new LinkedHashSet<ScopeKey>();
            }
            String[] stringArray = this.m_strScopeValues[i].split(",");
            for (int j = 0; j < stringArray.length; ++j) {
                ScopeKey scopeKey = new ScopeKey(this);
                scopeKey.setScopeValue(i, stringArray[j]);
                if (linkedHashSet.contains(scopeKey)) continue;
                ScopeKey[] scopeKeyArray = scopeKey.split();
                if (scopeKeyArray == null) {
                    linkedHashSet.add(scopeKey);
                    continue;
                }
                for (int k = 0; k < scopeKeyArray.length; ++k) {
                    linkedHashSet.add(scopeKeyArray[k]);
                }
            }
        }
        if (linkedHashSet != null) {
            return linkedHashSet.toArray(EMPTY_SCOPEKEY_ARRAY);
        }
        return null;
    }

    private void setScopeValue(int n, String string) {
        this.m_strScopeValues[n] = string != null ? string.intern() : null;
    }

    public static void main(String[] stringArray) {
        String[][] stringArrayArray = new String[][]{{"dell", "null", "none", "acm_business_admin_role,ecm_sec_users_domain_role,consumer", "webbrowser", "custom", "latest", "null", "rps,collaboration,recordsmanager"}, {"dell", "creategroup", "acm_business_admin_role,ecm legal coordinator role,ecm debug role,ecm legal consumer role,ecm legal contributor role,ecm legal report role,ecm_sec_users_domain_role,contributor,consumer", "webbrowser", "custom", "latest", "collaboration"}, {"a,b,c", "d", "e,f"}, {"a", "d", "e"}, {"a,b,c", "d", "e"}, {"a", "d,e,f", "e"}, {"a,b,c", "d,e,f", "g,h,i"}};
        for (int i = 0; i < stringArrayArray.length; ++i) {
            ScopeKey scopeKey = new ScopeKey(stringArrayArray[i], new IQualifier[stringArrayArray[i].length]);
            ScopeKey[] scopeKeyArray = scopeKey.split();
            System.out.print("input: " + ScopeKey.getArrayAsString(stringArrayArray[i]) + "\noutput: ");
            if (scopeKeyArray != null) {
                for (int j = 0; j < scopeKeyArray.length; ++j) {
                    ScopeKey scopeKey2 = scopeKeyArray[j];
                    System.out.println("\t{" + ScopeKey.getArrayAsString(scopeKey2.m_strScopeValues) + "}");
                }
            }
            System.out.println();
        }
    }

    private static String getArrayAsString(String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer("");
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuffer.append(",[").append(stringArray[i]).append("]");
        }
        return stringBuffer.substring(1);
    }
}

