/*
 * Decompiled with CFR 0.152.
 */
package com.documentum.services.config.impl;

import com.documentum.services.config.IQualifier;
import com.documentum.services.config.impl.ScopedDictionary;
import java.util.Iterator;
import java.util.LinkedList;

class QualifierParentIterator
implements Iterator {
    private String m_strCurValue;
    private IQualifier m_qualifier;
    private LinkedList m_cachedValues;
    private Iterator m_cacheIter;
    private boolean m_bHasNext;
    private boolean m_bCacheValues;

    QualifierParentIterator(String string, IQualifier iQualifier, boolean bl) {
        this.m_strCurValue = string == null || string.length() == 0 ? ScopedDictionary.STAR : string;
        this.m_qualifier = iQualifier;
        this.m_bHasNext = true;
        this.m_bCacheValues = bl;
        if (bl) {
            this.m_cachedValues = new LinkedList();
            this.m_cachedValues.add(string);
        }
    }

    public boolean hasNext() {
        return this.m_bHasNext;
    }

    public Object next() {
        return this.nextString();
    }

    public void remove() {
    }

    public String nextString() {
        String string = this.m_strCurValue;
        if (this.m_strCurValue == null || ScopedDictionary.STAR.equals(this.m_strCurValue)) {
            this.m_bHasNext = false;
            this.m_strCurValue = null;
        } else {
            if (this.m_bCacheValues && this.m_cacheIter != null) {
                this.m_strCurValue = this.m_cacheIter.hasNext() ? this.m_cacheIter.next() : null;
                if (this.m_strCurValue == null) {
                    this.m_strCurValue = this.m_qualifier.getParentScopeValue(string);
                    this.m_cachedValues.add(this.m_strCurValue);
                    this.m_cacheIter = null;
                }
            } else {
                this.m_strCurValue = this.m_qualifier.getParentScopeValue(this.m_strCurValue);
                if (this.m_bCacheValues) {
                    this.m_cachedValues.add(this.m_strCurValue);
                }
            }
            if (this.m_strCurValue == null) {
                this.m_strCurValue = ScopedDictionary.STAR;
            }
        }
        return string;
    }

    public void reset() {
        this.m_bHasNext = true;
        if (this.m_bCacheValues) {
            this.m_cacheIter = this.m_cachedValues.iterator();
            if (this.m_cacheIter.hasNext()) {
                this.m_strCurValue = (String)this.m_cacheIter.next();
            }
        }
    }
}

