/*
 * Decompiled with CFR 0.152.
 */
package com.documentum.services.config.impl;

import com.documentum.fc.client.DfClient;
import com.documentum.fc.client.DfService;
import com.documentum.fc.client.IDfService;
import com.documentum.fc.common.DfException;
import com.documentum.services.config.ConfigException;
import com.documentum.services.config.IConfigContext;
import com.documentum.services.config.IConfigElement;
import com.documentum.services.config.IConfigFile;
import com.documentum.services.config.IConfigLookup;
import com.documentum.services.config.IConfigLookupHook;
import com.documentum.services.config.IConfigReader;
import com.documentum.services.config.IConfigRefreshListener;
import com.documentum.services.config.IConfigService;
import com.documentum.services.config.IConfigServiceConsumer;
import com.documentum.services.config.IContext;
import com.documentum.services.config.IDocbaseContext;
import com.documentum.services.config.IInquisitiveQualifier;
import com.documentum.services.config.INlsReader;
import com.documentum.services.config.IQualifier;
import com.documentum.services.config.common.Context;
import com.documentum.services.config.impl.BoundedContextCache;
import com.documentum.services.config.impl.ConfigElement;
import com.documentum.services.config.impl.ConfigFile;
import com.documentum.services.config.impl.ElementPath;
import com.documentum.services.config.impl.PrimaryElementsByLocationDictionary;
import com.documentum.services.config.impl.PrimaryElementsByScopeDictionary;
import com.documentum.services.config.impl.QualifierContext;
import com.documentum.services.config.impl.ScopeKey;
import com.documentum.services.config.util.StringUtil;
import com.documentum.services.config.util.Trace;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigService
extends DfService
implements IConfigService,
IConfigLookup,
IConfigContext {
    private PrimaryElementsByScopeDictionary m_primaryElementsByScope;
    private PrimaryElementsByLocationDictionary m_primaryElementsByLocation;
    private List m_appConfigFiles = new ArrayList(100);
    private Map m_parentAppNames = new HashMap(17, 1.0f);
    private IQualifier[] m_qualifiers;
    private Map<String, String> m_qualifierContextNames = new HashMap<String, String>(7, 1.0f);
    private Map m_qualifiersByScopeName = new HashMap(7, 1.0f);
    private LookupHooks m_lookupHooks;
    private IConfigReader m_configReader;
    private INlsReader m_nlsReader;
    private IDocbaseContext m_docbaseContext = null;
    private ArrayList<IConfigRefreshListener> m_listRefreshListeners = new ArrayList(5);
    private boolean m_isRefreshing = false;
    private ThreadLocal<IContext> m_threadContext = new ThreadLocal();
    private ThreadLocal<Integer> m_threadReentrantCount = new ThreadLocal();
    private final ConfigElement DUPLICATE_FILTERED_ELEMENT_MARKER = new ConfigElement("DuplicateFIlteredElementMarker", null);
    private int m_appLevel = 0;
    private HashMap<String, ConfigFile> m_mapModificationTargetConfigFiles = new HashMap();
    private ArrayList<ConfigFileInfo> m_listConfigFileInfo = new ArrayList(256);
    private static final String LATEST_VERSION_SCOPE = "version='latest'";
    private static final int TOPMOST_LEVEL = 999;

    public void setNlsReader(INlsReader iNlsReader) {
        this.m_nlsReader = iNlsReader;
    }

    public void loadConfig(IConfigReader iConfigReader, IDocbaseContext iDocbaseContext) {
        this.m_configReader = iConfigReader;
        this.m_configReader.setConfigService((IConfigService)this);
        this.m_docbaseContext = iDocbaseContext;
        String string = this.m_configReader.getAppName();
        this.m_primaryElementsByScope = new PrimaryElementsByScopeDictionary(this, "scope-global", 4001);
        this.m_primaryElementsByLocation = new PrimaryElementsByLocationDictionary(227);
        this.initialiseApp(string, null);
        this.m_primaryElementsByScope.init(this.m_qualifiers);
        if (Trace.CONFIGSERVICE) {
            this.m_primaryElementsByScope.trace();
            this.m_primaryElementsByLocation.trace();
        }
        this.initialiseLookupHooks();
    }

    public INlsReader getNlsReader() {
        return this.m_nlsReader;
    }

    public IDocbaseContext getDocbaseContext() {
        return this.m_docbaseContext;
    }

    public IConfigFile newConfigFile(String string) {
        return new ConfigFile(string, this);
    }

    public String getAppName() {
        return this.m_configReader.getAppName();
    }

    public String getParentAppName(String string) {
        return (String)this.m_parentAppNames.get(string);
    }

    public IConfigLookup getConfigLookup() {
        return this;
    }

    public IConfigContext getConfigContext() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() {
        if (!this.proceedWithRefresh()) {
            return;
        }
        Class<ConfigService> clazz = ConfigService.class;
        synchronized (ConfigService.class) {
            try {
                ArrayList arrayList = (ArrayList)this.m_listRefreshListeners.clone();
                this.loadConfig(this.m_configReader, this.m_docbaseContext);
                int n = arrayList.size();
                for (int i = 0; i < n; ++i) {
                    ((IConfigRefreshListener)arrayList.get(i)).onPostRefresh();
                }
            }
            finally {
                this.m_isRefreshing = false;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private synchronized boolean proceedWithRefresh() {
        if (this.m_isRefreshing) {
            return false;
        }
        this.m_isRefreshing = true;
        return true;
    }

    public String[] getPrimaryElementIds(String string) {
        return this.m_primaryElementsByScope.getPrimaryElementIds(string);
    }

    public String[] getPrimaryElementScopes(String string) {
        return this.m_primaryElementsByScope.getPrimaryElementScopes(string);
    }

    public IConfigElement[] getPrimaryElements(String string) {
        return this.m_primaryElementsByScope.getPrimaryElements(string);
    }

    public Iterator getUnfilteredChildElements(IConfigElement iConfigElement) {
        if (iConfigElement instanceof ConfigElement) {
            return ((ConfigElement)iConfigElement).getChildElements(true);
        }
        throw new IllegalStateException("Cannot get unfiltered child elements of a non-ConfigElement: " + iConfigElement.toString());
    }

    public void addRefreshListener(IConfigRefreshListener iConfigRefreshListener) {
        this.m_listRefreshListeners.add(iConfigRefreshListener);
    }

    public void removeRefreshListener(IConfigRefreshListener iConfigRefreshListener) {
        this.m_listRefreshListeners.remove(iConfigRefreshListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConfigDOMObject(IConfigElement iConfigElement) {
        Iterator iterator = iConfigElement.getChildElements("scope");
        ArrayList<IConfigElement> arrayList = new ArrayList<IConfigElement>();
        while (iterator.hasNext()) {
            IConfigElement iConfigElement2 = (IConfigElement)iterator.next();
            String string = this.initialiseConfigDOMScopeElementVersion(iConfigElement2);
            String string2 = iConfigElement2.getAttributeValue("application");
            if (string2 == null || string2.length() == 0) {
                ((ConfigElement)iConfigElement2).setAttributeValue("application", this.m_configReader.getAppName());
            }
            Iterator iterator2 = iConfigElement2.getAttributeNames();
            String string3 = null;
            StringBuffer stringBuffer = null;
            boolean bl = true;
            int n = 0;
            while (iterator2.hasNext()) {
                string3 = (String)iterator2.next();
                if (this.isScopeName(string3)) continue;
                if (stringBuffer == null) {
                    stringBuffer = new StringBuffer(256);
                }
                if (n > 0) {
                    stringBuffer.append(", ");
                }
                ++n;
                stringBuffer.append(string3);
                bl = false;
            }
            if (!bl) {
                Trace.println((Object)this, "No qualifier is defined for the scopes: " + stringBuffer.toString() + ".  The element is not processed: " + iConfigElement);
                continue;
            }
            List list = null;
            Iterator iterator3 = iConfigElement2.getChildElements();
            while (iterator3.hasNext()) {
                PrimaryElementsByScopeDictionary primaryElementsByScopeDictionary;
                IConfigElement iConfigElement3 = (IConfigElement)iterator3.next();
                String string4 = iConfigElement3.getAttributeValue("modifies");
                if (string4 != null) {
                    arrayList.add(iConfigElement3);
                    continue;
                }
                if (list == null) {
                    list = this.getScopeElementScopeKeys(iConfigElement2);
                }
                ((ConfigElement)iConfigElement3).setAttributeValue("version", string);
                String string5 = this.getPrimaryElementName(iConfigElement3);
                PrimaryElementsByScopeDictionary primaryElementsByScopeDictionary2 = primaryElementsByScopeDictionary = this.getPrimaryElementsByScope();
                synchronized (primaryElementsByScopeDictionary2) {
                    for (int i = 0; i < list.size(); ++i) {
                        ScopeKey scopeKey = (ScopeKey)list.get(i);
                        primaryElementsByScopeDictionary.remove(string5, scopeKey);
                        primaryElementsByScopeDictionary.put(string5, scopeKey, iConfigElement3);
                    }
                }
            }
        }
        this.processModifications(arrayList, 999);
    }

    private String initialiseConfigDOMScopeElementVersion(IConfigElement iConfigElement) {
        String string = iConfigElement.getAttributeValue("version");
        if (string == null || string.length() == 0) {
            string = "latest";
            ((ConfigElement)iConfigElement).setAttributeValue("version", "latest");
        }
        return string;
    }

    public boolean isContextName(String string) {
        return this.m_qualifierContextNames.get(string) != null;
    }

    public Iterator<String> getContextNames() {
        return this.m_qualifierContextNames.keySet().iterator();
    }

    String[] getScopeNames() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (IQualifier iQualifier : this.m_qualifiers) {
            arrayList.add(iQualifier.getScopeName());
        }
        return arrayList.toArray(new String[0]);
    }

    String getDefaultScopeValue(String string) {
        IQualifier iQualifier = (IQualifier)this.m_qualifiersByScopeName.get(string);
        if (iQualifier == null) {
            throw new IllegalArgumentException("There is no qualifier defined for scope " + string);
        }
        Context context = new Context();
        return iQualifier.getScopeValue((IContext)context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IConfigElement lookupElement(String string, IContext iContext) {
        IConfigElement iConfigElement = null;
        if (Trace.CONFIGSERVICE) {
            Trace.println((Object)this, "Config service: Lookup element '" + string + "', context=" + iContext.toString());
        }
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException("ConfigService.lookupElement(...) 'strElementPath'");
        }
        IContext iContext2 = this.getThreadContext();
        boolean bl = false;
        boolean bl2 = false;
        try {
            ElementPath elementPath;
            if (this.incrementReentrentCount() == 1) {
                bl = BoundedContextCache.conditionalStart();
                if (!BoundedContextCache.getInstance().isContextTracked()) {
                    BoundedContextCache.getInstance().trackContext(true);
                    bl2 = true;
                }
            }
            this.setThreadContext(iContext);
            if (this.m_lookupHooks != null) {
                iConfigElement = this.m_lookupHooks.onLookupElement(string, iContext);
            }
            if (iConfigElement == null) {
                elementPath = new ElementPath(string);
                String string2 = elementPath.getPrimaryElement();
                String string3 = elementPath.getLesserElements();
                IConfigElement iConfigElement2 = this.m_primaryElementsByScope.get(string2, this.makeScopeKey(iContext));
                if (iConfigElement2 != null) {
                    if (Trace.CONFIGSERVICE) {
                        Trace.println((Object)this, "\tresolving inheritance:");
                    }
                    do {
                        if (Trace.CONFIGSERVICE) {
                            Trace.println((Object)this, "\t\t" + this.getConfigFilePathName(iConfigElement2));
                        }
                        if (string3 != null) {
                            iConfigElement = iConfigElement2.getDescendantElement(string3);
                            if (iConfigElement != null) continue;
                            iConfigElement2 = this.getExtendedPrimaryElement(iConfigElement2);
                            continue;
                        }
                        iConfigElement = iConfigElement2;
                    } while (iConfigElement == null && iConfigElement2 != null);
                }
            }
            this.traceLookupResult(iConfigElement);
            iConfigElement = this.wrapConfigElement(iContext, iConfigElement, true);
            elementPath = iConfigElement;
            return elementPath;
        }
        finally {
            int n = this.decrementReentrentCount();
            if (n == 0) {
                if (bl2) {
                    bl2 = false;
                    BoundedContextCache.getInstance().trackContext(false);
                }
                if (bl) {
                    BoundedContextCache.end();
                }
            } else if (iContext2 != null) {
                this.setThreadContext(iContext2);
            }
        }
    }

    public String lookupString(String string, IContext iContext) {
        IConfigElement iConfigElement;
        String string2 = null;
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException("ConfigService.lookupString(...) 'strElementPath'");
        }
        if (this.m_lookupHooks != null) {
            string2 = this.m_lookupHooks.onLookupString(string, iContext);
        }
        if (string2 == null && (iConfigElement = this.lookupElement(string, iContext)) != null) {
            string2 = iConfigElement.getValue();
        }
        return string2;
    }

    public Boolean lookupBoolean(String string, IContext iContext) {
        IConfigElement iConfigElement;
        Boolean bl = null;
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException("ConfigService.lookupBoolean(...) 'strElementPath'");
        }
        if (this.m_lookupHooks != null) {
            bl = this.m_lookupHooks.onLookupBoolean(string, iContext);
        }
        if (bl == null && (iConfigElement = this.lookupElement(string, iContext)) != null) {
            bl = iConfigElement.getValueAsBoolean();
        }
        return bl;
    }

    public Integer lookupInteger(String string, IContext iContext) {
        IConfigElement iConfigElement;
        Integer n = null;
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException("ConfigService.lookupInteger(...) 'strElementPath'");
        }
        if (this.m_lookupHooks != null) {
            n = this.m_lookupHooks.onLookupInteger(string, iContext);
        }
        if (n == null && (iConfigElement = this.lookupElement(string, iContext)) != null) {
            n = iConfigElement.getValueAsInteger();
        }
        return n;
    }

    LookupFilter getLookupFilter(IConfigElement iConfigElement, boolean bl) {
        return new LookupFilter(iConfigElement, bl);
    }

    IConfigElement getMostRelevantFilterElement(Map<LookupFilter, IConfigElement> map) {
        Object object3;
        Object object2;
        ConfigService configService = this;
        HashMap<ScopeKey, Object> hashMap = new HashMap<ScopeKey, Object>();
        Set<LookupFilter> set = map.keySet();
        for (LookupFilter object32 : set) {
            object2 = map.get(object32);
            object3 = object32.getScopeKeys();
            Iterator iterator = object3.iterator();
            while (iterator.hasNext()) {
                ScopeKey scopeKey = (ScopeKey)iterator.next();
                if (hashMap.containsKey(scopeKey)) {
                    hashMap.put(scopeKey, this.DUPLICATE_FILTERED_ELEMENT_MARKER);
                    continue;
                }
                hashMap.put(scopeKey, object2);
            }
        }
        PrimaryElementsByScopeDictionary primaryElementsByScopeDictionary = new PrimaryElementsByScopeDictionary(configService, "Most Relevant Filter", 7);
        Set set2 = hashMap.keySet();
        for (Object object3 : set2) {
            primaryElementsByScopeDictionary.put("filter", (ScopeKey)object3, (IConfigElement)hashMap.get(object3));
        }
        primaryElementsByScopeDictionary.init(configService.m_qualifiers);
        object2 = this.getThreadContext();
        object3 = primaryElementsByScopeDictionary.get("filter", configService.makeScopeKey((IContext)object2));
        if (object3 == this.DUPLICATE_FILTERED_ELEMENT_MARKER) {
            return null;
        }
        return object3;
    }

    private ConfigFile getConfigFile(IConfigElement iConfigElement) {
        while (iConfigElement.getParent() != null) {
            iConfigElement = iConfigElement.getParent();
        }
        if (iConfigElement instanceof ConfigFile) {
            return (ConfigFile)iConfigElement;
        }
        return null;
    }

    String getConfigFilePathName(IConfigElement iConfigElement) {
        ConfigFile configFile = this.getConfigFile(iConfigElement);
        if (configFile != null) {
            return configFile.getPathName();
        }
        return null;
    }

    private PrimaryElementsByScopeDictionary getPrimaryElementsByScope() {
        return this.m_primaryElementsByScope;
    }

    private String getPrimaryElementName(IConfigElement iConfigElement) {
        String string = iConfigElement.getName();
        String string2 = iConfigElement.getAttributeValue("id");
        if (string2 != null && string2.length() > 0) {
            StringBuffer stringBuffer = new StringBuffer(128);
            stringBuffer.append(string);
            stringBuffer.append("[id=");
            stringBuffer.append(string2);
            stringBuffer.append(']');
            string = stringBuffer.toString();
        }
        return string;
    }

    private void initialiseApp(String string, String string2) {
        if (this.m_nlsReader != null) {
            this.m_nlsReader.addLookupFolder(string);
            if (string2 == null || string2.length() == 0) {
                this.m_nlsReader.addLookupFolder("");
            }
        }
        if (string2 != null) {
            this.m_parentAppNames.put(string2, string);
        }
        IConfigFile iConfigFile = this.m_configReader.loadAppConfigFile(string);
        this.m_appConfigFiles.add(iConfigFile);
        IConfigElement iConfigElement = iConfigFile.getConfigElement().getChildElement("scope");
        if (iConfigElement == null) {
            throw new IllegalStateException("Missing <scope> tag in application file");
        }
        IConfigElement iConfigElement2 = iConfigElement.getChildElement("application");
        if (iConfigElement2 == null) {
            throw new IllegalStateException("Missing <application> tag in application file");
        }
        String string3 = iConfigElement2.getAttributeValue("extends");
        if (string3 != null) {
            int n = string3.indexOf("app.xml");
            if (n > 0) {
                string3 = string3.substring(0, n - 1);
            }
            this.initialiseApp(string3, string);
        } else {
            this.initialiseQualifiers();
        }
        this.m_listConfigFileInfo.add(new ConfigFileInfo(iConfigFile.getPathName(), string, this.m_appLevel, true));
        this.initialiseAppConfigFile(iConfigFile, string, false);
        ArrayList<IConfigElement> arrayList = new ArrayList<IConfigElement>();
        for (IConfigFile iConfigFile2 : this.m_configReader.loadConfigFiles(string)) {
            this.m_listConfigFileInfo.add(new ConfigFileInfo(iConfigFile2.getPathName(), string, this.m_appLevel, false));
            arrayList.addAll(this.initialiseConfigFile(iConfigFile2, string));
        }
        this.processModifications(arrayList, this.m_appLevel);
        ++this.m_appLevel;
    }

    private IConfigElement initialiseAppConfigFile(IConfigFile iConfigFile, String string, boolean bl) {
        IConfigElement iConfigElement;
        Object object;
        String string2;
        if (!bl) {
            if (this.m_appConfigFiles.indexOf(iConfigFile) < 0) {
                throw new IllegalStateException("an app.xml is not found in the existing list for initialization.");
            }
        } else {
            boolean bl2 = false;
            string2 = iConfigFile.getPathName();
            for (int i = 0; i < this.m_appConfigFiles.size(); ++i) {
                object = (ConfigFile)this.m_appConfigFiles.get(i);
                if (!((ConfigFile)object).getPathName().equals(string2)) continue;
                this.m_appConfigFiles.set(i, iConfigFile);
                bl2 = true;
                break;
            }
            if (!bl2) {
                throw new IllegalStateException("an app.xml for refreshing is not found.");
            }
        }
        if ((iConfigElement = iConfigFile.getConfigElement().getChildElement("scope")) == null) {
            throw new IllegalStateException("Missing <scope> tag in application file");
        }
        string2 = iConfigElement.getChildElement("application");
        if (string2 == null) {
            throw new IllegalStateException("Missing <application> tag in application file");
        }
        ((ConfigElement)iConfigElement).setAttributeValue("application", string);
        String string3 = string2.getName();
        object = new ScopeKey("application='" + string + "'", this.m_qualifiers);
        String string4 = this.m_configReader.getRootFolderPath();
        String string5 = iConfigFile.getPathName().substring(string4.length());
        this.m_primaryElementsByScope.put(string3, (ScopeKey)object, (IConfigElement)string2);
        this.m_primaryElementsByLocation.put(string3, string5, (IConfigElement)string2);
        return string2;
    }

    private List<IConfigElement> initialiseConfigFile(IConfigFile iConfigFile, String string) {
        ArrayList<IConfigElement> arrayList = new ArrayList<IConfigElement>();
        String string2 = this.m_configReader.getRootFolderPath();
        String string3 = iConfigFile.getPathName();
        if (string3.length() > string2.length()) {
            string3 = string3.substring(string2.length());
        }
        Iterator iterator = iConfigFile.getConfigElement().getChildElements("scope");
        while (iterator.hasNext()) {
            String string4;
            IConfigElement iConfigElement = (IConfigElement)iterator.next();
            Iterator iterator2 = iConfigElement.getAttributeNames();
            while (iterator2.hasNext()) {
                string4 = (String)iterator2.next();
                if (this.isScopeName(string4)) continue;
                throw new IllegalStateException("There is no qualifier defined for the scope: " + string4 + " in element: " + iConfigElement.toString());
            }
            ((ConfigElement)iConfigElement).setAttributeValue("application", string);
            string4 = iConfigElement.getAttributeValue("version");
            VersionedScopeElementScopeKeys versionedScopeElementScopeKeys = new VersionedScopeElementScopeKeys(iConfigElement);
            Iterator iterator3 = iConfigElement.getChildElements();
            while (iterator3.hasNext()) {
                IConfigElement iConfigElement2 = (IConfigElement)iterator3.next();
                String string5 = iConfigElement2.getAttributeValue("modifies");
                if (string5 != null) {
                    arrayList.add(iConfigElement2);
                    continue;
                }
                String string6 = this.initialisePrimaryElementVersion(string, string4, iConfigElement2, string3);
                List list = versionedScopeElementScopeKeys.get(string6);
                String string7 = this.getPrimaryElementName(iConfigElement2);
                for (int i = 0; i < list.size(); ++i) {
                    ScopeKey scopeKey = (ScopeKey)list.get(i);
                    this.m_primaryElementsByScope.put(string7, scopeKey, iConfigElement2);
                }
                if (this.isMarkedAsNotDefined(iConfigElement2)) continue;
                this.m_primaryElementsByLocation.put(string7, string3, iConfigElement2);
            }
        }
        return arrayList;
    }

    private void processModifications(List<IConfigElement> list, int n) {
        for (IConfigElement iConfigElement : list) {
            String string = iConfigElement.getAttributeValue("id");
            if (string != null && string.length() > 0) {
                throw new IllegalStateException("id attribute is not allowed in modification element: " + iConfigElement);
            }
            IConfigElement iConfigElement2 = this.getModifiedPrimaryElement(iConfigElement);
            if (iConfigElement2 instanceof ConfigElement && iConfigElement instanceof ConfigElement) {
                ConfigFile configFile = this.getConfigFile(iConfigElement);
                if (configFile != null && configFile.getPathName() != null) {
                    this.m_mapModificationTargetConfigFiles.put(configFile.getPathName(), configFile);
                }
                Set<ConfigElement> set = ((ConfigElement)iConfigElement2).applyModification((ConfigElement)iConfigElement, n);
                for (ConfigElement configElement : set) {
                    configFile = this.getConfigFile(configElement);
                    if (configFile == null || configFile.getPathName() == null) continue;
                    this.m_mapModificationTargetConfigFiles.put(configFile.getPathName(), configFile);
                }
                continue;
            }
            if (!(iConfigElement2 instanceof ConfigElement)) {
                throw new IllegalStateException("Cannot apply modification to a non-ConfigElement: " + iConfigElement2);
            }
            throw new IllegalStateException("Cannot appy a non-ConfigElement modification: " + iConfigElement);
        }
    }

    private boolean isScopeName(String string) {
        return this.m_qualifiersByScopeName.get(string) != null;
    }

    private IConfigElement getQualifiersElement() {
        ConfigFile configFile;
        IConfigElement iConfigElement;
        IConfigElement iConfigElement2;
        IConfigElement iConfigElement3 = null;
        for (int i = 0; i < this.m_appConfigFiles.size() && (iConfigElement3 = (iConfigElement2 = (iConfigElement = (configFile = (ConfigFile)this.m_appConfigFiles.get(i)).getChildElement("scope")).getChildElement("application")).getChildElement("qualifiers")) == null; ++i) {
        }
        if (iConfigElement3 == null) {
            throw new IllegalStateException("No qualifiers are defined");
        }
        return iConfigElement3;
    }

    private void initialiseQualifiers() {
        if (Trace.CONFIGSERVICE) {
            Trace.println((Object)this, "ConfigService: Initialising qualifiers:");
        }
        IConfigElement iConfigElement = this.getQualifiersElement();
        Iterator iterator = iConfigElement.getChildElements("qualifier");
        Vector<IQualifier> vector = new Vector<IQualifier>();
        while (iterator.hasNext()) {
            IConfigElement iConfigElement2 = (IConfigElement)iterator.next();
            String string = iConfigElement2.getValue();
            if (string == null || string.length() == 0) {
                throw new IllegalStateException("Missing qualifier <class> element");
            }
            IQualifier iQualifier = this.loadQualifierClass(string);
            if (iQualifier == null) {
                iQualifier = this.loadQualifierModule(string);
            }
            if (iQualifier instanceof IConfigServiceConsumer) {
                ((IConfigServiceConsumer)iQualifier).setConfigService((IConfigService)this);
            }
            this.m_qualifiersByScopeName.put(iQualifier.getScopeName(), iQualifier);
            String[] stringArray = iQualifier.getContextNames();
            if (stringArray != null) {
                for (int i = 0; i < stringArray.length; ++i) {
                    this.m_qualifierContextNames.put(stringArray[i], "");
                }
            }
            if (Trace.CONFIGSERVICE) {
                Trace.println((Object)this, "\t" + string);
            }
            vector.add(iQualifier);
        }
        this.m_qualifiers = new IQualifier[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            this.m_qualifiers[i] = (IQualifier)vector.elementAt(i);
        }
    }

    private IQualifier loadQualifierClass(String string) {
        IQualifier iQualifier;
        try {
            Class<?> clazz = Class.forName(string);
            Class<?> clazz2 = Class.forName("com.documentum.services.config.IQualifier");
            Class<?>[] classArray = clazz.getInterfaces();
            boolean bl = false;
            for (int i = 0; i < classArray.length; ++i) {
                if (!classArray[i].equals(clazz2)) continue;
                bl = true;
                break;
            }
            if (!bl) {
                throw new IllegalStateException("Class does not implement IQualifier: " + string);
            }
            iQualifier = (IQualifier)clazz.newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new ConfigException("Qualifier class not found: " + string, (Throwable)classNotFoundException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new ConfigException("Unable to access qualifier class: " + string, (Throwable)illegalAccessException);
        }
        catch (InstantiationException instantiationException) {
            throw new ConfigException("Unable to instantiate qualifier class: " + string, (Throwable)instantiationException);
        }
        return iQualifier;
    }

    private IQualifier loadQualifierModule(String string) {
        try {
            IDfService iDfService = DfClient.getLocalClient().newService(string, this.getSessionManager());
            if (iDfService instanceof IQualifier) {
                return (IQualifier)iDfService;
            }
        }
        catch (DfException dfException) {
            Trace.println((Object)this, "Fail to load qualifier module: " + string.getClass().getName());
        }
        return null;
    }

    private void initialiseLookupHooks() {
        ResourceBundle resourceBundle;
        block18: {
            resourceBundle = null;
            try {
                resourceBundle = ResourceBundle.getBundle("com.documentum.services.config.LookupHooks");
            }
            catch (MissingResourceException missingResourceException) {
                if (!Trace.CONFIGSERVICE) break block18;
                Trace.println((Object)this, "ConfigService: Environment.properties file not found");
            }
        }
        if (resourceBundle != null) {
            int n = 1;
            while (true) {
                Boolean bl;
                String string;
                String string2;
                block19: {
                    string2 = null;
                    string = null;
                    bl = null;
                    String string3 = "LookupHookPath." + n;
                    try {
                        string2 = resourceBundle.getString(string3);
                    }
                    catch (MissingResourceException missingResourceException) {
                        if (!Trace.CONFIGSERVICE) break block19;
                        Trace.println((Object)this, "Config Service: " + string3 + " not defined in environment.properties");
                    }
                }
                if (string2 == null || string2.length() == 0) break;
                String string4 = "LookupHookClass." + n;
                try {
                    string = resourceBundle.getString(string4);
                }
                catch (MissingResourceException missingResourceException) {
                    // empty catch block
                }
                if (string == null || string.length() == 0) {
                    throw new ConfigException("Config Service: " + string4 + " not defined in environment.properties");
                }
                IConfigLookupHook iConfigLookupHook = null;
                try {
                    iConfigLookupHook = (IConfigLookupHook)Class.forName(string).newInstance();
                    if (Trace.CONFIGSERVICE) {
                        Trace.println((Object)this, "Config Service: Lookup Hook " + string + " created for path " + string2);
                    }
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new ConfigException("ConfigLookupHook class not found: " + string, (Throwable)classNotFoundException);
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw new ConfigException("Unable to access ConfigLookupHook class: " + string, (Throwable)illegalAccessException);
                }
                catch (InstantiationException instantiationException) {
                    throw new ConfigException("Unable to instantiate ConfigLookupHook class: " + string, (Throwable)instantiationException);
                }
                bl = Boolean.TRUE;
                String string5 = "LookupHookArgument." + n;
                try {
                    String string6 = resourceBundle.getString(string5);
                    if (string6 != null && string6.equals("relative")) {
                        bl = Boolean.FALSE;
                    }
                }
                catch (MissingResourceException missingResourceException) {
                    // empty catch block
                }
                if (this.m_lookupHooks == null) {
                    this.m_lookupHooks = new LookupHooks();
                }
                this.m_lookupHooks.addLookupHook(string2, iConfigLookupHook, bl);
                ++n;
            }
        }
    }

    private ScopeKey makeScopeKey(IContext iContext) {
        boolean bl;
        ScopeKey scopeKey = null;
        BoundedContextCache boundedContextCache = BoundedContextCache.getInstance();
        boolean bl2 = bl = boundedContextCache != null && boundedContextCache.isContextTracked();
        if (bl) {
            scopeKey = boundedContextCache.getScopeKey(iContext);
        }
        if (scopeKey == null) {
            scopeKey = new ScopeKey(new QualifierContext(iContext), this.m_qualifiers);
            if (bl) {
                boundedContextCache.setScopeKey(iContext, scopeKey);
            }
        }
        return scopeKey;
    }

    private IConfigElement getExtendedPrimaryElement(IConfigElement iConfigElement) {
        String string = iConfigElement.getAttributeValue("extends");
        if (string == null || string.length() == 0) {
            iConfigElement = null;
        } else {
            String string2;
            StringBuffer stringBuffer = new StringBuffer(128);
            stringBuffer.append(iConfigElement.getName());
            int n = string.indexOf(58);
            if (n != -1) {
                stringBuffer.append("[id=");
                stringBuffer.append(string.substring(0, n));
                stringBuffer.append(']');
                string = string.substring(n + 1);
            } else {
                string2 = iConfigElement.getAttributeValue("id");
                if (string2 != null) {
                    stringBuffer.append("[id=");
                    stringBuffer.append(string2);
                    stringBuffer.append(']');
                }
            }
            string2 = stringBuffer.toString();
            if (string.indexOf(61) != -1) {
                String string3 = this.enforceVersionScopeForDerive(string);
                iConfigElement = this.m_primaryElementsByScope.getAbsolute(string2, new ScopeKey(string3, this.m_qualifiers));
            } else {
                iConfigElement = this.m_primaryElementsByLocation.get(string2, string);
            }
            if (iConfigElement == null) {
                throw new IllegalStateException("ConfigService: Cannot locate " + string2 + " in extends=" + string);
            }
        }
        return iConfigElement;
    }

    private IConfigElement getModifiedPrimaryElement(IConfigElement iConfigElement) {
        IConfigElement iConfigElement2 = null;
        String string = iConfigElement.getAttributeValue("modifies");
        if (string == null || string.length() == 0) {
            throw new IllegalStateException("Missing or empty modifies attribute in: " + iConfigElement);
        }
        StringBuffer stringBuffer = new StringBuffer(128);
        stringBuffer.append(iConfigElement.getName());
        int n = string.indexOf(58);
        if (n != -1) {
            stringBuffer.append("[id=");
            stringBuffer.append(string.substring(0, n));
            stringBuffer.append(']');
            string = string.substring(n + 1);
        }
        String string2 = stringBuffer.toString();
        if (string.indexOf(61) != -1) {
            String string3 = this.enforceVersionScopeForDerive(string);
            iConfigElement2 = this.m_primaryElementsByScope.getAbsolute(string2, new ScopeKey(string3, this.m_qualifiers));
        } else {
            iConfigElement2 = this.m_primaryElementsByLocation.get(string2, string);
        }
        if (iConfigElement2 == null) {
            throw new IllegalStateException("ConfigService: Cannot locate " + string2 + " in modifies=" + iConfigElement);
        }
        return iConfigElement2;
    }

    private String enforceVersionScopeForDerive(String string) {
        if (string.indexOf("version=") == -1) {
            return string + " " + LATEST_VERSION_SCOPE;
        }
        return string;
    }

    private String initialisePrimaryElementVersion(String string, String string2, IConfigElement iConfigElement, String string3) {
        String string4;
        if (string2 != null) {
            string2 = string2.trim();
        }
        String string5 = null;
        if (string2 != null && string2.length() > 0) {
            string5 = string2;
        } else {
            string4 = iConfigElement.getAttributeValue("extends");
            if (string4 != null && string4.length() > 0 && string4.indexOf(61) == -1) {
                int n = string4.indexOf(58);
                String string6 = iConfigElement.getAttributeValue("id");
                String string7 = null;
                if (n != -1) {
                    string7 = string4.substring(0, n);
                    string4 = string4.substring(n + 1);
                } else {
                    string7 = string6;
                }
                if (string6 != null && string6.equals(string7)) {
                    CharSequence charSequence;
                    if ((string4 = string4.replace('\\', '/')).charAt(0) == '/') {
                        string4 = string4.substring(1);
                    }
                    boolean bl = false;
                    String string8 = string;
                    do {
                        if ((charSequence = this.getParentAppName(string8)) != null && string4.startsWith((String)charSequence)) {
                            bl = true;
                            continue;
                        }
                        string8 = charSequence;
                    } while (string8 != null && !bl);
                    if (bl) {
                        charSequence = new StringBuffer(128);
                        ((StringBuffer)charSequence).append(iConfigElement.getName());
                        ((StringBuffer)charSequence).append("[id=");
                        ((StringBuffer)charSequence).append(string7);
                        ((StringBuffer)charSequence).append(']');
                        String string9 = ((StringBuffer)charSequence).toString();
                        IConfigElement iConfigElement2 = this.m_primaryElementsByLocation.get(string9, string4);
                        if (iConfigElement2 == null) {
                            throw new IllegalStateException("ConfigService: Cannot locate " + string9 + " in extends=" + string4 + " while trying to retrieve the inherited version for " + string9 + " in " + string3);
                        }
                        string5 = iConfigElement2.getAttributeValue("version");
                    }
                }
            }
            if (string5 == null) {
                string5 = "latest";
            }
        }
        ((ConfigElement)iConfigElement).setAttributeValue("version", string5);
        if (Trace.CONFIGSERVICE && !string5.equals("latest")) {
            string4 = string2 != null && string2.length() > 0 ? "specified for " : "inherited by ";
            Trace.println((Object)this, "Config Service: Version " + string5 + " is " + string4 + iConfigElement.getName() + "[id=" + iConfigElement.getAttributeValue("id") + "] in " + string3);
        }
        return string5;
    }

    public IConfigElement getExtendedElement(IConfigElement iConfigElement) {
        return this.getExtendedPrimaryElement(iConfigElement);
    }

    private List getScopeElementScopeKeys(IConfigElement iConfigElement) {
        int n;
        int n2;
        Object object;
        Object object2;
        ArrayList<ScopeKey> arrayList = new ArrayList<ScopeKey>();
        List[] listArray = new List[this.m_qualifiers.length];
        for (int i = 0; i < this.m_qualifiers.length; ++i) {
            object2 = this.m_qualifiers[i];
            listArray[i] = new ArrayList();
            String string = object2.getScopeName();
            object = iConfigElement.getAttributeValue(string);
            if (object != null && ((String)object).length() > 0) {
                listArray[i] = this.parseScopeValueClause(this.m_qualifiers[i], (String)object);
            }
            n2 = 1;
            for (int j = 0; j < listArray[i].size(); ++j) {
                object = (String)listArray[i].get(j);
                if (((String)object).toLowerCase().startsWith("not ")) continue;
                n2 = 0;
            }
            if (n2 == 0) continue;
            listArray[i].add("*");
        }
        int[] nArray = new int[this.m_qualifiers.length];
        object2 = new int[this.m_qualifiers.length];
        for (n = 0; n < this.m_qualifiers.length; ++n) {
            nArray[n] = 0;
            object2[n] = (IQualifier)listArray[n].size();
        }
        n = 0;
        block3: do {
            object = new String[this.m_qualifiers.length];
            for (n2 = 0; n2 < this.m_qualifiers.length; ++n2) {
                object[n2] = (String)listArray[n2].get(nArray[n2]);
            }
            arrayList.add(new ScopeKey((String[])object, this.m_qualifiers));
            for (n2 = 0; n2 < this.m_qualifiers.length; ++n2) {
                int n3 = n2;
                nArray[n3] = nArray[n3] + 1;
                if (nArray[n2] < object2[n2]) continue block3;
                nArray[n2] = 0;
                if (n2 != this.m_qualifiers.length - 1) continue;
                n = 1;
            }
        } while (n == 0);
        return arrayList;
    }

    private List parseScopeValueClause(IQualifier iQualifier, String string) {
        ArrayList arrayList = new ArrayList();
        this._parseScopeValueClause(iQualifier, string, false, arrayList);
        if (iQualifier instanceof IInquisitiveQualifier) {
            ((IInquisitiveQualifier)iQualifier).onAddScopeValues(Collections.unmodifiableList(arrayList));
        }
        return arrayList;
    }

    private void _parseScopeValueClause(IQualifier iQualifier, String string, boolean bl, List list) {
        string = StringUtil.replace(string, ",,", "(}]");
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String[] stringArray;
            String string2;
            String string3 = StringUtil.replace(stringTokenizer.nextToken().trim(), "(}]", ",");
            boolean bl2 = bl;
            if (string3.toLowerCase().startsWith("not ")) {
                string3 = string3.substring(3).trim();
                bl2 = !bl2;
            }
            String string4 = string2 = bl2 ? "not " + string3 : string3;
            if (!list.contains(string2)) {
                list.add(string2);
            }
            if ((stringArray = iQualifier.getAliasScopeValues(string3)) == null) continue;
            for (int i = 0; i < stringArray.length; ++i) {
                this._parseScopeValueClause(iQualifier, stringArray[i], bl2, list);
            }
        }
    }

    boolean isMarkedAsNotDefined(IConfigElement iConfigElement) {
        String string = iConfigElement.getAttributeValue("notdefined");
        if (string == null || string.equalsIgnoreCase("false")) {
            return false;
        }
        Iterator iterator = iConfigElement.getChildElements();
        if (iConfigElement.getValue().length() != 0 || iterator != null && iterator.hasNext()) {
            throw new IllegalStateException("Non defined elements cannot have children or values: " + iConfigElement.toString());
        }
        return true;
    }

    public String getPrimaryElementScope(IConfigElement iConfigElement) {
        return this.getPrimaryElementScopeEx(iConfigElement);
    }

    public String getPrimaryElementScopeEx(IConfigElement iConfigElement) {
        IConfigElement iConfigElement2 = iConfigElement.getParent();
        if (iConfigElement2 == null || !iConfigElement2.getName().equals("scope")) {
            throw new IllegalArgumentException("getPrimaryElementScope(...) primary element required");
        }
        boolean bl = false;
        StringBuffer stringBuffer = new StringBuffer(128);
        Iterator iterator = iConfigElement2.getAttributeNames();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            String string2 = iConfigElement2.getAttributeValue(string);
            if (bl) {
                stringBuffer.append(' ');
            }
            stringBuffer.append(string).append("='").append(string2).append("'");
            bl = true;
        }
        return stringBuffer.toString();
    }

    public final String getPrimaryElementVersion(IConfigElement iConfigElement) {
        return iConfigElement.getAttributeValue("version");
    }

    private void setThreadContext(IContext iContext) {
        this.m_threadContext.set(iContext);
    }

    private IContext getThreadContext() {
        return this.m_threadContext.get();
    }

    private int incrementReentrentCount() {
        int n = 1;
        Integer n2 = this.m_threadReentrantCount.get();
        if (n2 != null) {
            n = n2 + 1;
        }
        this.m_threadReentrantCount.set(n);
        return n;
    }

    private int decrementReentrentCount() {
        int n = 0;
        Integer n2 = this.m_threadReentrantCount.get();
        if (n2 != null) {
            n = n2 - 1;
        }
        this.m_threadReentrantCount.set(n);
        return n;
    }

    private void traceLookupResult(IConfigElement iConfigElement) {
        if (Trace.CONFIGSERVICE) {
            if (iConfigElement != null) {
                String string = iConfigElement.getValue();
                if (string != null && string.length() != 0) {
                    Trace.println((Object)this, "\telement found (value = '" + string + "')");
                } else {
                    Trace.println((Object)this, "\telement found");
                }
            } else {
                Trace.println((Object)this, "\telement NOT found");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void removeAllModifications() {
        HashMap hashMap = (HashMap)this.m_mapModificationTargetConfigFiles.clone();
        this.m_mapModificationTargetConfigFiles.clear();
        for (ConfigFile configFile : hashMap.values()) {
            this.doRemoveConfigFileDOMObject(configFile);
        }
        ArrayList arrayList = new ArrayList();
        int n = 0;
        for (ConfigFileInfo configFileInfo : this.m_listConfigFileInfo) {
            IConfigFile iConfigFile;
            String string;
            ConfigFile configFile;
            if (configFileInfo.m_nAppLevel != n) {
                if (arrayList.size() > 0) {
                    this.processModifications(arrayList, n);
                    arrayList.clear();
                }
                n = configFileInfo.m_nAppLevel;
            }
            if ((configFile = (ConfigFile)hashMap.get(string = configFileInfo.m_strFilePath)) == null) continue;
            if (configFileInfo.m_fIsAppConfigFile) {
                iConfigFile = this.m_configReader.loadAppConfigFile(configFileInfo.m_strAppName);
                this.initialiseAppConfigFile(iConfigFile, configFileInfo.m_strAppName, true);
                continue;
            }
            iConfigFile = new ConfigFile(configFile.getPathName(), null);
            arrayList.addAll(this.initialiseConfigFile(iConfigFile, configFileInfo.m_strAppName));
        }
        if (arrayList.size() > 0) {
            this.processModifications(arrayList, n);
            arrayList.clear();
        }
        ArrayList arrayList2 = (ArrayList)this.m_listRefreshListeners.clone();
        try {
            this.m_isRefreshing = true;
            int n2 = arrayList2.size();
            for (int i = 0; i < n2; ++i) {
                ((IConfigRefreshListener)arrayList2.get(i)).onPostRefresh();
            }
        }
        finally {
            this.m_isRefreshing = false;
        }
    }

    private void doRemoveConfigFileDOMObject(ConfigFile configFile) {
        String string = this.m_configReader.getRootFolderPath();
        if (this.m_appConfigFiles.indexOf(configFile) != -1) {
            IConfigElement iConfigElement = configFile.getChildElement("scope");
            if (iConfigElement == null) {
                throw new IllegalStateException("Missing <scope> tag in application file");
            }
            IConfigElement iConfigElement2 = iConfigElement.getChildElement("application");
            if (iConfigElement2 == null) {
                throw new IllegalStateException("Missing <application> tag in application file");
            }
            String string2 = iConfigElement.getAttributeValue("application");
            if (string2 == null) {
                throw new IllegalStateException("Missing attribute for the application name");
            }
            String string3 = iConfigElement2.getName();
            ScopeKey scopeKey = new ScopeKey("application='" + string2 + "'", this.m_qualifiers);
            String string4 = configFile.getPathName().substring(string.length());
            this.m_primaryElementsByScope.remove(string3, scopeKey);
            this.m_primaryElementsByLocation.remove(string3, string4);
        } else {
            Iterator<IConfigElement> iterator = configFile.getChildElements("scope");
            while (iterator.hasNext()) {
                IConfigElement iConfigElement = iterator.next();
                List list = null;
                Iterator iterator2 = iConfigElement.getChildElements();
                while (iterator2.hasNext()) {
                    IConfigElement iConfigElement3 = (IConfigElement)iterator2.next();
                    if (iConfigElement3.getAttributeValue("modifies") != null) continue;
                    if (list == null) {
                        list = this.getScopeElementScopeKeys(iConfigElement);
                    }
                    String string5 = this.getPrimaryElementName(iConfigElement3);
                    PrimaryElementsByScopeDictionary primaryElementsByScopeDictionary = this.getPrimaryElementsByScope();
                    for (int i = 0; i < list.size(); ++i) {
                        ScopeKey scopeKey = (ScopeKey)list.get(i);
                        primaryElementsByScopeDictionary.remove(string5, scopeKey);
                    }
                    String string6 = this.getConfigFilePathName(iConfigElement3);
                    if (string6 == null || string6.length() <= string.length()) continue;
                    string6 = string6.substring(string.length());
                    this.m_primaryElementsByLocation.remove(string5, string6);
                }
            }
        }
    }

    private IConfigElement wrapConfigElement(IContext iContext, IConfigElement iConfigElement, boolean bl) {
        IConfigElement iConfigElement2 = iConfigElement;
        if (this.isConfigElementInstance(iConfigElement)) {
            if (bl && iContext instanceof Context) {
                iContext = new Context((Context)iContext);
            }
            iConfigElement2 = new ConfigElementWrapper(iContext, (ConfigElement)iConfigElement);
        }
        return iConfigElement2;
    }

    private boolean isConfigElementInstance(IConfigElement iConfigElement) {
        return iConfigElement != null && iConfigElement.getClass() == ConfigElement.class;
    }

    private static class ConfigFileInfo {
        String m_strFilePath;
        String m_strAppName;
        int m_nAppLevel;
        boolean m_fIsAppConfigFile;

        ConfigFileInfo(String string, String string2, int n, boolean bl) {
            this.m_strFilePath = string;
            this.m_strAppName = string2;
            this.m_nAppLevel = n;
            this.m_fIsAppConfigFile = bl;
        }
    }

    private class VersionedScopeElementScopeKeys {
        IConfigElement m_scopeElement = null;
        private Map m_scopeKeysByVersion = new HashMap();

        VersionedScopeElementScopeKeys(IConfigElement iConfigElement) {
            this.m_scopeElement = iConfigElement;
        }

        List get(String string) {
            List list = (List)this.m_scopeKeysByVersion.get(string);
            if (list == null) {
                if (string.indexOf(44) != -1) {
                    throw new IllegalStateException("ConfigService: Only one 'version' scope value is allowed. Offending scope element: " + this.m_scopeElement.toString());
                }
                if (string.startsWith("not ")) {
                    throw new IllegalStateException("ConfigService: 'not ' is not allowed as part of the 'version' scope value. Offending scope element: " + this.m_scopeElement.toString());
                }
                if (string.equals("latest")) {
                    ((ConfigElement)this.m_scopeElement).setAttributeValue("version", string);
                } else {
                    ((ConfigElement)this.m_scopeElement).setAttributeValue("version", string + "," + "fixed_" + string);
                }
                list = ConfigService.this.getScopeElementScopeKeys(this.m_scopeElement);
                this.m_scopeKeysByVersion.put(string, list);
            }
            return list;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class LookupFilter {
        private PrimaryElementsByScopeDictionary m_lookupByScope;
        private IConfigElement m_filterElement = null;
        private boolean m_bIsInitialized = false;
        private boolean m_negated = false;

        LookupFilter(IConfigElement iConfigElement, boolean bl) {
            this.m_filterElement = iConfigElement;
            this.m_negated = bl;
            this.initialize();
        }

        private synchronized void initialize() {
            if (!this.m_bIsInitialized && ConfigService.this.m_qualifiers != null) {
                this.m_lookupByScope = new PrimaryElementsByScopeDictionary(ConfigService.this, "filter-" + this.m_filterElement.toString(), 7);
                List list = ConfigService.this.getScopeElementScopeKeys(this.m_filterElement);
                for (int i = 0; i < list.size(); ++i) {
                    ScopeKey scopeKey = (ScopeKey)list.get(i);
                    this.m_lookupByScope.put("filter", scopeKey, this.m_filterElement);
                }
                this.m_lookupByScope.init(ConfigService.this.m_qualifiers);
                this.m_bIsInitialized = true;
            }
        }

        public synchronized boolean showContents() {
            boolean bl;
            if (!this.m_bIsInitialized) {
                this.initialize();
                if (BoundedContextCache.isStarted()) {
                    BoundedContextCache.getInstance().clear();
                }
            }
            IContext iContext = ConfigService.this.getThreadContext();
            if (Trace.CONFIGSERVICE) {
                Trace.println(this, "Config service: filter lookup '" + this.m_filterElement.toString() + "', context=" + iContext.toString());
            }
            boolean bl2 = bl = this.m_lookupByScope.get("filter", ConfigService.this.makeScopeKey(iContext)) != null;
            if (this.m_negated) {
                boolean bl3 = bl = !bl;
            }
            if (Trace.CONFIGSERVICE) {
                Trace.println(this, " - " + (bl ? "shown" : "hidden"));
            }
            return bl;
        }

        private List<ScopeKey> getScopeKeys() {
            return ConfigService.this.getScopeElementScopeKeys(this.m_filterElement);
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer(128);
            if (this.m_negated) {
                stringBuffer.append("negate-");
            }
            stringBuffer.append(this.m_filterElement.toString());
            return stringBuffer.toString();
        }

        boolean isNegated() {
            return this.m_negated;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ConfigElementWrapper
    extends ConfigElement {
        private IContext m_lookupContext;
        private ConfigElement m_orgConfigElement;

        ConfigElementWrapper(IContext iContext, ConfigElement configElement) {
            this.m_lookupContext = iContext;
            this.m_orgConfigElement = configElement;
        }

        @Override
        void addChildElement(IConfigElement iConfigElement) {
            this.m_orgConfigElement.addChildElement(iConfigElement);
        }

        @Override
        Set<ConfigElement> applyModification(ConfigElement configElement, int n) {
            return this.m_orgConfigElement.applyModification(configElement, n);
        }

        public Iterator getAttributeNames() {
            return this.m_orgConfigElement.getAttributeNames();
        }

        @Override
        public String getAttributeValue(String string) {
            return this.m_orgConfigElement.getAttributeValue(string);
        }

        @Override
        public Boolean getAttributeValueAsBoolean(String string) {
            return this.m_orgConfigElement.getAttributeValueAsBoolean(string);
        }

        @Override
        public Integer getAttributeValueAsInteger(String string) {
            return this.m_orgConfigElement.getAttributeValueAsInteger(string);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public IConfigElement getChildElement(String string) {
            IContext iContext = ConfigService.this.getThreadContext();
            try {
                ConfigService.this.setThreadContext(this.m_lookupContext);
                IConfigElement iConfigElement = ConfigService.this.wrapConfigElement(this.m_lookupContext, this.m_orgConfigElement.getChildElement(string), false);
                return iConfigElement;
            }
            finally {
                ConfigService.this.setThreadContext(iContext);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Iterator getChildElements() {
            IContext iContext = ConfigService.this.getThreadContext();
            try {
                ConfigService.this.setThreadContext(this.m_lookupContext);
                Iterator iterator = this.wrapConfigElements(this.m_orgConfigElement.getChildElements());
                return iterator;
            }
            finally {
                ConfigService.this.setThreadContext(iContext);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Iterator getChildElements(String string) {
            IContext iContext = ConfigService.this.getThreadContext();
            try {
                ConfigService.this.setThreadContext(this.m_lookupContext);
                Iterator iterator = this.wrapConfigElements(this.m_orgConfigElement.getChildElements(string));
                return iterator;
            }
            finally {
                ConfigService.this.setThreadContext(iContext);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Iterator getChildElements(boolean bl) {
            IContext iContext = ConfigService.this.getThreadContext();
            try {
                ConfigService.this.setThreadContext(this.m_lookupContext);
                Iterator iterator = this.wrapConfigElements(this.m_orgConfigElement.getChildElements(bl));
                return iterator;
            }
            finally {
                ConfigService.this.setThreadContext(iContext);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String getChildValue(String string) {
            IContext iContext = ConfigService.this.getThreadContext();
            try {
                ConfigService.this.setThreadContext(this.m_lookupContext);
                String string2 = this.m_orgConfigElement.getChildValue(string);
                return string2;
            }
            finally {
                ConfigService.this.setThreadContext(iContext);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Boolean getChildValueAsBoolean(String string) {
            IContext iContext = ConfigService.this.getThreadContext();
            try {
                ConfigService.this.setThreadContext(this.m_lookupContext);
                Boolean bl = this.m_orgConfigElement.getChildValueAsBoolean(string);
                return bl;
            }
            finally {
                ConfigService.this.setThreadContext(iContext);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Integer getChildValueAsInteger(String string) {
            IContext iContext = ConfigService.this.getThreadContext();
            try {
                ConfigService.this.setThreadContext(this.m_lookupContext);
                Integer n = this.m_orgConfigElement.getChildValueAsInteger(string);
                return n;
            }
            finally {
                ConfigService.this.setThreadContext(iContext);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public IConfigElement getDescendantElement(String string) {
            IContext iContext = ConfigService.this.getThreadContext();
            try {
                ConfigService.this.setThreadContext(this.m_lookupContext);
                IConfigElement iConfigElement = ConfigService.this.wrapConfigElement(this.m_lookupContext, this.m_orgConfigElement.getDescendantElement(string), false);
                return iConfigElement;
            }
            finally {
                ConfigService.this.setThreadContext(iContext);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String getDescendantValue(String string) {
            IContext iContext = ConfigService.this.getThreadContext();
            try {
                ConfigService.this.setThreadContext(this.m_lookupContext);
                String string2 = this.m_orgConfigElement.getDescendantValue(string);
                return string2;
            }
            finally {
                ConfigService.this.setThreadContext(iContext);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Boolean getDescendantValueAsBoolean(String string) {
            IContext iContext = ConfigService.this.getThreadContext();
            try {
                ConfigService.this.setThreadContext(this.m_lookupContext);
                Boolean bl = this.m_orgConfigElement.getDescendantValueAsBoolean(string);
                return bl;
            }
            finally {
                ConfigService.this.setThreadContext(iContext);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Integer getDescendantValueAsInteger(String string) {
            IContext iContext = ConfigService.this.getThreadContext();
            try {
                ConfigService.this.setThreadContext(this.m_lookupContext);
                Integer n = this.m_orgConfigElement.getDescendantValueAsInteger(string);
                return n;
            }
            finally {
                ConfigService.this.setThreadContext(iContext);
            }
        }

        @Override
        public String getName() {
            return this.m_orgConfigElement.getName();
        }

        @Override
        IConfigElement getOriginalParent() {
            return this.m_orgConfigElement.getOriginalParent();
        }

        @Override
        public IConfigElement getParent() {
            return this.m_orgConfigElement.getParent();
        }

        @Override
        public String getValue() {
            return this.m_orgConfigElement.getValue();
        }

        @Override
        public Boolean getValueAsBoolean() {
            return this.m_orgConfigElement.getValueAsBoolean();
        }

        @Override
        public Integer getValueAsInteger() {
            return this.m_orgConfigElement.getValueAsInteger();
        }

        @Override
        void setAttributeValue(String string, boolean bl) {
            this.m_orgConfigElement.setAttributeValue(string, bl);
        }

        @Override
        void setAttributeValue(String string, int n) {
            this.m_orgConfigElement.setAttributeValue(string, n);
        }

        @Override
        void setAttributeValue(String string, String string2) {
            this.m_orgConfigElement.setAttributeValue(string, string2);
        }

        @Override
        void setParent(IConfigElement iConfigElement) {
            this.m_orgConfigElement.setParent(iConfigElement);
        }

        @Override
        public String toString() {
            return this.m_orgConfigElement.toString();
        }

        private Iterator wrapConfigElements(Iterator iterator) {
            Iterator iterator2 = iterator;
            if (iterator != null && iterator.hasNext()) {
                ArrayList<IConfigElement> arrayList = new ArrayList<IConfigElement>(10);
                while (iterator.hasNext()) {
                    arrayList.add(ConfigService.this.wrapConfigElement(this.m_lookupContext, (IConfigElement)iterator.next(), false));
                }
                iterator2 = arrayList.iterator();
            }
            return iterator2;
        }
    }

    private class LookupHooks
    implements IConfigLookupHook {
        private ArrayList m_lookupPaths = new ArrayList(5);
        private ArrayList<IConfigLookupHook> m_hooks = new ArrayList(5);
        private ArrayList m_bAbsoluteArgs = new ArrayList(5);

        public void addLookupHook(String string, IConfigLookupHook iConfigLookupHook, Boolean bl) {
            if (iConfigLookupHook == null) {
                throw new IllegalArgumentException("hook is a mandatory parameter");
            }
            this.m_lookupPaths.add(string.toCharArray());
            this.m_hooks.add(iConfigLookupHook);
            this.m_bAbsoluteArgs.add(bl);
        }

        public IConfigElement onLookupElement(String string, IContext iContext) {
            IConfigElement iConfigElement = null;
            IConfigLookupHook iConfigLookupHook = null;
            for (int i = 0; iConfigElement == null && i < this.m_hooks.size(); ++i) {
                String string2 = this.getLookupArg(i, string);
                if (string2 == null) continue;
                iConfigLookupHook = this.m_hooks.get(i);
                iConfigElement = iConfigLookupHook.onLookupElement(string2, iContext);
            }
            return iConfigElement;
        }

        public String onLookupString(String string, IContext iContext) {
            String string2 = null;
            IConfigLookupHook iConfigLookupHook = null;
            for (int i = 0; string2 == null && i < this.m_hooks.size(); ++i) {
                String string3 = this.getLookupArg(i, string);
                if (string3 == null) continue;
                iConfigLookupHook = this.m_hooks.get(i);
                string2 = iConfigLookupHook.onLookupString(string3, iContext);
            }
            return string2;
        }

        public Boolean onLookupBoolean(String string, IContext iContext) {
            Boolean bl = null;
            IConfigLookupHook iConfigLookupHook = null;
            for (int i = 0; bl == null && i < this.m_hooks.size(); ++i) {
                String string2 = this.getLookupArg(i, string);
                if (string2 == null) continue;
                iConfigLookupHook = this.m_hooks.get(i);
                bl = iConfigLookupHook.onLookupBoolean(string2, iContext);
            }
            return bl;
        }

        public Integer onLookupInteger(String string, IContext iContext) {
            Integer n = null;
            IConfigLookupHook iConfigLookupHook = null;
            for (int i = 0; n == null && i < this.m_hooks.size(); ++i) {
                String string2 = this.getLookupArg(i, string);
                if (string2 == null) continue;
                iConfigLookupHook = this.m_hooks.get(i);
                n = iConfigLookupHook.onLookupInteger(string2, iContext);
            }
            return n;
        }

        private String getLookupArg(int n, String string) {
            String string2 = null;
            char[] cArray = string.toCharArray();
            char[] cArray2 = (char[])this.m_lookupPaths.get(n);
            int n2 = this.comparePaths(cArray2, cArray);
            if (n2 != -1) {
                string2 = this.m_bAbsoluteArgs.get(n) == Boolean.TRUE ? string : new String(cArray, n2, cArray.length - n2);
            }
            return string2;
        }

        private int comparePaths(char[] cArray, char[] cArray2) {
            int n = -1;
            int n2 = 0;
            int n3 = 0;
            while (cArray2.length - n3 >= cArray.length - n2) {
                while (n2 < cArray.length && cArray[n2] == cArray2[n3]) {
                    ++n2;
                    ++n3;
                }
                if (cArray2[n3] != '[') break;
                while (++n3 < cArray2.length && cArray2[n3] != ']') {
                }
                ++n3;
            }
            if (cArray[n2] == '*') {
                n = n3;
            } else if (n3 == cArray2.length) {
                n = cArray2.length;
            }
            return n;
        }
    }
}

