/*
 * Decompiled with CFR 0.152.
 */
package com.documentum.services.config.impl;

import com.documentum.services.config.IContext;
import com.documentum.services.config.IQualifier;
import com.documentum.services.config.impl.ScopeKey;
import java.util.HashMap;
import java.util.Map;

public final class BoundedContextCache {
    private static final String NULL_STRING = "null marker";
    private Map<IContext, ScopeKey> m_context2ScopeKey = new HashMap<IContext, ScopeKey>();
    private Map<IQualifier, String> m_qualifier2Value = new HashMap<IQualifier, String>();
    private boolean m_trackContext = false;
    private boolean m_allowClear = true;
    private static ThreadLocal<BoundedContextCache> s_caches = new ThreadLocal();

    private BoundedContextCache() {
    }

    public static boolean conditionalStart() {
        boolean bl = false;
        if (BoundedContextCache.getInstance() == null) {
            s_caches.set(new BoundedContextCache());
            bl = true;
        }
        return bl;
    }

    public static void end() {
        BoundedContextCache boundedContextCache = BoundedContextCache.getHardInstance();
        boundedContextCache.release();
        s_caches.remove();
    }

    public static BoundedContextCache getInstance() {
        return s_caches.get();
    }

    public static boolean isStarted() {
        return BoundedContextCache.getInstance() != null;
    }

    public void trackContext(boolean bl) {
        this.m_trackContext = bl;
        if (!bl) {
            this.m_context2ScopeKey.clear();
        }
    }

    public boolean isContextTracked() {
        return this.m_trackContext;
    }

    ScopeKey getScopeKey(IContext iContext) {
        return this.m_context2ScopeKey.get(iContext);
    }

    void setScopeKey(IContext iContext, ScopeKey scopeKey) {
        this.m_context2ScopeKey.put(iContext, scopeKey);
    }

    String retrieveQualifierScopeValue(IQualifier iQualifier, IContext iContext) {
        String[] stringArray = iQualifier.getContextNames();
        if (stringArray != null && (stringArray.length > 1 || stringArray.length == 1 && iContext.get(stringArray[0]) != null)) {
            return iQualifier.getScopeValue(iContext);
        }
        String string = this.m_qualifier2Value.get(iQualifier);
        if (string == null) {
            string = iQualifier.getScopeValue(iContext);
            if (string == null) {
                this.m_qualifier2Value.put(iQualifier, NULL_STRING);
            } else {
                this.m_qualifier2Value.put(iQualifier, string);
            }
        } else if (string == NULL_STRING) {
            string = null;
        }
        return string;
    }

    void clear() {
        if (this.m_allowClear) {
            this.release();
        }
    }

    void setAllowClear(boolean bl) {
        this.m_allowClear = bl;
    }

    boolean getAllowClear() {
        return this.m_allowClear;
    }

    private static BoundedContextCache getHardInstance() {
        BoundedContextCache boundedContextCache = BoundedContextCache.getInstance();
        if (boundedContextCache == null) {
            throw new IllegalStateException("BoundedContextCache has never been started");
        }
        return boundedContextCache;
    }

    private void release() {
        this.m_context2ScopeKey.clear();
        this.m_qualifier2Value.clear();
    }
}

