/*
 * Decompiled with CFR 0.152.
 */
package com.documentum.xerces_2_8_0.xml.serialize;

import com.documentum.xerces_2_8_0.xerces.dom.DOMMessageFormatter;
import com.documentum.xerces_2_8_0.xml.serialize.HTMLSerializer;
import com.documentum.xerces_2_8_0.xml.serialize.OutputFormat;
import com.documentum.xerces_2_8_0.xml.serialize.Serializer;
import com.documentum.xerces_2_8_0.xml.serialize.SerializerFactory;
import com.documentum.xerces_2_8_0.xml.serialize.TextSerializer;
import com.documentum.xerces_2_8_0.xml.serialize.XHTMLSerializer;
import com.documentum.xerces_2_8_0.xml.serialize.XMLSerializer;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.io.Writer;

final class SerializerFactoryImpl
extends SerializerFactory {
    private String _method;

    SerializerFactoryImpl(String string) {
        this._method = string;
        if (!(this._method.equals("xml") || this._method.equals("html") || this._method.equals("xhtml") || this._method.equals("text"))) {
            String string2 = DOMMessageFormatter.formatMessage("http://apache.org/xml/serializer", "MethodNotSupported", new Object[]{string});
            throw new IllegalArgumentException(string2);
        }
    }

    public Serializer makeSerializer(OutputFormat outputFormat) {
        Serializer serializer = this.getSerializer(outputFormat);
        serializer.setOutputFormat(outputFormat);
        return serializer;
    }

    public Serializer makeSerializer(Writer writer, OutputFormat outputFormat) {
        Serializer serializer = this.getSerializer(outputFormat);
        serializer.setOutputCharStream(writer);
        return serializer;
    }

    public Serializer makeSerializer(OutputStream outputStream, OutputFormat outputFormat) throws UnsupportedEncodingException {
        Serializer serializer = this.getSerializer(outputFormat);
        serializer.setOutputByteStream(outputStream);
        return serializer;
    }

    private Serializer getSerializer(OutputFormat outputFormat) {
        if (this._method.equals("xml")) {
            return new XMLSerializer(outputFormat);
        }
        if (this._method.equals("html")) {
            return new HTMLSerializer(outputFormat);
        }
        if (this._method.equals("xhtml")) {
            return new XHTMLSerializer(outputFormat);
        }
        if (this._method.equals("text")) {
            return new TextSerializer();
        }
        String string = DOMMessageFormatter.formatMessage("http://apache.org/xml/serializer", "MethodNotSupported", new Object[]{this._method});
        throw new IllegalStateException(string);
    }

    protected String getSupportedMethod() {
        return this._method;
    }
}

