/*
 * Decompiled with CFR 0.152.
 */
package com.documentum.tracing.tracer;

import com.documentum.fc.common.DfPreferences;
import com.documentum.fc.common.impl.preferences.IPreferencesObserver;
import com.documentum.fc.common.impl.preferences.TypedPreferences;
import com.documentum.tracing.core.Parameter;
import com.documentum.tracing.tracer.DfExceptionInfo;
import com.documentum.tracing.tracer.DfMessageInfo;
import com.documentum.tracing.tracer.IDfTraceInfo;
import com.documentum.tracing.tracer.MethodInfo;
import com.documentum.tracing.tracer.ObjectClassCountInfo;
import com.documentum.tracing.tracer.ScopeStackElement;
import com.documentum.tracing.tracer.ThreadContext;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;

public final class DfTracer {
    public static boolean s_globalTraceEnabled = false;
    private static ThreadLocal s_threadContext = new ThreadLocal();
    private static Map s_objects = Collections.synchronizedMap(new IdentityHashMap());
    private static Map s_classes = Collections.synchronizedMap(new HashMap());
    private static ReferenceQueue s_refQueue = new ReferenceQueue();
    private static Thread s_refObjCounter = null;
    private static Map s_classNameMap = new HashMap(1001);
    private static boolean s_traceEnabledProgramatically = false;
    private static int s_stackDepth = 0;
    private static int s_maximumLevel = 99999;
    private static boolean s_reportObjectCreation = false;
    private static boolean s_recordParameters = false;
    private static boolean s_recordReturnValue = false;
    private static final String INDENT_PATTERN = "................................................................................................................................................................................................................................................................................................................................................................................................................................................................................................................................................................................................................................................................................................................................................................................................................................";
    private static final int INDENT_SIZE = 1;

    public static void enableThreadTrace(boolean enableTrace) {
        DfTracer.getThreadContext().enableThreadTrace(enableTrace);
    }

    public static void enableTrace(boolean enableTrace) {
        s_globalTraceEnabled = enableTrace;
        s_traceEnabledProgramatically = true;
    }

    public static boolean isEnabled() {
        if (s_globalTraceEnabled) {
            return DfTracer.getThreadContext().getEnabledThreadTrace() <= 0;
        }
        return false;
    }

    public static boolean getRecordParameters() {
        return s_recordParameters;
    }

    public static boolean getRecordReturnValue() {
        return s_recordReturnValue;
    }

    public static void traceMethodExit(String name, int accMode, Class methodClass, Object called, Throwable e) {
        if (DfTracer.isEnabled()) {
            DfTracer.traceMethodExit(accMode, methodClass, e, name, "'VOID'", called, false);
        }
    }

    public static void traceMethodExit(String name, String category, Throwable e) {
        if (DfTracer.isEnabled()) {
            DfTracer.traceMethodExit(name, category, e, "'VOID'", false);
        }
    }

    public static void traceMethodExit(String name, int accMode, Class methodClass, Object called, Throwable e, int result) {
        if (DfTracer.isEnabled()) {
            DfTracer.traceMethodExit(accMode, methodClass, e, name, Integer.toString(result), called, true);
        }
    }

    public static void traceMethodExit(String name, String category, Throwable e, int result) {
        if (DfTracer.isEnabled()) {
            DfTracer.traceMethodExit(name, category, e, Integer.toString(result), true);
        }
    }

    public static void traceMethodExit(String name, int accMode, Class methodClass, Object called, Throwable e, boolean result) {
        if (DfTracer.isEnabled()) {
            DfTracer.traceMethodExit(accMode, methodClass, e, name, result ? "'true'" : "'false'", called, true);
        }
    }

    public static void traceMethodExit(String name, String category, Throwable e, boolean result) {
        if (DfTracer.isEnabled()) {
            DfTracer.traceMethodExit(name, category, e, result ? "'true'" : "'false'", true);
        }
    }

    public static void traceMethodExit(String name, int accMode, Class methodClass, Object called, Throwable e, double result) {
        if (DfTracer.isEnabled()) {
            DfTracer.traceMethodExit(accMode, methodClass, e, name, Double.toString(result), called, true);
        }
    }

    public static void traceMethodExit(String name, String category, Throwable e, double result) {
        if (DfTracer.isEnabled()) {
            DfTracer.traceMethodExit(name, category, e, Double.toString(result), true);
        }
    }

    public static void traceMethodExit(String name, int accMode, Class methodClass, Object called, Throwable e, float result) {
        if (DfTracer.isEnabled()) {
            DfTracer.traceMethodExit(accMode, methodClass, e, name, Float.toString(result), called, true);
        }
    }

    public static void traceMethodExit(String name, String category, Throwable e, float result) {
        if (DfTracer.isEnabled()) {
            DfTracer.traceMethodExit(name, category, e, Float.toString(result), true);
        }
    }

    public static void traceMethodExit(String name, int accMode, Class methodClass, Object called, Throwable e, short result) {
        if (DfTracer.isEnabled()) {
            DfTracer.traceMethodExit(accMode, methodClass, e, name, Short.toString(result), called, true);
        }
    }

    public static void traceMethodExit(String name, String category, Throwable e, short result) {
        if (DfTracer.isEnabled()) {
            DfTracer.traceMethodExit(name, category, e, Short.toString(result), true);
        }
    }

    public static void traceMethodExit(String name, int accMode, Class methodClass, Object called, Throwable e, long result) {
        if (DfTracer.isEnabled()) {
            DfTracer.traceMethodExit(accMode, methodClass, e, name, Long.toString(result), called, true);
        }
    }

    public static void traceMethodExit(String name, String category, Throwable e, long result) {
        if (DfTracer.isEnabled()) {
            DfTracer.traceMethodExit(name, category, e, Long.toString(result), true);
        }
    }

    public static void traceMethodExit(String name, int accMode, Class methodClass, Object called, Throwable e, byte result) {
        if (DfTracer.isEnabled()) {
            DfTracer.traceMethodExit(accMode, methodClass, e, name, Byte.toString(result), called, true);
        }
    }

    public static void traceMethodExit(String name, String category, Throwable e, byte result) {
        if (DfTracer.isEnabled()) {
            DfTracer.traceMethodExit(name, category, e, Byte.toString(result), true);
        }
    }

    public static void traceMethodExit(String name, int accMode, Class methodClass, Object called, Throwable e, char result) {
        if (DfTracer.isEnabled()) {
            DfTracer.traceMethodExit(accMode, methodClass, e, name, new Character(result).toString(), called, true);
        }
    }

    public static void traceMethodExit(String name, String category, Throwable e, char result) {
        if (DfTracer.isEnabled()) {
            DfTracer.traceMethodExit(name, category, e, new Character(result).toString(), true);
        }
    }

    public static void traceMethodExit(String name, int accMode, Class methodClass, Object called, Throwable e, Object result) {
        if (DfTracer.isEnabled()) {
            String resAsString = null;
            if (result != null) {
                resAsString = DfTracer.getResultAsString(result);
            }
            DfTracer.traceMethodExit(accMode, methodClass, e, name, resAsString, called, true);
        }
    }

    public static void traceMethodExit(String name, String category, Throwable e, Object result) {
        if (DfTracer.isEnabled()) {
            String resAsString = null;
            if (result != null) {
                resAsString = DfTracer.getResultAsString(result);
            }
            DfTracer.traceMethodExit(name, category, e, resAsString, true);
        }
    }

    private static String getResultAsString(Object result) {
        return result.getClass().getName() + "@" + Integer.toHexString(result.getClass().hashCode());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void traceMethodExit(int type, Class methodClass, Throwable e, String name, String result, Object called, boolean printReturnValue) {
        ThreadContext context = DfTracer.getThreadContext();
        try {
            context.enableThreadTrace(false);
            int level = context.decrement();
            if (DfTracer.isOutputNeeded(level)) {
                DfTracer.markMethodExitInTheMethodTraceCache(context, name, called, methodClass, type, level, e, result, printReturnValue);
            }
            if (s_reportObjectCreation && (type & 0x40) != 0) {
                DfTracer.processObjectCreation(called);
            }
            context.popScopeElement();
        }
        finally {
            context.enableThreadTrace(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void traceMethodExit(String name, String category, Throwable e, String result, boolean printReturnValue) {
        ThreadContext context = DfTracer.getThreadContext();
        try {
            context.enableThreadTrace(false);
            int level = context.decrement();
            if (DfTracer.isOutputNeeded(level)) {
                DfTracer.markMethodExitInTheMethodTraceCache(context, name, category, level, e, result, printReturnValue);
            }
            context.popScopeElement();
        }
        finally {
            context.enableThreadTrace(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void traceMethodEntrance(String name, int accMode, Parameter[] parameters, Class methodClass, Object called, String returnType) {
        if (DfTracer.isEnabled()) {
            ThreadContext context = DfTracer.getThreadContext();
            try {
                context.enableThreadTrace(false);
                int level = context.increment();
                context.pushScopeElement(new ScopeStackElement(name, accMode, parameters, methodClass, called, returnType));
                if (DfTracer.isOutputNeeded(level)) {
                    DfTracer.appendMethod2MethodTraceCache(context, new MethodInfo(context, name, accMode, parameters, methodClass, called, level, returnType));
                }
            }
            finally {
                context.enableThreadTrace(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void traceMethodEntrance(String name, String[] parameters, String category, String returnType) {
        if (DfTracer.isEnabled()) {
            ThreadContext context = DfTracer.getThreadContext();
            try {
                context.enableThreadTrace(false);
                int level = context.increment();
                Parameter[] params = null;
                if (parameters != null) {
                    params = new Parameter[parameters.length];
                    for (int i = 0; i < parameters.length; ++i) {
                        params[i] = new Parameter(parameters[i]);
                    }
                }
                context.pushScopeElement(new ScopeStackElement(name, params, category, returnType));
                if (DfTracer.isOutputNeeded(level)) {
                    DfTracer.appendMethod2MethodTraceCache(context, new MethodInfo(context, name, params, category, level, returnType));
                }
            }
            finally {
                context.enableThreadTrace(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void message(Class methodClass, Object called, String msg) {
        if (DfTracer.isEnabled()) {
            ThreadContext context = DfTracer.getThreadContext();
            try {
                context.enableThreadTrace(false);
                int level = context.getDepth();
                if (DfTracer.isOutputNeeded(level)) {
                    DfTracer.appendMethod2MethodTraceCache(context, new DfMessageInfo(methodClass, called, level, msg));
                }
            }
            finally {
                context.enableThreadTrace(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void message(String category, String msg) {
        if (DfTracer.isEnabled()) {
            ThreadContext context = DfTracer.getThreadContext();
            try {
                context.enableThreadTrace(false);
                int level = context.getDepth();
                if (DfTracer.isOutputNeeded(level)) {
                    DfTracer.appendMethod2MethodTraceCache(context, new DfMessageInfo(category, level, msg));
                }
            }
            finally {
                context.enableThreadTrace(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void exceptionInfo(int accMode, Class methodClass, Object called, Throwable e, String exceptionType) {
        if (DfTracer.isEnabled()) {
            ThreadContext context = DfTracer.getThreadContext();
            try {
                context.enableThreadTrace(false);
                int level = context.getDepth();
                if (DfTracer.isOutputNeeded(level)) {
                    DfTracer.appendMethod2MethodTraceCache(context, new DfExceptionInfo(methodClass, called, accMode, level, e, exceptionType));
                }
            }
            finally {
                context.enableThreadTrace(true);
            }
        }
    }

    public static void dumpObjectInfo(OutputStream out) {
        if (!s_reportObjectCreation) {
            return;
        }
        PrintWriter printer = new PrintWriter(out);
        ArrayList sortedItems = new ArrayList(s_classes.size() + 1);
        sortedItems.addAll(s_classes.values());
        Collections.sort(sortedItems, new Comparator(){

            public int compare(Object o1, Object o2) {
                return ((ObjectClassCountInfo)o1).getClassName().compareTo(((ObjectClassCountInfo)o2).getClassName());
            }
        });
        for (ObjectClassCountInfo info : sortedItems) {
            printer.println("Class: " + info.getClassName() + "    " + info.getActiveCount() + "/" + info.getTotalCount());
        }
        printer.println("Total: " + ObjectClassCountInfo.getAllActiveObjects() + "/" + ObjectClassCountInfo.getAllObjects());
        printer.flush();
    }

    private static boolean isOutputNeeded(int level) {
        return level <= s_maximumLevel;
    }

    protected static String getIndent(int level) {
        int endIndex = level * 1;
        if (endIndex > INDENT_PATTERN.length()) {
            endIndex = INDENT_PATTERN.length();
        }
        return INDENT_PATTERN.substring(0, endIndex);
    }

    private static ThreadContext getThreadContext() {
        ThreadContext context = (ThreadContext)s_threadContext.get();
        if (context == null) {
            context = new ThreadContext(s_stackDepth);
            s_threadContext.set(context);
        }
        return context;
    }

    private static void appendMethod2MethodTraceCache(ThreadContext context, IDfTraceInfo method) {
        List methods = context.getMethodTraceCache();
        methods.add(method);
        if (methods.size() >= s_stackDepth) {
            DfTracer.freeupStack(context, methods);
        }
    }

    private static void markMethodExitInTheMethodTraceCache(ThreadContext context, String name, Object called, Class methodClass, int type, int level, Throwable e, String result, boolean printReturnValue) {
        List methods = context.getMethodTraceCache();
        MethodInfo method = DfTracer.findNonCompleteMethod(methods, level);
        if (method == null) {
            method = new MethodInfo(context, name, type, null, methodClass, called, level, null);
            method.setResult(result);
            method.setException(e);
            method.setPrintReturnValue(printReturnValue);
            method.printMethodExit(context);
        } else {
            method.setResult(result);
            method.setException(e);
            method.setPrintReturnValue(printReturnValue);
            if (methods.get(0) == method) {
                DfTracer.flushMethodTraceCache(context);
            }
        }
        if (level == 0) {
            DfTracer.flushMethodTraceCache(context);
        }
    }

    private static void markMethodExitInTheMethodTraceCache(ThreadContext context, String name, String category, int level, Throwable e, String result, boolean printReturnValue) {
        List methods = context.getMethodTraceCache();
        MethodInfo method = DfTracer.findNonCompleteMethod(methods, level);
        if (method == null) {
            method = new MethodInfo(context, name, null, category, level, null);
            method.setResult(result);
            method.setException(e);
            method.setPrintReturnValue(printReturnValue);
            method.printMethodExit(context);
        } else {
            method.setResult(result);
            method.setException(e);
            method.setPrintReturnValue(printReturnValue);
            if (methods.get(0) == method) {
                DfTracer.flushMethodTraceCache(context);
            }
        }
        if (level == 0) {
            DfTracer.flushMethodTraceCache(context);
        }
    }

    protected static void flushMethodTraceCache(ThreadContext context) {
        List methods = context.getMethodTraceCache();
        for (IDfTraceInfo info : methods) {
            info.print(context);
        }
        methods.clear();
    }

    private static void freeupStack(ThreadContext context, List methods) {
        IDfTraceInfo method = (IDfTraceInfo)methods.get(0);
        method.print(context);
        methods.remove(0);
        if (methods.size() > 0 && (method = (IDfTraceInfo)methods.get(0)).isComplete()) {
            DfTracer.flushMethodTraceCache(context);
        }
    }

    private static MethodInfo findNonCompleteMethod(List methods, int level) {
        for (int i = methods.size() - 1; i >= 0; --i) {
            IDfTraceInfo info = (IDfTraceInfo)methods.get(i);
            if (info.getLevel() != level || info.isComplete()) continue;
            return (MethodInfo)info;
        }
        return null;
    }

    private static void processObjectCreation(Object called) {
        ObjectClassCountInfo info;
        String className = (String)s_objects.get(called);
        if (className != null) {
            info = (ObjectClassCountInfo)s_classes.get(className);
            info.clearObject();
        }
        if ((info = (ObjectClassCountInfo)s_classes.get(className = called.getClass().getName())) == null) {
            info = new ObjectClassCountInfo(className);
            s_classes.put(className, info);
        }
        info.newObject();
        s_objects.put(new WeakReference<Object>(called, s_refQueue), className);
        DfTracer.startRefObjCounterThread();
    }

    private static void startRefObjCounterThread() {
        if (s_refObjCounter != null) {
            return;
        }
        s_refObjCounter = new Thread(){

            public void run() {
                try {
                    while (true) {
                        Reference ref = s_refQueue.remove();
                        String className = (String)s_objects.get(ref);
                        ObjectClassCountInfo info = (ObjectClassCountInfo)s_classes.get(className);
                        info.destroyObject();
                    }
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
        };
        s_refObjCounter.setDaemon(true);
        s_refObjCounter.start();
    }

    public static synchronized String getMethodClassName(Class classObj) {
        String name = (String)s_classNameMap.get(classObj);
        if (name == null) {
            name = classObj.getName();
            s_classNameMap.put(classObj, name);
        }
        return name;
    }

    static {
        new PreferencesObserver();
    }

    private static class PreferencesObserver
    implements IPreferencesObserver {
        public PreferencesObserver() {
            DfPreferences.getInstance().addObserver(this);
            this.update(DfPreferences.getInstance(), null);
        }

        public void update(TypedPreferences typedPreferences, String preferenceName) {
            DfPreferences preferences = (DfPreferences)typedPreferences;
            s_stackDepth = preferences.getTracingStackDepth();
            s_recordParameters = true;
            s_recordReturnValue = true;
            if (!s_traceEnabledProgramatically) {
                s_globalTraceEnabled = preferences.isTracingEnabled();
            }
        }
    }
}

