/*
 * Decompiled with CFR 0.152.
 */
package com.documentum.thirdparty.javassist;

import com.documentum.thirdparty.javassist.CannotCompileException;
import com.documentum.thirdparty.javassist.ClassPool;
import com.documentum.thirdparty.javassist.CtClass;
import com.documentum.thirdparty.javassist.CtClassType;
import com.documentum.thirdparty.javassist.CtConstructor;
import com.documentum.thirdparty.javassist.CtNewConstructor;
import com.documentum.thirdparty.javassist.Modifier;
import com.documentum.thirdparty.javassist.NotFoundException;
import com.documentum.thirdparty.javassist.bytecode.ClassFile;
import java.io.DataOutputStream;
import java.io.IOException;

class CtNewClass
extends CtClassType {
    protected boolean hasConstructor;

    CtNewClass(String name, ClassPool cp, boolean isInterface, CtClass superclass) {
        super(name, cp);
        this.wasChanged = true;
        this.eraseCache();
        String superName = superclass == null ? null : superclass.getName();
        this.classfile = new ClassFile(isInterface, name, superName);
        this.setModifiers(Modifier.setPublic(this.getModifiers()));
        this.hasConstructor = isInterface;
    }

    protected void extendToString(StringBuffer buffer) {
        if (this.hasConstructor) {
            buffer.append("hasConstructor ");
        }
        super.extendToString(buffer);
    }

    public void addConstructor(CtConstructor c) throws CannotCompileException {
        this.hasConstructor = true;
        super.addConstructor(c);
    }

    public void toBytecode(DataOutputStream out) throws CannotCompileException, IOException {
        if (!this.hasConstructor) {
            try {
                this.inheritAllConstructors();
                this.hasConstructor = true;
            }
            catch (NotFoundException e) {
                throw new CannotCompileException(e);
            }
        }
        super.toBytecode(out);
    }

    public void inheritAllConstructors() throws CannotCompileException, NotFoundException {
        CtClass superclazz = this.getSuperclass();
        CtConstructor[] cs = superclazz.getDeclaredConstructors();
        int n = 0;
        for (int i = 0; i < cs.length; ++i) {
            CtConstructor c = cs[i];
            if (!Modifier.isPublic(c.getModifiers())) continue;
            CtConstructor cons = CtNewConstructor.make(c.getParameterTypes(), c.getExceptionTypes(), this);
            this.addConstructor(cons);
            ++n;
        }
        if (n < 1) {
            throw new CannotCompileException("no public constructor in " + superclazz.getName());
        }
    }
}

