/*
 * Decompiled with CFR 0.152.
 */
package com.documentum.thirdparty.javassist;

import com.documentum.thirdparty.javassist.CtClass;
import com.documentum.thirdparty.javassist.Modifier;

public abstract class CtMember {
    protected CtMember next;
    protected CtClass declaringClass;

    protected CtMember(CtClass clazz) {
        this.declaringClass = clazz;
    }

    static CtMember append(CtMember list, CtMember previousTail, CtMember tail) {
        tail.next = null;
        if (list == null) {
            return tail;
        }
        previousTail.next = tail;
        return list;
    }

    static CtMember append(CtMember list, CtMember tail) {
        tail.next = null;
        if (list == null) {
            return tail;
        }
        CtMember lst = list;
        while (lst.next != null) {
            lst = lst.next;
        }
        lst.next = tail;
        return list;
    }

    static int count(CtMember f) {
        int n = 0;
        while (f != null) {
            ++n;
            f = f.next;
        }
        return n;
    }

    static CtMember remove(CtMember list, CtMember m) {
        CtMember top = list;
        if (list == null) {
            return null;
        }
        if (list == m) {
            return list.next;
        }
        while (list.next != null) {
            if (list.next == m) {
                list.next = list.next.next;
                break;
            }
            list = list.next;
        }
        return top;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(this.getClass().getName());
        buffer.append("@");
        buffer.append(Integer.toHexString(this.hashCode()));
        buffer.append("[");
        buffer.append(Modifier.toString(this.getModifiers()));
        this.extendToString(buffer);
        buffer.append("]");
        return buffer.toString();
    }

    protected abstract void extendToString(StringBuffer var1);

    public CtClass getDeclaringClass() {
        return this.declaringClass;
    }

    public boolean visibleFrom(CtClass clazz) {
        int mod = this.getModifiers();
        if (Modifier.isPublic(mod)) {
            return true;
        }
        if (Modifier.isPrivate(mod)) {
            return clazz == this.declaringClass;
        }
        String declName = this.declaringClass.getPackageName();
        String fromName = clazz.getPackageName();
        boolean visible = declName == null ? fromName == null : declName.equals(fromName);
        if (!visible && Modifier.isProtected(mod)) {
            return clazz.subclassOf(this.declaringClass);
        }
        return visible;
    }

    public abstract int getModifiers();

    public abstract void setModifiers(int var1);

    public abstract Object[] getAnnotations() throws ClassNotFoundException;

    public abstract Object[] getAvailableAnnotations() throws ClassNotFoundException;

    public abstract String getName();

    public abstract String getSignature();

    public abstract byte[] getAttribute(String var1);

    public abstract void setAttribute(String var1, byte[] var2);
}

