/*
 * Decompiled with CFR 0.152.
 */
package com.documentum.thirdparty.javassist;

import com.documentum.thirdparty.javassist.CannotCompileException;
import com.documentum.thirdparty.javassist.CtClass;
import com.documentum.thirdparty.javassist.CtField;
import com.documentum.thirdparty.javassist.CtMethod;
import com.documentum.thirdparty.javassist.NotFoundException;
import com.documentum.thirdparty.javassist.bytecode.BadBytecode;
import com.documentum.thirdparty.javassist.bytecode.CodeAttribute;
import com.documentum.thirdparty.javassist.bytecode.CodeIterator;
import com.documentum.thirdparty.javassist.bytecode.ConstPool;
import com.documentum.thirdparty.javassist.bytecode.MethodInfo;
import com.documentum.thirdparty.javassist.convert.TransformAfter;
import com.documentum.thirdparty.javassist.convert.TransformBefore;
import com.documentum.thirdparty.javassist.convert.TransformCall;
import com.documentum.thirdparty.javassist.convert.TransformFieldAccess;
import com.documentum.thirdparty.javassist.convert.TransformNew;
import com.documentum.thirdparty.javassist.convert.TransformReadField;
import com.documentum.thirdparty.javassist.convert.TransformWriteField;
import com.documentum.thirdparty.javassist.convert.Transformer;

public class CodeConverter {
    Transformer transformers = null;

    public void replaceNew(CtClass newClass, CtClass calledClass, String calledMethod) {
        this.transformers = new TransformNew(this.transformers, newClass.getName(), calledClass.getName(), calledMethod);
    }

    public void redirectFieldAccess(CtField field, CtClass newClass, String newFieldname) {
        this.transformers = new TransformFieldAccess(this.transformers, field, newClass.getName(), newFieldname);
    }

    public void replaceFieldRead(CtField field, CtClass calledClass, String calledMethod) {
        this.transformers = new TransformReadField(this.transformers, field, calledClass.getName(), calledMethod);
    }

    public void replaceFieldWrite(CtField field, CtClass calledClass, String calledMethod) {
        this.transformers = new TransformWriteField(this.transformers, field, calledClass.getName(), calledMethod);
    }

    public void redirectMethodCall(CtMethod origMethod, CtMethod substMethod) throws CannotCompileException {
        String d2;
        String d1 = origMethod.getMethodInfo2().getDescriptor();
        if (!d1.equals(d2 = substMethod.getMethodInfo2().getDescriptor())) {
            throw new CannotCompileException("signature mismatch");
        }
        this.transformers = new TransformCall(this.transformers, origMethod, substMethod);
    }

    public void insertBeforeMethod(CtMethod origMethod, CtMethod beforeMethod) throws CannotCompileException {
        try {
            this.transformers = new TransformBefore(this.transformers, origMethod, beforeMethod);
        }
        catch (NotFoundException e) {
            throw new CannotCompileException(e);
        }
    }

    public void insertAfterMethod(CtMethod origMethod, CtMethod afterMethod) throws CannotCompileException {
        try {
            this.transformers = new TransformAfter(this.transformers, origMethod, afterMethod);
        }
        catch (NotFoundException e) {
            throw new CannotCompileException(e);
        }
    }

    void doit(CtClass clazz, MethodInfo minfo, ConstPool cp) throws CannotCompileException {
        Transformer t;
        CodeAttribute codeAttr = minfo.getCodeAttribute();
        if (codeAttr == null || this.transformers == null) {
            return;
        }
        for (t = this.transformers; t != null; t = t.getNext()) {
            t.initialize(cp, codeAttr);
        }
        CodeIterator iterator = codeAttr.iterator();
        while (iterator.hasNext()) {
            try {
                int pos = iterator.next();
                for (t = this.transformers; t != null; t = t.getNext()) {
                    pos = t.transform(clazz, pos, iterator, cp);
                }
            }
            catch (BadBytecode e) {
                throw new CannotCompileException(e);
            }
        }
        int locals = 0;
        for (t = this.transformers; t != null; t = t.getNext()) {
            int s = t.extraLocals();
            if (s <= locals) continue;
            locals = s;
        }
        for (t = this.transformers; t != null; t = t.getNext()) {
            t.clean();
        }
        codeAttr.setMaxLocals(codeAttr.getMaxLocals() + locals);
    }
}

