/*
 * Decompiled with CFR 0.152.
 */
package com.documentum.storage;

import com.documentum.fc.common.DfException;
import com.documentum.storage.IStoreAccessor;

public class StoreAccessorException
extends DfException {
    private IStoreAccessor storeAccessor;

    public static StoreAccessorException newStartException(IStoreAccessor storeAccessor, Throwable cause) {
        return StoreAccessorException.newOperationException(storeAccessor, "start", cause);
    }

    public static StoreAccessorException newStopException(IStoreAccessor storeAccessor, Throwable cause) {
        return StoreAccessorException.newOperationException(storeAccessor, "stop", cause);
    }

    public static StoreAccessorException newCreateException(IStoreAccessor storeAccessor, Throwable cause) {
        return StoreAccessorException.newOperationException(storeAccessor, "create", cause);
    }

    public static StoreAccessorException newReadContentException(IStoreAccessor storeAccessor, Throwable cause) {
        return StoreAccessorException.newOperationException(storeAccessor, "readContent", cause);
    }

    public static StoreAccessorException newReadMetaDataException(IStoreAccessor storeAccessor, Throwable cause) {
        return StoreAccessorException.newOperationException(storeAccessor, "readMetaData", cause);
    }

    public static StoreAccessorException newReadPoliciesException(IStoreAccessor storeAccessor, Throwable cause) {
        return StoreAccessorException.newOperationException(storeAccessor, "readPolicies", cause);
    }

    public static StoreAccessorException newUpdateException(IStoreAccessor storeAccessor, Throwable cause) {
        return StoreAccessorException.newOperationException(storeAccessor, "update", cause);
    }

    public static StoreAccessorException newDeleteException(IStoreAccessor storeAccessor, Throwable cause) {
        return StoreAccessorException.newOperationException(storeAccessor, "delete", cause);
    }

    public static StoreAccessorException newPluginInitializationException() {
        return StoreAccessorException.newOperationException("Store Plugin Initialization");
    }

    public static StoreAccessorException newStoreUnreachableException(IStoreAccessor storeAccessor, Throwable cause) {
        return StoreAccessorException.newOperationException(storeAccessor, "Plugin can't access the store", cause);
    }

    private static StoreAccessorException newOperationException(IStoreAccessor storeAccessor, String operationName, Throwable cause) {
        return new StoreAccessorException("Store accessor {0} failed during ''{1}''", storeAccessor, new Object[]{storeAccessor.getClass().getName(), operationName}, cause);
    }

    private static StoreAccessorException newOperationException(String operationName) {
        return new StoreAccessorException("No StoreAccessor provided, it was null. Failed during ''{0}''", null, new Object[]{operationName});
    }

    protected StoreAccessorException(String message, IStoreAccessor storeAccessor, Object[] arguments) {
        super(message, arguments);
        this.storeAccessor = storeAccessor;
    }

    protected StoreAccessorException(String message, IStoreAccessor storeAccessor, Object[] arguments, Throwable cause) {
        super(message, arguments, cause);
        this.storeAccessor = storeAccessor;
    }

    public IStoreAccessor getStoreAccessor() {
        return this.storeAccessor;
    }
}

