/*
 * Decompiled with CFR 0.152.
 */
package com.documentum.operations;

import com.documentum.fc.client.DfQuery;
import com.documentum.fc.client.IDfCollection;
import com.documentum.fc.client.IDfFormat;
import com.documentum.fc.client.IDfSession;
import com.documentum.fc.common.DfConstants;
import com.documentum.fc.common.DfException;
import com.documentum.fc.common.DfList;
import com.documentum.fc.common.DfLogger;
import com.documentum.fc.common.DfObject;
import com.documentum.fc.common.IDfList;
import com.documentum.fc.tracing.impl.aspects.BaseTracingAspect;
import com.documentum.fc.tracing.impl.aspects.TracingAspect;
import com.documentum.operations.IDfFormatRecognizer;
import com.documentum.operations.IDfRemoteFileMetadata;
import com.documentum.operations.IDfVDMPlatformUtils;
import com.documentum.operations.impl.DfFile;
import com.documentum.operations.impl.DfOpUtils;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;

public class DfFormatRecognizer
extends DfObject
implements IDfFormatRecognizer {
    protected IDfSession m_session;
    protected String m_filePath;
    protected String m_fileExtension;
    protected String m_suggestedFormat;
    protected IDfList m_formatList;
    protected String m_clsid;
    protected boolean m_includeHiddenFormats;
    private static IDfVDMPlatformUtils m_platformUtils;
    private static Thread m_platformUtilsCreatorThread;
    private static final String DOS_TEXT_FORMAT = "crtext";
    private static final String UNIX_TEXT_FORMAT = "text";
    protected static final String CLSID_WORD6 = "{00020900-0000-0000-C000-000000000046}";
    protected static final String CLSID_WORD7 = "{00030003-0000-0000-C000-000000000046}";
    protected static final String CLSID_WORD8 = "{00020906-0000-0000-C000-000000000046}";
    protected static final String CLSID_EXCEL5BOOK = "{00020810-0000-0000-C000-000000000046}";
    protected static final String CLSID_EXCEL8BOOK = "{00020820-0000-0000-C000-000000000046}";
    protected static final String CLSID_POWERPOINTSHOW7 = "{EA7BAE70-FB3B-11CD-A903-00AA00510EA3}";
    protected static final String CLSID_POWERPOINTSLIDE7 = "{EA7BAE71-FB3B-11CD-A903-00AA00510EA3}";
    protected static final String CLSID_POWERPOINTSHOW8 = "{64818D10-4F9B-11CF-86EA-00AA00B929E8}";
    protected static final String CLSID_POWERPOINTSHOW8_TEMPLATE = "{64818D11-4F9B-11CF-86EA-00AA00B929E8}";
    protected static final String CLSID_ACCESS7 = "{B54DCF20-5F9C-101B-AF4E-00AA003F0F07}";
    protected static final String CLSID_ACCESS8 = "{8CC49940-3146-11CF-97A1-00AA00424A9F}";
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_9;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_10;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_11;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_12;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_13;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_14;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_15;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_16;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_17;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_18;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_19;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_20;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_21;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_22;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_23;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_24;

    public DfFormatRecognizer() {
        JoinPoint joinPoint = null;
        try {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_22, (Object)this, (Object)this);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            this.m_includeHiddenFormats = false;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_22, (Object)this, (Object)this);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$6$509ea924(joinPoint);
            }
            return;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_22, (Object)this, (Object)this);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    public DfFormatRecognizer(IDfSession session, String filePath, String suggestedFormat) throws DfException {
        IDfSession iDfSession = session;
        String string = filePath;
        String string2 = suggestedFormat;
        JoinPoint joinPoint = null;
        try {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    Object[] objectArray = new Object[]{iDfSession, string, string2};
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_23, (Object)this, (Object)this, (Object[])objectArray);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            this.m_includeHiddenFormats = false;
            this.init(session, filePath, suggestedFormat);
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    Object[] objectArray = new Object[]{iDfSession, string, string2};
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_23, (Object)this, (Object)this, (Object[])objectArray);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$6$509ea924(joinPoint);
            }
            return;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    Object[] objectArray = new Object[]{iDfSession, string, string2};
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_23, (Object)this, (Object)this, (Object[])objectArray);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    public DfFormatRecognizer(IDfSession session, String filePath, String suggestedFormat, boolean includeHiddenFormats) throws DfException {
        IDfSession iDfSession = session;
        String string = filePath;
        String string2 = suggestedFormat;
        boolean bl = includeHiddenFormats;
        JoinPoint joinPoint = null;
        try {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    Object[] objectArray = new Object[]{iDfSession, string, string2, Conversions.booleanObject((boolean)bl)};
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_24, (Object)this, (Object)this, (Object[])objectArray);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            this.m_includeHiddenFormats = false;
            this.init(session, filePath, suggestedFormat, includeHiddenFormats);
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    Object[] objectArray = new Object[]{iDfSession, string, string2, Conversions.booleanObject((boolean)bl)};
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_24, (Object)this, (Object)this, (Object[])objectArray);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$6$509ea924(joinPoint);
            }
            return;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    Object[] objectArray = new Object[]{iDfSession, string, string2, Conversions.booleanObject((boolean)bl)};
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_24, (Object)this, (Object)this, (Object[])objectArray);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void init(IDfSession iDfSession, String string, String string2, boolean bl) throws DfException {
        IDfSession iDfSession2 = iDfSession;
        String string3 = string;
        String string4 = string2;
        boolean bl2 = bl;
        JoinPoint joinPoint = null;
        try {
            void includeHiddenFormats;
            void suggestedFormat;
            void filePath;
            void session;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    Object[] objectArray = new Object[]{iDfSession2, string3, string4, Conversions.booleanObject((boolean)bl2)};
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object[])objectArray);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            this.init((IDfSession)session, (String)filePath, (String)suggestedFormat);
            this.m_includeHiddenFormats = includeHiddenFormats;
            Object var12_11 = null;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    Object[] objectArray = new Object[]{iDfSession2, string3, string4, Conversions.booleanObject((boolean)bl2)};
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object[])objectArray);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(var12_11, joinPoint);
            }
            return;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    Object[] objectArray = new Object[]{iDfSession2, string3, string4, Conversions.booleanObject((boolean)bl2)};
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object[])objectArray);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void init(IDfSession iDfSession, String string, String string2) throws DfException {
        IDfSession iDfSession2 = iDfSession;
        String string3 = string;
        String string4 = string2;
        JoinPoint joinPoint = null;
        try {
            void suggestedFormat;
            void filePath;
            void session;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    Object[] objectArray = new Object[]{iDfSession2, string3, string4};
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object[])objectArray);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            this.m_session = session;
            this.m_filePath = filePath;
            this.m_suggestedFormat = suggestedFormat;
            DfFile file = new DfFile((String)filePath);
            this.m_fileExtension = file.getExtension();
            this.m_formatList = null;
            this.m_clsid = null;
            Object var11_10 = null;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    Object[] objectArray = new Object[]{iDfSession2, string3, string4};
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object[])objectArray);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(var11_10, joinPoint);
            }
            return;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    Object[] objectArray = new Object[]{iDfSession2, string3, string4};
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object[])objectArray);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    public IDfList getSuggestedFileFormats() throws DfException {
        JoinPoint joinPoint = null;
        try {
            IDfList iDfList;
            IDfList iDfList2;
            IDfList iDfList3;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            if (this.m_formatList != null) {
                iDfList2 = iDfList3 = this.m_formatList;
            } else {
                this.m_formatList = new DfList();
                IDfList platformFormatList = this.getPlatformFormatSuggestions();
                if (platformFormatList != null) {
                    this.m_formatList.insertAll(0, platformFormatList);
                }
                if (this.m_suggestedFormat != null && this.m_suggestedFormat.length() > 0) {
                    this.m_formatList.insertString(0, this.m_suggestedFormat);
                }
                this.removeDuplicateListEntries(this.m_formatList);
                this.removeNonDocbaseFormats(this.m_formatList);
                IDfList retval = null;
                if (this.m_formatList.getCount() != 0) {
                    retval = this.m_formatList;
                }
                iDfList2 = iDfList3 = retval;
            }
            IDfList iDfList4 = iDfList = iDfList2;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(iDfList, joinPoint);
            }
            return iDfList3;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    public String getDefaultSuggestedFileFormat() throws DfException {
        JoinPoint joinPoint = null;
        try {
            String string;
            String string2;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            IDfList formatList = this.getSuggestedFileFormats();
            String retval = null;
            if (formatList != null && formatList.getCount() != 0) {
                retval = formatList.getString(0);
            }
            String string3 = string2 = (string = retval);
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(string2, joinPoint);
            }
            return string;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    protected IDfList getPlatformFormatSuggestions() throws DfException {
        JoinPoint joinPoint = null;
        try {
            DfList dfList;
            DfList dfList2;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            IDfList formatListFromCLSID = this.getFormatNameListFromCLSID();
            IDfList formatListFromFileExtension = this.getFormatNamesFromDocbaseMatchingFileExtension();
            DfList combinedFormatList = new DfList();
            if (formatListFromCLSID != null) {
                combinedFormatList.insertAll(combinedFormatList.getCount(), formatListFromCLSID);
            }
            if (formatListFromFileExtension != null) {
                combinedFormatList.insertAll(combinedFormatList.getCount(), formatListFromFileExtension);
            }
            try {
                this.checkDosOrUnix(combinedFormatList, false);
            }
            catch (IOException e) {
                try {
                    DfLogger.warn((Object)this, "An I/O error occurred while attempting to detect the file format using a FileReader. Will re-attempt using an input stream.", null, (Throwable)e);
                    this.checkDosOrUnix(combinedFormatList, true);
                }
                catch (IOException ioe) {
                    throw new DfException(0, "Failed to open file to figure out its format " + e.getMessage());
                }
            }
            DfList retval = null;
            if (combinedFormatList.getCount() > 0) {
                retval = combinedFormatList;
            }
            DfList dfList3 = dfList2 = (dfList = retval);
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(dfList2, joinPoint);
            }
            return dfList;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void checkDosOrUnix(IDfList iDfList, boolean bl) throws DfException, FileNotFoundException, IOException {
        IDfList iDfList2 = iDfList;
        boolean bl2 = bl;
        JoinPoint joinPoint = null;
        try {
            File f;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this, (Object)iDfList2, (Object)Conversions.booleanObject((boolean)bl2));
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            if (!(f = new File(this.m_filePath)).isDirectory() && f.exists()) {
                void formatList;
                int dosPos = -1;
                int unixPos = -1;
                int size = formatList.getCount();
                for (int i = 0; i < size; ++i) {
                    String format = (String)formatList.get(i);
                    if (format.equals(DOS_TEXT_FORMAT)) {
                        if (dosPos != -1) continue;
                        dosPos = i;
                        continue;
                    }
                    if (!format.equals(UNIX_TEXT_FORMAT) || unixPos != -1) continue;
                    unixPos = i;
                }
                if (dosPos != -1 || unixPos != -1) {
                    void useStream;
                    String format;
                    String string = format = useStream != false ? this.findFormatUsingStreams() : this.findFormatUsingReader();
                    if (format != null) {
                        if (format.equals(DOS_TEXT_FORMAT)) {
                            if (dosPos > 0) {
                                DfFormatRecognizer.swapFormat((IDfList)formatList, 0, dosPos);
                            } else if (dosPos == -1) {
                                format = null;
                            }
                        } else if (format.equals(UNIX_TEXT_FORMAT)) {
                            if (unixPos > 0) {
                                DfFormatRecognizer.swapFormat((IDfList)formatList, 0, unixPos);
                            } else if (unixPos == -1) {
                                format = null;
                            }
                        }
                    }
                    if (format == null) {
                        if (dosPos > 0) {
                            DfFormatRecognizer.swapFormat((IDfList)formatList, 0, dosPos);
                        } else if (dosPos != 0 && unixPos > 0) {
                            DfFormatRecognizer.swapFormat((IDfList)formatList, 0, unixPos);
                        }
                    }
                }
            }
            Object var12_13 = null;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this, (Object)iDfList2, (Object)Conversions.booleanObject((boolean)bl2));
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(var12_13, joinPoint);
            }
            return;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this, (Object)iDfList2, (Object)Conversions.booleanObject((boolean)bl2));
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String findFormatUsingReader() throws IOException {
        JoinPoint joinPoint = null;
        try {
            String string;
            String string2;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            char[] buffer = new char[4096];
            int realLen = 0;
            FileReader istream = null;
            try {
                istream = new FileReader(this.m_filePath);
                realLen = istream.read(buffer, 0, buffer.length);
            }
            finally {
                if (istream != null) {
                    istream.close();
                }
            }
            String format = null;
            for (int i = 0; i < realLen; ++i) {
                if (buffer[i] == '\r' && i + 1 < realLen && buffer[i + 1] == '\n') {
                    format = DOS_TEXT_FORMAT;
                    break;
                }
                if (buffer[i] != '\n') continue;
                format = UNIX_TEXT_FORMAT;
                break;
            }
            String string3 = string2 = (string = format);
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(string2, joinPoint);
            }
            return string;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String findFormatUsingStreams() throws IOException {
        JoinPoint joinPoint = null;
        try {
            String string;
            String string2;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)this, (Object)this);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            byte[] buffer = new byte[4096];
            int realLen = 0;
            BufferedInputStream istream = null;
            try {
                istream = new BufferedInputStream(new FileInputStream(this.m_filePath));
                realLen = istream.read(buffer, 0, buffer.length);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                if (istream != null) {
                    istream.close();
                }
            }
            String format = null;
            for (int i = 0; i < realLen; ++i) {
                if (buffer[i] == 13 && i + 1 < realLen && buffer[i + 1] == 10) {
                    format = DOS_TEXT_FORMAT;
                    break;
                }
                if (buffer[i] != 10) continue;
                format = UNIX_TEXT_FORMAT;
                break;
            }
            String string3 = string2 = (string = format);
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)this, (Object)this);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(string2, joinPoint);
            }
            return string;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)this, (Object)this);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    /*
     * Unable to fully structure code
     */
    private static void checkRemoteDosOrUnix(IDfList var0, IDfRemoteFileMetadata var1_1) throws DfException {
        var8_2 = var0;
        var9_3 = var1_1;
        var7_4 = null;
        try {
            block15: {
                block16: {
                    if (BaseTracingAspect.ajc$if_0()) {
                        v0 = TracingAspect.aspectOf();
                        if (var7_4 == null) {
                            var7_4 = Factory.makeJP((JoinPoint.StaticPart)DfFormatRecognizer.ajc$tjp_8, null, null, (Object)var8_2, (Object)var9_3);
                        }
                        v0.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(var7_4);
                    }
                    dosPos = -1;
                    unixPos = -1;
                    size = formatList.getCount();
                    for (i = 0; i < size; ++i) {
                        format = (String)formatList.get(i);
                        if (format.equals("crtext")) {
                            if (dosPos != -1) continue;
                            dosPos = i;
                            continue;
                        }
                        if (!format.equals("text") || unixPos != -1) continue;
                        unixPos = i;
                    }
                    if (dosPos == -1 && unixPos == -1) break block15;
                    if (!metaData.isUnixFormat()) break block16;
                    if (unixPos <= 0) ** GOTO lbl-1000
                    DfFormatRecognizer.swapFormat(formatList, 0, unixPos);
                    break block15;
                }
                if (dosPos > 0) {
                    DfFormatRecognizer.swapFormat(formatList, 0, dosPos);
                } else if (dosPos > 0) {
                    DfFormatRecognizer.swapFormat(formatList, 0, dosPos);
                } else if (dosPos != 0 && unixPos > 0) {
                    DfFormatRecognizer.swapFormat(formatList, 0, unixPos);
                }
            }
            var10_10 = null;
            if (BaseTracingAspect.ajc$if_0()) {
                v1 = TracingAspect.aspectOf();
                if (var7_4 == null) {
                    var7_4 = Factory.makeJP((JoinPoint.StaticPart)DfFormatRecognizer.ajc$tjp_8, null, null, (Object)var8_2, (Object)var9_3);
                }
                v1.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(var10_10, var7_4);
            }
            return;
        }
        catch (Throwable var11_11) {
            if (BaseTracingAspect.ajc$if_0()) {
                v2 = TracingAspect.aspectOf();
                if (var7_4 == null) {
                    var7_4 = Factory.makeJP((JoinPoint.StaticPart)DfFormatRecognizer.ajc$tjp_8, null, null, (Object)var8_2, (Object)var9_3);
                }
                v2.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(var11_11, var7_4);
            }
            throw var11_11;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void swapFormat(IDfList iDfList, int n, int n2) throws DfException {
        IDfList iDfList2 = iDfList;
        int n3 = n;
        int n4 = n2;
        JoinPoint joinPoint = null;
        try {
            void pos2;
            void pos1;
            IDfList formatList;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    Object[] objectArray = new Object[]{iDfList2, Conversions.intObject((int)n3), Conversions.intObject((int)n4)};
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_9, null, null, (Object[])objectArray);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            Object obj1 = formatList.get((int)pos1);
            formatList.set((int)pos1, formatList.get((int)pos2));
            formatList.set((int)pos2, obj1);
            Object var10_9 = null;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    Object[] objectArray = new Object[]{iDfList2, Conversions.intObject((int)n3), Conversions.intObject((int)n4)};
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_9, null, null, (Object[])objectArray);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(var10_9, joinPoint);
            }
            return;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    Object[] objectArray = new Object[]{iDfList2, Conversions.intObject((int)n3), Conversions.intObject((int)n4)};
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_9, null, null, (Object[])objectArray);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    protected IDfList getFormatNameListFromCLSID() throws DfException {
        JoinPoint joinPoint = null;
        try {
            IDfList iDfList;
            IDfList iDfList2;
            IDfList iDfList3;
            String clsid;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_10, (Object)this, (Object)this);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            if ((clsid = this.getCLSIDForFile()) == null || clsid.length() == 0) {
                iDfList2 = iDfList3 = null;
            } else {
                String formatName = this.getFormatNameFromPopularCLSIDs(clsid);
                if (formatName != null) {
                    DfList formatList = new DfList();
                    formatList.append(formatName);
                    iDfList2 = iDfList3 = formatList;
                } else {
                    iDfList2 = iDfList3 = this.getFormatNamesFromDocbaseMatchingCLSID(clsid);
                }
            }
            IDfList iDfList4 = iDfList = iDfList2;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_10, (Object)this, (Object)this);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(iDfList, joinPoint);
            }
            return iDfList3;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_10, (Object)this, (Object)this);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    protected IDfList getFormatNamesFromDocbaseMatchingCLSID(String string) throws DfException {
        String string2 = string;
        JoinPoint joinPoint = null;
        try {
            DfList dfList;
            DfList dfList2;
            void clsid;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_11, (Object)this, (Object)this, (Object)string2);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            DfList formatList = new DfList();
            DfQuery query = new DfQuery();
            StringBuffer dql = new StringBuffer();
            dql.append("select name,is_hidden from dm_format where UPPER(com_class_id) = '");
            dql.append((String)clsid);
            dql.append("'");
            query.setDQL(dql.toString());
            IDfCollection coll = query.execute(this.m_session, 0);
            try {
                while (coll.next()) {
                    String formatName = coll.getString("name");
                    if (this.m_includeHiddenFormats) {
                        formatList.append(formatName);
                        continue;
                    }
                    if (coll.getBoolean("is_hidden")) continue;
                    formatList.append(formatName);
                }
            }
            finally {
                coll.close();
            }
            DfList retval = null;
            if (formatList.getCount() > 0) {
                retval = formatList;
            }
            DfList dfList3 = dfList2 = (dfList = retval);
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_11, (Object)this, (Object)this, (Object)string2);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(dfList2, joinPoint);
            }
            return dfList;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_11, (Object)this, (Object)this, (Object)string2);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    String getCLSIDForFile() {
        JoinPoint joinPoint = null;
        try {
            String string;
            String string2;
            String string3;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_12, (Object)this, (Object)this);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            if (this.m_clsid != null) {
                string2 = string3 = this.m_clsid;
            } else {
                try {
                    IDfVDMPlatformUtils platformUtils = this.getPlatformUtils();
                    if (platformUtils != null) {
                        this.m_clsid = platformUtils.getCLSIDForFile(this.m_filePath);
                    }
                }
                catch (Exception e) {
                    this.m_clsid = null;
                }
                catch (Error e) {
                    this.m_clsid = null;
                }
                string2 = string3 = this.m_clsid;
            }
            String string4 = string = string2;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_12, (Object)this, (Object)this);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(string, joinPoint);
            }
            return string3;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_12, (Object)this, (Object)this);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    protected String getFormatNameFromPopularCLSIDs(String string) {
        String string2 = string;
        JoinPoint joinPoint = null;
        try {
            String string3;
            String string4;
            String ext;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_13, (Object)this, (Object)this, (Object)string2);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            if ((ext = this.m_fileExtension) == null) {
                ext = DfConstants.EMPTY_STRING;
            }
            String formatName = null;
            for (int oneTimeThrough = 0; oneTimeThrough == 0; ++oneTimeThrough) {
                void clsid;
                if (clsid.equalsIgnoreCase(CLSID_WORD6) || clsid.equalsIgnoreCase(CLSID_WORD7)) {
                    formatName = "msw6";
                    break;
                }
                if (clsid.equalsIgnoreCase(CLSID_WORD8)) {
                    if (ext.equalsIgnoreCase("dot")) {
                        formatName = "msw8template";
                        break;
                    }
                    formatName = "msw8";
                    break;
                }
                if (clsid.equalsIgnoreCase(CLSID_EXCEL5BOOK)) {
                    formatName = "excel5book";
                    break;
                }
                if (clsid.equalsIgnoreCase(CLSID_EXCEL8BOOK)) {
                    if (ext.equalsIgnoreCase("xlt")) {
                        formatName = "excel8template";
                        break;
                    }
                    formatName = "excel8book";
                    break;
                }
                if (clsid.equalsIgnoreCase(CLSID_POWERPOINTSHOW7) || clsid.equalsIgnoreCase(CLSID_POWERPOINTSLIDE7)) {
                    formatName = "powerpoint";
                    break;
                }
                if (clsid.equalsIgnoreCase(CLSID_POWERPOINTSHOW8)) {
                    formatName = "ppt8";
                    break;
                }
                if (clsid.equalsIgnoreCase(CLSID_POWERPOINTSHOW8_TEMPLATE)) {
                    formatName = "ppt8_template";
                    break;
                }
                if (clsid.equalsIgnoreCase(CLSID_ACCESS7)) {
                    formatName = "ms_access7";
                    break;
                }
                if (!clsid.equalsIgnoreCase(CLSID_ACCESS8)) continue;
                if (ext.equalsIgnoreCase("mde")) {
                    formatName = "ms_access8_mde";
                    break;
                }
                formatName = "ms_access8";
                break;
            }
            String string5 = string4 = (string3 = formatName);
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_13, (Object)this, (Object)this, (Object)string2);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(string4, joinPoint);
            }
            return string3;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_13, (Object)this, (Object)this, (Object)string2);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    protected static String getFormatNameFromPopularCLSIDs(String string, String string2) {
        String string3 = string;
        String string4 = string2;
        JoinPoint joinPoint = null;
        try {
            String string5;
            String string6;
            void extension;
            String ext;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_14, null, null, (Object)string3, (Object)string4);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            if ((ext = extension) == null) {
                ext = DfConstants.EMPTY_STRING;
            }
            String formatName = null;
            for (int oneTimeThrough = 0; oneTimeThrough == 0; ++oneTimeThrough) {
                String clsid;
                if (clsid.equalsIgnoreCase(CLSID_WORD6) || clsid.equalsIgnoreCase(CLSID_WORD7)) {
                    formatName = "msw6";
                    break;
                }
                if (clsid.equalsIgnoreCase(CLSID_WORD8)) {
                    if (ext.equalsIgnoreCase("dot")) {
                        formatName = "msw8template";
                        break;
                    }
                    formatName = "msw8";
                    break;
                }
                if (clsid.equalsIgnoreCase(CLSID_EXCEL5BOOK)) {
                    formatName = "excel5book";
                    break;
                }
                if (clsid.equalsIgnoreCase(CLSID_EXCEL8BOOK)) {
                    if (ext.equalsIgnoreCase("xlt")) {
                        formatName = "excel8template";
                        break;
                    }
                    formatName = "excel8book";
                    break;
                }
                if (clsid.equalsIgnoreCase(CLSID_POWERPOINTSHOW7) || clsid.equalsIgnoreCase(CLSID_POWERPOINTSLIDE7)) {
                    formatName = "powerpoint";
                    break;
                }
                if (clsid.equalsIgnoreCase(CLSID_POWERPOINTSHOW8)) {
                    formatName = "ppt8";
                    break;
                }
                if (clsid.equalsIgnoreCase(CLSID_POWERPOINTSHOW8_TEMPLATE)) {
                    formatName = "ppt8_template";
                    break;
                }
                if (clsid.equalsIgnoreCase(CLSID_ACCESS7)) {
                    formatName = "ms_access7";
                    break;
                }
                if (!clsid.equalsIgnoreCase(CLSID_ACCESS8)) continue;
                if (ext.equalsIgnoreCase("mde")) {
                    formatName = "ms_access8_mde";
                    break;
                }
                formatName = "ms_access8";
                break;
            }
            String string7 = string6 = (string5 = formatName);
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_14, null, null, (Object)string3, (Object)string4);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(string6, joinPoint);
            }
            return string5;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_14, null, null, (Object)string3, (Object)string4);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    protected IDfList getFormatNamesFromDocbaseMatchingFileExtension() throws DfException {
        JoinPoint joinPoint = null;
        try {
            IDfList iDfList;
            IDfList iDfList2;
            IDfList iDfList3;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_15, (Object)this, (Object)this);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            if (this.m_fileExtension == null || this.m_fileExtension.length() == 0) {
                DfLogger.debug((Object)this, "File has no extension.", null, null);
                iDfList2 = iDfList3 = null;
            } else {
                IDfList retval = DfOpUtils.queryFormatNamesByExtension(this.m_fileExtension, this.m_session, this.m_includeHiddenFormats);
                if (retval == null && (this.m_fileExtension.equalsIgnoreCase("ini") || this.m_fileExtension.equalsIgnoreCase("bat") || this.m_fileExtension.equalsIgnoreCase("log"))) {
                    retval = DfOpUtils.queryFormatNamesByExtension("txt", this.m_session, this.m_includeHiddenFormats);
                }
                iDfList2 = iDfList3 = retval;
            }
            IDfList iDfList4 = iDfList = iDfList2;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_15, (Object)this, (Object)this);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(iDfList, joinPoint);
            }
            return iDfList3;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_15, (Object)this, (Object)this);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static IDfList getFormatByExtension(String string, IDfSession iDfSession, boolean bl) throws DfException {
        String string2 = string;
        IDfSession iDfSession2 = iDfSession;
        boolean bl2 = bl;
        JoinPoint joinPoint = null;
        try {
            IDfList iDfList;
            IDfList iDfList2;
            IDfList iDfList3;
            String extension;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    Object[] objectArray = new Object[]{string2, iDfSession2, Conversions.booleanObject((boolean)bl2)};
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_16, null, null, (Object[])objectArray);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            if (extension == null || extension.length() == 0) {
                DfLogger.debug(DfFormatRecognizer.class, "File has no extension.", null, null);
                iDfList2 = iDfList3 = null;
            } else {
                void isInclHidden;
                void session;
                IDfList retval = DfOpUtils.queryFormatNamesByExtension(extension, (IDfSession)session, (boolean)isInclHidden);
                if (retval == null && (extension.equalsIgnoreCase("ini") || extension.equalsIgnoreCase("bat") || extension.equalsIgnoreCase("log"))) {
                    retval = DfOpUtils.queryFormatNamesByExtension("txt", (IDfSession)session, (boolean)isInclHidden);
                }
                iDfList2 = iDfList3 = retval;
            }
            IDfList iDfList4 = iDfList = iDfList2;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    Object[] objectArray = new Object[]{string2, iDfSession2, Conversions.booleanObject((boolean)bl2)};
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_16, null, null, (Object[])objectArray);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(iDfList, joinPoint);
            }
            return iDfList3;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    Object[] objectArray = new Object[]{string2, iDfSession2, Conversions.booleanObject((boolean)bl2)};
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_16, null, null, (Object[])objectArray);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static String getDefaultFormat(IDfList iDfList, IDfRemoteFileMetadata iDfRemoteFileMetadata, String string) throws DfException {
        IDfList iDfList2 = iDfList;
        IDfRemoteFileMetadata iDfRemoteFileMetadata2 = iDfRemoteFileMetadata;
        String string2 = string;
        JoinPoint joinPoint = null;
        try {
            String string3;
            String string4;
            IDfList formatsByExtension;
            void metaData;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    Object[] objectArray = new Object[]{iDfList2, iDfRemoteFileMetadata2, string2};
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_17, null, null, (Object[])objectArray);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            String clsid = metaData.getClsid();
            DfList fromClsid = null;
            if (clsid != null && clsid.length() > 0) {
                void fileExtension;
                String formatName = DfFormatRecognizer.getFormatNameFromPopularCLSIDs(clsid, (String)fileExtension);
                fromClsid = new DfList();
                fromClsid.append(formatName);
            }
            DfList combinedFormatList = new DfList();
            if (fromClsid != null) {
                combinedFormatList.insertAll(combinedFormatList.getCount(), fromClsid);
            }
            if (formatsByExtension != null) {
                combinedFormatList.insertAll(combinedFormatList.getCount(), formatsByExtension);
            }
            DfFormatRecognizer.checkRemoteDosOrUnix(combinedFormatList, (IDfRemoteFileMetadata)metaData);
            String string5 = string4 = combinedFormatList.getCount() > 0 ? (string3 = combinedFormatList.getString(0)) : (string3 = null);
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    Object[] objectArray = new Object[]{iDfList2, iDfRemoteFileMetadata2, string2};
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_17, null, null, (Object[])objectArray);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(string4, joinPoint);
            }
            return string3;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    Object[] objectArray = new Object[]{iDfList2, iDfRemoteFileMetadata2, string2};
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_17, null, null, (Object[])objectArray);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IDfVDMPlatformUtils getPlatformUtils() {
        JoinPoint joinPoint = null;
        try {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_18, (Object)this, (Object)this);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            Class<DfFormatRecognizer> clazz = DfFormatRecognizer.class;
            synchronized (DfFormatRecognizer.class) {
                IDfVDMPlatformUtils iDfVDMPlatformUtils;
                IDfVDMPlatformUtils iDfVDMPlatformUtils2;
                IDfVDMPlatformUtils iDfVDMPlatformUtils3;
                block16: {
                    block15: {
                        if (m_platformUtilsCreatorThread == null) {
                            m_platformUtilsCreatorThread = Thread.currentThread();
                        }
                        if (m_platformUtils == null || m_platformUtilsCreatorThread != Thread.currentThread()) break block15;
                        // ** MonitorExit[var1_2] (shouldn't be in output)
                        iDfVDMPlatformUtils2 = iDfVDMPlatformUtils3 = m_platformUtils;
                        break block16;
                    }
                    try {
                        m_platformUtils = DfOpUtils.getPlatformUtils();
                        m_platformUtilsCreatorThread = Thread.currentThread();
                    }
                    catch (Throwable e) {
                        m_platformUtils = null;
                        m_platformUtilsCreatorThread = null;
                    }
                    iDfVDMPlatformUtils2 = iDfVDMPlatformUtils3 = m_platformUtils;
                }
                IDfVDMPlatformUtils iDfVDMPlatformUtils4 = iDfVDMPlatformUtils = iDfVDMPlatformUtils2;
                if (BaseTracingAspect.ajc$if_0()) {
                    TracingAspect tracingAspect = TracingAspect.aspectOf();
                    if (joinPoint == null) {
                        joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_18, (Object)this, (Object)this);
                    }
                    tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(iDfVDMPlatformUtils, joinPoint);
                }
                return iDfVDMPlatformUtils3;
            }
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_18, (Object)this, (Object)this);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void removeDuplicateListEntries(IDfList iDfList) throws DfException {
        IDfList iDfList2 = iDfList;
        JoinPoint joinPoint = null;
        try {
            void list;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_19, (Object)this, (Object)this, (Object)iDfList2);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            DfList uniqueList = new DfList();
            int duplicateListItemCount = list.getCount();
            for (int i = 0; i < duplicateListItemCount; ++i) {
                String formatName = list.getString(i);
                if (uniqueList.findStringIndex(formatName) != -1) continue;
                uniqueList.appendString(formatName);
            }
            list.removeAll();
            list.insertAll(0, uniqueList);
            Object var8_8 = null;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_19, (Object)this, (Object)this, (Object)iDfList2);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(var8_8, joinPoint);
            }
            return;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_19, (Object)this, (Object)this, (Object)iDfList2);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void removeNonDocbaseFormats(IDfList iDfList) throws DfException {
        IDfList iDfList2 = iDfList;
        JoinPoint joinPoint = null;
        try {
            void list;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_20, (Object)this, (Object)this, (Object)iDfList2);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            DfList validatedList = new DfList();
            int listCount = list.getCount();
            for (int i = 0; i < listCount; ++i) {
                String formatName = list.getString(i);
                try {
                    IDfFormat formatObject = this.m_session.getFormat(formatName);
                    if (formatObject == null || !this.m_includeHiddenFormats && formatObject.isHidden()) continue;
                    validatedList.appendString(formatName);
                    continue;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            list.removeAll();
            list.insertAll(0, validatedList);
            Object var9_10 = null;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_20, (Object)this, (Object)this, (Object)iDfList2);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(var9_10, joinPoint);
            }
            return;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_20, (Object)this, (Object)this, (Object)iDfList2);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    protected String getClassName() {
        JoinPoint joinPoint = null;
        try {
            String string;
            String string2;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_21, (Object)this, (Object)this);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            String string3 = string2 = (string = "DfFormatRecognizer@" + Integer.toHexString(this.hashCode()));
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_21, (Object)this, (Object)this);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(string2, joinPoint);
            }
            return string;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_21, (Object)this, (Object)this);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    static {
        Factory factory = new Factory("DfFormatRecognizer.java", Class.forName("com.documentum.operations.DfFormatRecognizer"));
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "init", "com.documentum.operations.DfFormatRecognizer", "com.documentum.fc.client.IDfSession:java.lang.String:java.lang.String:boolean:", "session:filePath:suggestedFormat:includeHiddenFormats:", "com.documentum.fc.common.DfException:", "void"), 88);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "init", "com.documentum.operations.DfFormatRecognizer", "com.documentum.fc.client.IDfSession:java.lang.String:java.lang.String:", "session:filePath:suggestedFormat:", "com.documentum.fc.common.DfException:", "void"), 108);
        ajc$tjp_10 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "getFormatNameListFromCLSID", "com.documentum.operations.DfFormatRecognizer", "", "", "com.documentum.fc.common.DfException:", "com.documentum.fc.common.IDfList"), 495);
        ajc$tjp_11 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "getFormatNamesFromDocbaseMatchingCLSID", "com.documentum.operations.DfFormatRecognizer", "java.lang.String:", "clsid:", "com.documentum.fc.common.DfException:", "com.documentum.fc.common.IDfList"), 541);
        ajc$tjp_12 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("0", "getCLSIDForFile", "com.documentum.operations.DfFormatRecognizer", "", "", "", "java.lang.String"), 600);
        ajc$tjp_13 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "getFormatNameFromPopularCLSIDs", "com.documentum.operations.DfFormatRecognizer", "java.lang.String:", "clsid:", "", "java.lang.String"), 641);
        ajc$tjp_14 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("c", "getFormatNameFromPopularCLSIDs", "com.documentum.operations.DfFormatRecognizer", "java.lang.String:java.lang.String:", "clsid:extension:", "", "java.lang.String"), 751);
        ajc$tjp_15 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "getFormatNamesFromDocbaseMatchingFileExtension", "com.documentum.operations.DfFormatRecognizer", "", "", "com.documentum.fc.common.DfException:", "com.documentum.fc.common.IDfList"), 869);
        ajc$tjp_16 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "getFormatByExtension", "com.documentum.operations.DfFormatRecognizer", "java.lang.String:com.documentum.fc.client.IDfSession:boolean:", "extension:session:isInclHidden:", "com.documentum.fc.common.DfException:", "com.documentum.fc.common.IDfList"), 902);
        ajc$tjp_17 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "getDefaultFormat", "com.documentum.operations.DfFormatRecognizer", "com.documentum.fc.common.IDfList:com.documentum.operations.IDfRemoteFileMetadata:java.lang.String:", "formatsByExtension:metaData:fileExtension:", "com.documentum.fc.common.DfException:", "java.lang.String"), 933);
        ajc$tjp_18 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "getPlatformUtils", "com.documentum.operations.DfFormatRecognizer", "", "", "", "com.documentum.operations.IDfVDMPlatformUtils"), 976);
        ajc$tjp_19 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "removeDuplicateListEntries", "com.documentum.operations.DfFormatRecognizer", "com.documentum.fc.common.IDfList:", "list:", "com.documentum.fc.common.DfException:", "void"), 1059);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getSuggestedFileFormats", "com.documentum.operations.DfFormatRecognizer", "", "", "com.documentum.fc.common.DfException:", "com.documentum.fc.common.IDfList"), 144);
        ajc$tjp_20 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "removeNonDocbaseFormats", "com.documentum.operations.DfFormatRecognizer", "com.documentum.fc.common.IDfList:", "list:", "com.documentum.fc.common.DfException:", "void"), 1100);
        ajc$tjp_21 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "getClassName", "com.documentum.operations.DfFormatRecognizer", "", "", "", "java.lang.String"), 1153);
        ajc$tjp_22 = factory.makeSJP("initialization", (Signature)factory.makeConstructorSig("1", "com.documentum.operations.DfFormatRecognizer", "", "", ""), 1165);
        ajc$tjp_23 = factory.makeSJP("initialization", (Signature)factory.makeConstructorSig("1", "com.documentum.operations.DfFormatRecognizer", "com.documentum.fc.client.IDfSession:java.lang.String:java.lang.String:", "session:filePath:suggestedFormat:", "com.documentum.fc.common.DfException:"), 1165);
        ajc$tjp_24 = factory.makeSJP("initialization", (Signature)factory.makeConstructorSig("1", "com.documentum.operations.DfFormatRecognizer", "com.documentum.fc.client.IDfSession:java.lang.String:java.lang.String:boolean:", "session:filePath:suggestedFormat:includeHiddenFormats:", "com.documentum.fc.common.DfException:"), 1165);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getDefaultSuggestedFileFormat", "com.documentum.operations.DfFormatRecognizer", "", "", "com.documentum.fc.common.DfException:", "java.lang.String"), 202);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "getPlatformFormatSuggestions", "com.documentum.operations.DfFormatRecognizer", "", "", "com.documentum.fc.common.DfException:", "com.documentum.fc.common.IDfList"), 227);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "checkDosOrUnix", "com.documentum.operations.DfFormatRecognizer", "com.documentum.fc.common.IDfList:boolean:", "formatList:useStream:", "com.documentum.fc.common.DfException:java.io.FileNotFoundException:java.io.IOException:", "void"), 285);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "findFormatUsingReader", "com.documentum.operations.DfFormatRecognizer", "", "", "java.io.IOException:", "java.lang.String"), 350);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "findFormatUsingStreams", "com.documentum.operations.DfFormatRecognizer", "", "", "java.io.IOException:", "java.lang.String"), 385);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("a", "checkRemoteDosOrUnix", "com.documentum.operations.DfFormatRecognizer", "com.documentum.fc.common.IDfList:com.documentum.operations.IDfRemoteFileMetadata:", "formatList:metaData:", "com.documentum.fc.common.DfException:", "void"), 422);
        ajc$tjp_9 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("a", "swapFormat", "com.documentum.operations.DfFormatRecognizer", "com.documentum.fc.common.IDfList:int:int:", "formatList:pos1:pos2:", "com.documentum.fc.common.DfException:", "void"), 476);
    }
}

