/*
 * Decompiled with CFR 0.152.
 */
package com.documentum.fc.tracing.impl.triggers;

import com.documentum.fc.tracing.impl.MethodContext;
import com.documentum.fc.tracing.impl.Tracer;
import com.documentum.fc.tracing.impl.TracingConfig;
import com.documentum.fc.tracing.impl.Verbosity;
import com.documentum.fc.tracing.impl.triggers.TracingTriggerAdapter;

public final class VerbosityTrigger
extends TracingTriggerAdapter {
    private boolean m_verbose;

    public VerbosityTrigger(TracingConfig config) {
        this.m_verbose = config.isVerbose();
    }

    public boolean isTriggered(Tracer tracer, MethodContext context, boolean isEntrance) {
        Verbosity verbosity;
        if (context.hasTracingAnnotations() && (verbosity = context.getTracingVerbosity()) != null) {
            switch (verbosity) {
                case NEVER: {
                    return false;
                }
                case VERBOSE: {
                    return this.m_verbose && this.isNextTriggered(tracer, context, true, isEntrance);
                }
                case STANDARD: {
                    break;
                }
                default: {
                    throw new RuntimeException("Unhandled case for enum Verbosity");
                }
            }
        }
        return this.isNextTriggered(tracer, context, true, isEntrance);
    }
}

