/*
 * Decompiled with CFR 0.152.
 */
package com.documentum.fc.tracing.impl.triggers;

import com.documentum.fc.common.DfLogger;
import com.documentum.fc.tracing.impl.CallDepthEvent;
import com.documentum.fc.tracing.impl.CallDepthListener;
import com.documentum.fc.tracing.impl.MethodContext;
import com.documentum.fc.tracing.impl.Tracer;
import com.documentum.fc.tracing.impl.triggers.TracingTriggerAdapter;
import java.util.regex.Pattern;

public final class UserNameTrigger
extends TracingTriggerAdapter
implements CallDepthListener {
    private Pattern m_pattern;

    public UserNameTrigger(Tracer tracer, Pattern pattern) {
        DfLogger.debug((Object)this, "Creating UserNameTrigger -- pattern: {0}", new String[]{pattern.pattern()}, null);
        this.m_pattern = pattern;
        tracer.addCallDepthListener(this);
    }

    public boolean isTriggered(Tracer tracer, MethodContext context, boolean isEntrance) {
        boolean retval = false;
        Boolean isTraced = tracer.getThreadTraceContext().isThreadTracingUser();
        if (isTraced != null) {
            retval = this.isNextTriggered(tracer, context, isTraced, isEntrance);
        } else {
            String[] users;
            boolean matches = false;
            for (String user : users = context.getUsers(tracer)) {
                if (!this.m_pattern.matcher(user).matches()) continue;
                matches = true;
                if (users.length == 1) {
                    tracer.getThreadTraceContext().setThreadTracingUser(Boolean.TRUE);
                }
                retval = this.isNextTriggered(tracer, context, true, isEntrance);
            }
            if (!matches && users.length > 0) {
                tracer.getThreadTraceContext().setThreadTracingUser(Boolean.FALSE);
            }
        }
        return retval;
    }

    public void callDepthReached(CallDepthEvent event) {
        if (event.getDepth() == 0) {
            event.getThreadTraceContext().clearThreadUser();
        }
    }
}

