/*
 * Decompiled with CFR 0.152.
 */
package com.documentum.fc.tracing.impl.triggers;

import com.documentum.fc.common.DfLogger;
import com.documentum.fc.tracing.impl.CallDepthEvent;
import com.documentum.fc.tracing.impl.CallDepthListener;
import com.documentum.fc.tracing.impl.MethodContext;
import com.documentum.fc.tracing.impl.Tracer;
import com.documentum.fc.tracing.impl.triggers.TracingTriggerAdapter;
import java.util.Collections;
import java.util.Set;
import java.util.TreeSet;

public final class MaxUsersTrigger
extends TracingTriggerAdapter
implements CallDepthListener {
    private int m_maxUsers;
    private final Set<String> m_setUsers;

    public MaxUsersTrigger(Tracer tracer, int maxUsers) {
        DfLogger.debug((Object)this, "Creating MaxUsersTrigger -- maxUsers: {0}", new Object[]{maxUsers}, null);
        this.m_maxUsers = maxUsers;
        this.m_setUsers = Collections.synchronizedSet(new TreeSet());
        tracer.addCallDepthListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isTriggered(Tracer tracer, MethodContext context, boolean isEntrance) {
        boolean retval = false;
        Boolean isTraced = tracer.getThreadTraceContext().isThreadTracingUser();
        if (isTraced != null) {
            retval = this.isNextTriggered(tracer, context, isTraced, isEntrance);
        } else {
            String tracedUser;
            String[] users = context.getUsers(tracer);
            assert (users != null) : "Assumption that MethodContext.getUsers will not retunr null violated";
            boolean nextTriggered = this.isNextTriggered(tracer, context, true, isEntrance);
            boolean inSet = false;
            for (String u : users) {
                inSet = this.m_setUsers.contains(u);
                if (!inSet) continue;
                tracedUser = u;
                context.setUser(tracedUser);
                tracer.getThreadTraceContext().setThreadUserName(tracedUser);
                break;
            }
            if (inSet) {
                retval = nextTriggered;
                tracer.getThreadTraceContext().setThreadTracingUser(Boolean.TRUE);
            } else if (users.length > 0 && nextTriggered) {
                tracedUser = users[0];
                Set<String> set = this.m_setUsers;
                synchronized (set) {
                    retval = this.m_setUsers.contains(tracedUser);
                    if (!retval && this.m_setUsers.size() < this.m_maxUsers) {
                        retval = true;
                        this.m_setUsers.add(tracedUser);
                    }
                }
                tracer.getThreadTraceContext().setThreadTracingUser(retval);
            }
        }
        return retval;
    }

    public void resetThis() {
        this.m_setUsers.clear();
    }

    public void callDepthReached(CallDepthEvent event) {
        if (event.getDepth() == 0) {
            event.getThreadTraceContext().clearThreadUser();
        }
    }
}

