/*
 * Decompiled with CFR 0.152.
 */
package com.documentum.fc.tracing.impl;

import com.documentum.fc.common.DfCriticalException;
import com.documentum.fc.tracing.IUserTracingInfo;

public class UserTracingInfo
implements IUserTracingInfo,
Cloneable {
    private String m_user;
    private String m_sessionId;
    private int m_sessionMgrIdHash;
    private int m_rpcCount;
    private boolean m_needsUpdate;

    public UserTracingInfo(String user, String sessionId, int smIdHash, int rpcCount) {
        this.m_user = user;
        this.m_sessionId = sessionId;
        this.m_sessionMgrIdHash = smIdHash;
        this.m_rpcCount = rpcCount;
        this.setNeedsUpdate();
    }

    public String getUser() {
        return this.m_user;
    }

    public String getSessionId() {
        return this.m_sessionId;
    }

    public int getSessionManagerIdHash() {
        return this.m_sessionMgrIdHash;
    }

    public int getRpcCount() {
        return this.m_rpcCount;
    }

    public void setRpcCount(int rpcCount) {
        this.m_rpcCount = Math.max(this.m_rpcCount, rpcCount);
    }

    public void update(IUserTracingInfo info) {
        if (this.m_needsUpdate && info != null) {
            if (this.m_user == null) {
                this.m_user = info.getUser();
            }
            if (this.m_sessionId == null) {
                this.m_sessionId = info.getSessionId();
            }
            if (this.m_sessionMgrIdHash <= 0) {
                this.m_sessionMgrIdHash = info.getSessionManagerIdHash();
            }
            this.setNeedsUpdate();
        }
    }

    public IUserTracingInfo clone() {
        try {
            return (IUserTracingInfo)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new DfCriticalException("Should never happen because clone is supported", e);
        }
    }

    private void setNeedsUpdate() {
        this.m_needsUpdate = this.m_user == null || this.m_sessionId == null || this.m_sessionMgrIdHash <= 0;
    }
}

