/*
 * Decompiled with CFR 0.152.
 */
package com.documentum.fc.tracing.impl;

import com.documentum.fc.client.IDfTypedObject;
import com.documentum.fc.client.impl.session.ISession;
import com.documentum.fc.common.DfLogger;
import com.documentum.fc.common.DfUnsupportedOperationException;
import com.documentum.fc.tracing.IUserIdentifyingObject;
import com.documentum.fc.tracing.IUserTracingInfo;

public class UserIdWrapper {
    private static IUserIdentifyingObject NULL_WRAPPER = new IUserIdentifyingObject(){

        public String[] getUsersForTracing() {
            return new String[0];
        }

        public IUserTracingInfo getUserTracingInfo(String user) {
            return null;
        }
    };

    public static IUserIdentifyingObject createWrapper(IDfTypedObject tobj) {
        if (tobj == null) {
            return NULL_WRAPPER;
        }
        return new TypedObjectWrapper(tobj);
    }

    static class TypedObjectWrapper
    implements IUserIdentifyingObject {
        private IDfTypedObject m_typedObject;

        public TypedObjectWrapper(IDfTypedObject tobj) {
            this.m_typedObject = tobj;
        }

        public String[] getUsersForTracing() {
            String[] retval = null;
            if (this.getSession() != null) {
                retval = this.getSession().getUsersForTracing();
            }
            return retval;
        }

        public IUserTracingInfo getUserTracingInfo(String user) {
            IUserTracingInfo retval = null;
            if (this.getSession() != null) {
                retval = this.getSession().getUserTracingInfo(user);
            }
            return retval;
        }

        private ISession getSession() {
            ISession retval;
            try {
                retval = (ISession)this.m_typedObject.getSession();
            }
            catch (ClassCastException cce) {
                DfLogger.warn((Object)this, "Unable to cast IDfTypedObject's session to ISession", null, null);
                retval = null;
            }
            catch (IllegalStateException ise) {
                retval = null;
            }
            catch (DfUnsupportedOperationException uoe) {
                retval = null;
            }
            return retval;
        }
    }
}

