/*
 * Decompiled with CFR 0.152.
 */
package com.documentum.fc.tracing.impl;

import com.documentum.fc.common.DfException;
import com.documentum.fc.common.DfLogger;
import com.documentum.fc.common.impl.preferences.TypedPreferences;
import com.documentum.fc.tracing.impl.FileCreationMode;
import com.documentum.fc.tracing.impl.LoggerConfig;
import com.documentum.fc.tracing.impl.TimingStyle;
import com.documentum.fc.tracing.impl.TracingMode;
import java.io.Serializable;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.log4j.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TracingConfig
implements Serializable,
Cloneable {
    public static final int UNLIMITED = -1;
    private static final String DFC_TRACING_ENABLE = "dfc.tracing.enable";
    private static final String DFC_TRACING_MODE = "dfc.tracing.mode";
    private static final String DFC_TRACING_VERBOSE = "dfc.tracing.verbose";
    private static final String DFC_TRACING_INCLUDE_RPCS = "dfc.tracing.include_rpcs";
    private static final String DFC_TRACING_FILE_CREATION_MODE = "dfc.tracing.file_creation_mode";
    private static final String DFC_TRACING_TIMING_STYLE = "dfc.tracing.timing_style";
    private static final String DFC_TRACING_MAX_STACK_DEPTH = "dfc.tracing.max_stack_depth";
    private static final String DFC_TRACING_THREAD_NAME_FILTER = "dfc.tracing.thread_name_filter";
    private static final String DFC_TRACING_USER_NAME_FILTER = "dfc.tracing.user_name_filter";
    private static final String DFC_TRACING_METHOD_NAME_FILTER = "dfc.tracing.method_name_filter";
    private static final String DFC_TRACING_PRINT_STACK_ON_METHOD_MATCH = "dfc.tracing.print_stack_on_method_match";
    private static final String DFC_TRACING_INCLUDE_RPC_COUNT = "dfc.tracing.include_rpc_count";
    private static final String DFC_TRACING_INCLUDE_SESSION_ID = "dfc.tracing.include_session_id";
    private static final String DFC_TRACING_PRINT_EXCEPTION_STACK = "dfc.tracing.print_exception_stack";
    private static final String DFC_TRACING_FILE_PREFIX = "dfc.tracing.file_prefix";
    private static final String DFC_TRACING_FILE_OVERRIDE = "dfc.tracing.file_override";
    private static final String DFC_TRACING_DIR = "dfc.tracing.dir";
    private static final String DFC_TRACING_MAX_FILE_SIZE = "dfc.tracing.max_file_size";
    private static final String DFC_TRACING_MAX_BACKUP_INDEX = "dfc.tracing.max_backup_index";
    private static final String DFC_TRACING_DATE_FORMAT = "dfc.tracing.date_format";
    private static final String DFC_TRACING_DATE_COLUMN_WIDTH = "dfc.tracing.date_column_width";
    private static final String DFC_TRACING_LOG_CATEGORY = "dfc.tracing.log.category";
    private static final String DFC_TRACING_LOG_LEVEL = "dfc.tracing.log.level";
    private static final String DFC_TRACING_LOG_ADDITIVITY = "dfc.tracing.log.additivity";
    private boolean m_enabled = false;
    private boolean m_verbose = false;
    private FileCreationMode m_fileCreationMode = FileCreationMode.STANDARD;
    private TracingMode m_tracingMode = TracingMode.STANDARD;
    private TimingStyle m_timingStyle = TimingStyle.MILLISECONDS;
    private int m_maxStackDepth = -1;
    private String[] m_threadNameFilterExprs = null;
    private Pattern m_threadNameFilterPattern = null;
    private String[] m_userNameFilterExprs = null;
    private Pattern m_userNameFilterPattern = null;
    private String[] m_methodNameFilterExprs = null;
    private boolean m_printStackOnMethodMatch = false;
    private boolean m_includeSessionId = false;
    private boolean m_displayRpcCount = false;
    private boolean m_printExcStack = false;
    private boolean m_includeRpcs = false;
    private String m_traceFilePrefix = "dfctrace";
    private String m_traceFileDirectory = null;
    private String m_maxFileSize = "100MB";
    private int m_maxBackupIndex = 1;
    private SimpleDateFormat m_dateFormat = null;
    private int m_dateColumnWidth = 18;
    private List<LoggerConfig> m_loggerConfigs = new ArrayList<LoggerConfig>();
    private String m_filePathOverride = null;
    static final long serialVersionUID = 2882400002L;

    public TracingConfig clone() {
        TracingConfig retval;
        try {
            retval = (TracingConfig)super.clone();
        }
        catch (CloneNotSupportedException cnse) {
            cnse.printStackTrace();
            throw new RuntimeException(cnse);
        }
        return retval;
    }

    TracingConfig() {
    }

    TracingConfig(TypedPreferences preferences) throws DfException {
        this.m_enabled = preferences.getBoolean(DFC_TRACING_ENABLE);
        this.setTracingMode(preferences.getString(DFC_TRACING_MODE));
        this.m_verbose = preferences.getBoolean(DFC_TRACING_VERBOSE);
        this.setFileCreationMode(preferences.getString(DFC_TRACING_FILE_CREATION_MODE));
        this.setTimingStyle(preferences.getString(DFC_TRACING_TIMING_STYLE));
        this.m_maxStackDepth = this.getPreferenceInt(preferences, DFC_TRACING_MAX_STACK_DEPTH, -1, Integer.MAX_VALUE, this.m_maxStackDepth);
        this.setThreadNameFilterExprs(this.getPreferenceStringArray(preferences, DFC_TRACING_THREAD_NAME_FILTER));
        this.setUserNameFilterExprs(this.getPreferenceStringArray(preferences, DFC_TRACING_USER_NAME_FILTER));
        this.setMethodNameFilterExprs(this.getPreferenceStringArray(preferences, DFC_TRACING_METHOD_NAME_FILTER));
        this.m_printStackOnMethodMatch = preferences.getBoolean(DFC_TRACING_PRINT_STACK_ON_METHOD_MATCH);
        this.m_displayRpcCount = preferences.getBoolean(DFC_TRACING_INCLUDE_RPC_COUNT);
        this.m_includeSessionId = preferences.getBoolean(DFC_TRACING_INCLUDE_SESSION_ID);
        this.m_printExcStack = preferences.getBoolean(DFC_TRACING_PRINT_EXCEPTION_STACK);
        this.m_includeRpcs = preferences.getBoolean(DFC_TRACING_INCLUDE_RPCS);
        this.m_traceFilePrefix = this.getPreferenceString(preferences, DFC_TRACING_FILE_PREFIX, this.m_traceFilePrefix);
        this.m_traceFileDirectory = this.getPreferenceString(preferences, DFC_TRACING_DIR, this.m_traceFileDirectory);
        this.m_maxFileSize = this.getPreferenceString(preferences, DFC_TRACING_MAX_FILE_SIZE, this.m_maxFileSize);
        this.m_maxBackupIndex = this.getPreferenceInt(preferences, DFC_TRACING_MAX_BACKUP_INDEX, 1, Integer.MAX_VALUE, this.m_maxBackupIndex);
        this.setDateFormatPattern(preferences.getString(DFC_TRACING_DATE_FORMAT));
        this.m_dateColumnWidth = this.getPreferenceInt(preferences, DFC_TRACING_DATE_COLUMN_WIDTH, -1, 80, this.m_dateColumnWidth);
        int count = preferences.getValueCount(DFC_TRACING_LOG_CATEGORY);
        for (int i = 0; i < count; ++i) {
            this.m_loggerConfigs.add(new LoggerConfig(preferences.getRepeatingString(DFC_TRACING_LOG_CATEGORY, i), Level.toLevel((String)preferences.getRepeatingString(DFC_TRACING_LOG_LEVEL, i).toUpperCase()), preferences.getRepeatingBoolean(DFC_TRACING_LOG_ADDITIVITY, i)));
        }
        this.m_filePathOverride = preferences.getString(DFC_TRACING_FILE_OVERRIDE);
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof TracingConfig)) {
            return false;
        }
        TracingConfig tc = (TracingConfig)o;
        return this.m_enabled == tc.m_enabled && this.m_verbose == tc.m_verbose && this.m_fileCreationMode.equals((Object)tc.m_fileCreationMode) && this.m_tracingMode.equals((Object)tc.m_tracingMode) && this.m_timingStyle.equals((Object)tc.m_timingStyle) && this.m_maxStackDepth == tc.m_maxStackDepth && this.m_displayRpcCount == tc.m_displayRpcCount && this.m_includeSessionId == tc.m_includeSessionId && this.m_printExcStack == tc.m_printExcStack && this.m_printStackOnMethodMatch == tc.m_printStackOnMethodMatch && ((Object)this.m_loggerConfigs).equals(tc.m_loggerConfigs) && this.m_maxBackupIndex == tc.m_maxBackupIndex && this.m_dateColumnWidth == tc.m_dateColumnWidth && TracingConfig.objectEquals(this.m_maxFileSize, tc.m_maxFileSize) && TracingConfig.objectEquals(this.m_dateFormat, tc.m_dateFormat) && TracingConfig.objectEquals(this.m_traceFilePrefix, tc.m_traceFilePrefix) && TracingConfig.objectEquals(this.m_traceFileDirectory, tc.m_traceFileDirectory) && TracingConfig.objectEquals(this.m_threadNameFilterPattern, tc.m_threadNameFilterPattern) && TracingConfig.objectEquals(this.m_userNameFilterPattern, tc.m_userNameFilterPattern) && Arrays.equals(this.m_methodNameFilterExprs, tc.m_methodNameFilterExprs);
    }

    private static boolean objectEquals(Object o1, Object o2) {
        return o1 == null ? o2 == null : o1.equals(o2);
    }

    public int hashCode() {
        long hash = (this.m_enabled ? 2531 : 3469) + (this.m_displayRpcCount ? 719 : 7487) + (this.m_includeSessionId ? 6607 : 6101) + (this.m_printExcStack ? 1231 : 6323) + (this.m_printStackOnMethodMatch ? 17 : 101) + (this.m_verbose ? 1432 : 1213) + this.m_fileCreationMode.hashCode() + this.m_tracingMode.hashCode() + this.m_timingStyle.hashCode() + ((Object)this.m_loggerConfigs).hashCode() + this.m_maxStackDepth + this.m_maxBackupIndex + this.m_dateColumnWidth + (this.m_maxFileSize == null ? 3457 : 4657) + (this.m_dateFormat == null ? 7321 : 3323) + (this.m_dateFormat == null ? 4909 : 157) + (this.m_traceFilePrefix == null ? 383 : 1889) + (this.m_traceFileDirectory == null ? 1951 : 4007) + (this.m_methodNameFilterExprs == null ? 1783 : 5843) + (this.m_threadNameFilterPattern == null ? 2689 : this.m_threadNameFilterPattern.hashCode()) + (this.m_userNameFilterPattern == null ? 7883 : this.m_userNameFilterPattern.hashCode());
        return (int)(hash & 0xFFFFFFFFL);
    }

    public boolean isEnabled() {
        return this.m_enabled;
    }

    public void setEnabled(boolean enabled) {
        this.m_enabled = enabled;
    }

    public FileCreationMode getFileCreationMode() {
        return this.m_fileCreationMode;
    }

    public void setFileCreationMode(FileCreationMode fileCreationMode) {
        this.m_fileCreationMode = fileCreationMode;
    }

    public int getMaxStackDepth() {
        return this.m_maxStackDepth;
    }

    public void setMaxStackDepth(int maxStackDepth) {
        this.m_maxStackDepth = maxStackDepth;
    }

    public String[] getThreadNameFilterExprs() {
        return this.m_threadNameFilterExprs;
    }

    public void setThreadNameFilterExprs(String[] threadNameFilterExprs) {
        if (threadNameFilterExprs != null && threadNameFilterExprs.length > 0) {
            this.m_threadNameFilterExprs = threadNameFilterExprs;
            this.m_threadNameFilterPattern = TracingConfig.constructSimplePattern(threadNameFilterExprs);
        } else {
            this.m_threadNameFilterExprs = null;
            this.m_threadNameFilterPattern = null;
        }
    }

    public Pattern getThreadNameFilterPattern() {
        return this.m_threadNameFilterPattern;
    }

    public boolean hasMethodFilter() {
        return this.m_methodNameFilterExprs != null;
    }

    public String[] getMethodNameFilterExprs() {
        return this.m_methodNameFilterExprs;
    }

    public void setMethodNameFilterExprs(String[] methodNameFilterExprs) {
        this.m_methodNameFilterExprs = methodNameFilterExprs != null && methodNameFilterExprs.length > 0 ? methodNameFilterExprs : null;
    }

    public boolean getPrintStackOnMethodMatch() {
        return this.m_printStackOnMethodMatch;
    }

    public void setPrintStackOnMethodMatch(boolean printStack) {
        this.m_printStackOnMethodMatch = printStack;
    }

    public String[] getUserNameFilterExprs() {
        return this.m_userNameFilterExprs;
    }

    public void setUserNameFilterExprs(String[] userNameFilterExprs) {
        if (userNameFilterExprs != null && userNameFilterExprs.length > 0) {
            this.m_userNameFilterExprs = userNameFilterExprs;
            this.m_userNameFilterPattern = TracingConfig.constructSimplePattern(userNameFilterExprs);
        } else {
            this.m_userNameFilterExprs = null;
            this.m_userNameFilterPattern = null;
        }
    }

    public Pattern getUserNameFilterPattern() {
        return this.m_userNameFilterPattern;
    }

    public boolean getIncludeSessionId() {
        return this.m_includeSessionId;
    }

    public void setIncludeSessionId(boolean includeSessionId) {
        this.m_includeSessionId = includeSessionId;
    }

    public boolean getDisplayRpcCount() {
        return this.m_displayRpcCount;
    }

    public void setDisplayRpcCount(boolean displayRpcCount) {
        this.m_displayRpcCount = displayRpcCount;
    }

    public TracingMode getTracingMode() {
        return this.m_tracingMode;
    }

    public void setTracingMode(TracingMode tracingMode) {
        this.m_tracingMode = tracingMode;
    }

    public TimingStyle getTimingStyle() {
        return this.m_timingStyle;
    }

    public void setTimingStyle(TimingStyle timingStyle) {
        this.m_timingStyle = timingStyle;
    }

    public boolean isVerbose() {
        return this.m_verbose;
    }

    public boolean getPrintExceptionStack() {
        return this.m_printExcStack;
    }

    public void setPrintExceptionStack(boolean printExceptionStack) {
        this.m_printExcStack = printExceptionStack;
    }

    public String getTraceFilePrefix() {
        return this.m_traceFilePrefix;
    }

    public void setTraceFilePrefix(String traceFilePrefix) {
        this.m_traceFilePrefix = traceFilePrefix;
    }

    public String getTraceFileDirectory() {
        return this.m_traceFileDirectory;
    }

    public void setTraceFileDirectory(String traceFileDirectory) {
        this.m_traceFileDirectory = traceFileDirectory;
    }

    public String getMaxFileSize() {
        return this.m_maxFileSize;
    }

    public void setMaxFileSize(String maxFileSize) {
        this.m_maxFileSize = maxFileSize;
    }

    public int getMaxBackupIndex() {
        return this.m_maxBackupIndex;
    }

    public void setMaxBackupIndex(int maxBackupIndex) {
        this.m_maxBackupIndex = maxBackupIndex;
    }

    public String getDateFormatPattern() {
        return this.m_dateFormat == null ? "" : this.m_dateFormat.toPattern();
    }

    public void setDateFormatPattern(String dateFormatPattern) {
        if (this.normalize(dateFormatPattern) == null) {
            return;
        }
        try {
            this.m_dateFormat = new SimpleDateFormat(dateFormatPattern);
        }
        catch (Exception e) {
            DfLogger.warn((Object)this, "The date format pattern {0} is not a recognized date format string.  The default format will be used.", new String[]{dateFormatPattern}, (Throwable)e);
        }
    }

    public DateFormat getDateFormat() {
        return this.m_dateFormat;
    }

    public int getDateColumnWidth() {
        return this.m_dateColumnWidth;
    }

    public void setDateColumnWidth(int dateColumnWidth) {
        this.m_dateColumnWidth = dateColumnWidth;
    }

    public boolean getIncludeRpcs() {
        return this.m_includeRpcs;
    }

    public List<LoggerConfig> getLoggerConfigs() {
        return this.m_loggerConfigs;
    }

    private static Pattern constructSimplePattern(String[] exprs) {
        String strPattern = null;
        Pattern retval = null;
        if (exprs.length == 1) {
            strPattern = exprs[0];
        } else if (exprs.length > 1) {
            StringBuilder buffer = new StringBuilder(exprs.length << 4);
            String sep = "(";
            for (String expr : exprs) {
                buffer.append(sep).append(expr);
                sep = ")|(";
            }
            buffer.append(")");
            strPattern = buffer.toString();
        }
        if (strPattern != null) {
            try {
                retval = Pattern.compile(strPattern);
            }
            catch (PatternSyntaxException pse) {
                throw new IllegalArgumentException("Bad pattern");
            }
        }
        return retval;
    }

    private void warnBadStringValue(String preferenceName, String givenValue, String defaultValue, Exception e) {
        DfLogger.warn((Object)this, "Bad value for {0}: {1}.  Will use the default value of {2}", new String[]{preferenceName, givenValue, defaultValue}, (Throwable)e);
    }

    private String normalize(String value) {
        return value == null ? null : (value.length() == 0 ? null : value.trim());
    }

    private void setTracingMode(String value) {
        if ((value = this.normalize(value)) != null) {
            try {
                this.m_tracingMode = TracingMode.valueOf(value.toUpperCase());
            }
            catch (Exception e) {
                this.warnBadStringValue(DFC_TRACING_MODE, value, this.m_tracingMode.toString(), e);
            }
        }
    }

    private void setFileCreationMode(String value) {
        if ((value = this.normalize(value)) != null) {
            try {
                this.m_fileCreationMode = FileCreationMode.valueOf(value.toUpperCase());
            }
            catch (Exception e) {
                this.warnBadStringValue(DFC_TRACING_FILE_CREATION_MODE, value, this.m_fileCreationMode.toString(), e);
            }
        }
    }

    private void setTimingStyle(String value) {
        if ((value = this.normalize(value)) != null) {
            try {
                this.m_timingStyle = TimingStyle.valueOf(value.toUpperCase());
            }
            catch (Exception e) {
                this.warnBadStringValue(DFC_TRACING_TIMING_STYLE, value, this.m_timingStyle.toString(), e);
            }
        }
    }

    public String getFilePathOverride() {
        return this.m_filePathOverride;
    }

    private int getPreferenceInt(TypedPreferences preferences, String preferenceName, int minValue, int maxValue, int defaultValue) throws DfException {
        int value = preferences.getInt(preferenceName);
        if (value < minValue || value > maxValue) {
            if (value != 0) {
                this.warnBadStringValue(preferenceName, Integer.toString(value), Integer.toString(defaultValue), null);
            }
            return defaultValue;
        }
        return value;
    }

    private String getPreferenceString(TypedPreferences preferences, String preferenceName, String defaultValue) throws DfException {
        String retval = this.normalize(preferences.getString(preferenceName));
        if (retval == null) {
            retval = defaultValue;
        }
        return retval;
    }

    private String[] getPreferenceStringArray(TypedPreferences preferences, String preferenceName) throws DfException {
        String[] retval;
        int count = preferences.getValueCount(preferenceName);
        if (count > 0) {
            retval = new String[count];
            for (int i = 0; i < count; ++i) {
                retval[i] = preferences.getRepeatingString(preferenceName, i);
            }
        } else {
            retval = null;
        }
        return retval;
    }
}

