/*
 * Decompiled with CFR 0.152.
 */
package com.documentum.fc.tracing.impl;

import com.documentum.fc.common.DfLogger;
import com.documentum.fc.common.DfPreferences;
import com.documentum.fc.impl.util.StringUtil;
import com.documentum.fc.tracing.IUserTracingInfo;
import com.documentum.fc.tracing.impl.CallDepthEvent;
import com.documentum.fc.tracing.impl.CallDepthListener;
import com.documentum.fc.tracing.impl.EnterAndExitTracer;
import com.documentum.fc.tracing.impl.FileCreationMode;
import com.documentum.fc.tracing.impl.LogEventContext;
import com.documentum.fc.tracing.impl.LoggerConfig;
import com.documentum.fc.tracing.impl.MethodContext;
import com.documentum.fc.tracing.impl.MethodTracer;
import com.documentum.fc.tracing.impl.OneLineTracer;
import com.documentum.fc.tracing.impl.RedirectingAppender;
import com.documentum.fc.tracing.impl.RpcContext;
import com.documentum.fc.tracing.impl.ThreadTraceContext;
import com.documentum.fc.tracing.impl.TimingStyle;
import com.documentum.fc.tracing.impl.TraceItemFactory;
import com.documentum.fc.tracing.impl.TracerLayout;
import com.documentum.fc.tracing.impl.Tracing;
import com.documentum.fc.tracing.impl.TracingConfig;
import com.documentum.fc.tracing.impl.TracingMode;
import com.documentum.fc.tracing.impl.appenders.MultiplexingAppender;
import com.documentum.fc.tracing.impl.appenders.PerThreadAppender;
import com.documentum.fc.tracing.impl.appenders.PerUserAppender;
import com.documentum.fc.tracing.impl.triggers.MaxDepthTrigger;
import com.documentum.fc.tracing.impl.triggers.MethodFilterTrigger;
import com.documentum.fc.tracing.impl.triggers.TemporaryDisablerTrigger;
import com.documentum.fc.tracing.impl.triggers.ThreadNameTrigger;
import com.documentum.fc.tracing.impl.triggers.TracingTrigger;
import com.documentum.fc.tracing.impl.triggers.UserNameTrigger;
import com.documentum.fc.tracing.impl.triggers.VerbosityTrigger;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.log4j.Appender;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.log4j.RollingFileAppender;
import org.apache.log4j.spi.LoggingEvent;

public class Tracer {
    private Logger m_logger;
    private Appender m_appender;
    private Appender m_redirectingAppender;
    private List<LoggerConfig> m_savedLoggerConfigs = new ArrayList<LoggerConfig>();
    private TriggerList m_triggers;
    private MethodTracer m_methodTracer;
    private List<CallDepthListener> m_callDepthListeners;
    private boolean m_needCompleteUserInfo;
    private boolean m_includeRpcs;
    private boolean m_isOneLine;
    private boolean m_hasMethodFilters;
    private int m_tracerId;
    private static ThreadTraceContextLocal s_context = new ThreadTraceContextLocal();
    private static int s_tracerId = 0;
    private SimpleDateFormat s_format = new SimpleDateFormat("yyyy/MM/dd-HH:mm:ss.S");
    private boolean m_isDefaultLoggerDefined = false;
    private static final String LOGGER_NAME = "com.documentum.fc.tracing.impl.Logger";
    private static final String APPENDER_NAME = "com.documentum.fc.tracing.impl.Appender";
    private static final String REDIRECTING_APPENDER_NAME = "com.documentum.fc.tracing.impl.RedirectingAppender";
    private static final String EXTERNAL_LOGGER_NAME = "com.documentum.fc.tracing.DFCTrace";
    private static boolean s_isLoggerExternal = true;

    Tracer(TracingConfig config) {
        this.m_tracerId = Tracer.getNextId();
        this.m_callDepthListeners = new LinkedList<CallDepthListener>();
        this.configureTemporaryDisabler();
        this.configureVerbosityFilter(config);
        this.configureDepth(config);
        this.configureThreads(config);
        this.configureUsers(config);
        this.configureMethodFilter(config);
        this.configureLogger(config);
        this.configureMethodTracer(config);
        this.m_needCompleteUserInfo = config.getIncludeSessionId() || config.getDisplayRpcCount();
        this.m_includeRpcs = config.getIncludeRpcs();
        this.m_callDepthListeners = Collections.unmodifiableList(this.m_callDepthListeners);
    }

    public void close() {
        this.unconfigureLogger();
    }

    public Logger getLogger() {
        return this.m_logger;
    }

    public IUserTracingInfo getThreadUserInfo() {
        IUserTracingInfo retval = this.getThreadTraceContext().getThreadUserInfo();
        if (retval == null) {
            return retval;
        }
        if (this.m_isOneLine) {
            retval = retval.clone();
        }
        return retval;
    }

    public void updateThreadRpcCount(int newRpcCount) {
        IUserTracingInfo info = this.getThreadTraceContext().getThreadUserInfo();
        if (info != null) {
            info.setRpcCount(newRpcCount);
        }
    }

    public boolean hasMethodFilters() {
        return this.m_hasMethodFilters;
    }

    void reset() {
        if (this.m_triggers != null) {
            this.m_triggers.reset();
        }
    }

    private void configureTemporaryDisabler() {
        this.getTriggers().add(new TemporaryDisablerTrigger());
    }

    private void configureVerbosityFilter(TracingConfig config) {
        this.getTriggers().add(new VerbosityTrigger(config));
    }

    private void configureThreads(TracingConfig config) {
        Pattern pattern = config.getThreadNameFilterPattern();
        if (pattern != null) {
            this.getTriggers().add(new ThreadNameTrigger(pattern));
        }
    }

    private void configureUsers(TracingConfig config) {
        Pattern pattern = config.getUserNameFilterPattern();
        if (pattern != null) {
            this.getTriggers().add(new UserNameTrigger(this, pattern));
        }
    }

    private void configureDepth(TracingConfig config) {
        int depth = config.getMaxStackDepth();
        if (depth != -1) {
            String[] ep = config.getMethodNameFilterExprs();
            boolean hasEntrancePoints = ep != null && ep.length > 0;
            this.getTriggers().add(new MaxDepthTrigger(this, depth, hasEntrancePoints));
        }
    }

    private void configureMethodFilter(TracingConfig config) {
        if (config.hasMethodFilter()) {
            this.m_hasMethodFilters = true;
            this.getTriggers().add(new MethodFilterTrigger(config.getMethodNameFilterExprs(), config.getPrintStackOnMethodMatch()));
        }
    }

    private void unconfigureLogger() {
        for (LoggerConfig savedLoggerConfig : this.m_savedLoggerConfigs) {
            Logger logger = Logger.getLogger((String)savedLoggerConfig.getName());
            if (logger.isAttached(this.m_appender)) {
                logger.removeAppender(this.m_appender);
            }
            if (logger.isAttached(this.m_redirectingAppender)) {
                logger.removeAppender(this.m_redirectingAppender);
            }
            logger.setLevel(savedLoggerConfig.getLevel());
            logger.setAdditivity(savedLoggerConfig.getAdditivity());
        }
        this.m_savedLoggerConfigs.clear();
        if (this.m_appender != null) {
            this.m_appender.close();
            this.m_appender = null;
        }
        if (this.m_redirectingAppender != null) {
            this.m_redirectingAppender.close();
            this.m_redirectingAppender = null;
        }
    }

    private void configureLogger(TracingConfig config) {
        this.m_logger = LogManager.exists((String)EXTERNAL_LOGGER_NAME);
        if (this.m_logger != null) {
            DfLogger.info((Object)this, "Found logger {0} already configured. Will use it and ignore logger-specific configuration in dfc.properties", new String[]{EXTERNAL_LOGGER_NAME}, null);
        } else {
            this.m_logger = LogManager.exists((String)LOGGER_NAME);
            if (this.m_logger != null && s_isLoggerExternal) {
                if (!this.m_logger.getAdditivity()) {
                    DfLogger.info((Object)this, "Default logger {0} is already configured and addtivity is also false.We will rely on the appender's pattern and format tracing statements", new String[]{LOGGER_NAME}, null);
                    this.m_isDefaultLoggerDefined = true;
                }
            } else {
                DfLogger.debug((Object)this, "No logger is configured for {0}. Tracing will programmatically configure its logger", new String[]{LOGGER_NAME}, null);
                this.m_appender = this.configureAppender(config);
                this.m_appender.setLayout((Layout)this.configureTracerLayout(config));
                this.m_appender.setName(APPENDER_NAME);
                this.m_logger = Logger.getLogger((String)LOGGER_NAME);
                this.m_logger.setAdditivity(false);
                this.m_logger.addAppender(this.m_appender);
                this.m_logger.setLevel(Level.DEBUG);
                s_isLoggerExternal = false;
            }
            this.m_savedLoggerConfigs.clear();
            this.m_savedLoggerConfigs.add(new LoggerConfig(this.m_logger.getName(), this.m_logger.getLevel(), this.m_logger.getAdditivity()));
            this.m_redirectingAppender = new RedirectingAppender();
            this.m_redirectingAppender.setName(REDIRECTING_APPENDER_NAME);
            for (LoggerConfig loggerConfig : config.getLoggerConfigs()) {
                Logger logger = Logger.getLogger((String)loggerConfig.getName());
                this.m_savedLoggerConfigs.add(new LoggerConfig(logger.getName(), logger.getLevel(), logger.getAdditivity()));
                logger.setLevel(loggerConfig.getLevel());
                logger.setAdditivity(loggerConfig.getAdditivity());
                logger.addAppender(this.m_redirectingAppender);
            }
        }
    }

    private TracerLayout configureTracerLayout(TracingConfig config) {
        boolean isOneLine = config.getTracingMode() == TracingMode.COMPACT;
        LinkedList<TracerLayout.Field> listFields = new LinkedList<TracerLayout.Field>();
        if (isOneLine) {
            listFields.add(TracerLayout.Field.TIMESTAMP);
            listFields.add(TracerLayout.Field.DURATION);
        } else if (config.getTimingStyle() == TimingStyle.DATE) {
            listFields.add(TracerLayout.Field.TIMESTAMP_DATE);
        } else {
            listFields.add(TracerLayout.Field.TIMESTAMP);
        }
        if (config.getIncludeSessionId()) {
            listFields.add(TracerLayout.Field.USER_INFO);
        } else {
            listFields.add(TracerLayout.Field.USER);
        }
        listFields.add(TracerLayout.Field.THREAD);
        if (!isOneLine) {
            listFields.add(TracerLayout.Field.ENTER_EXIT);
        }
        if (config.getDisplayRpcCount()) {
            listFields.add(TracerLayout.Field.RPC_COUNT);
        }
        listFields.add(TracerLayout.Field.CALL_DEPTH);
        listFields.add(TracerLayout.Field.CLASS_IDENTIFIER);
        listFields.add(TracerLayout.Field.METHOD);
        listFields.add(TracerLayout.Field.ARGS);
        listFields.add(TracerLayout.Field.RETURN_VALUE);
        listFields.add(TracerLayout.Field.MESSAGE);
        listFields.add(TracerLayout.Field.EXCEPTION);
        return new TracerLayout(listFields.toArray(new TracerLayout.Field[listFields.size()]), this.configureLayoutConfig(config));
    }

    private TracerLayout.Config configureLayoutConfig(TracingConfig config) {
        DateFormat format = config.getDateFormat();
        if (format == null) {
            format = this.s_format;
        }
        TracerLayout.Config retval = new TracerLayout.Config(format);
        retval.setTimestampWidth(config.getTimingStyle());
        if (config.getDateColumnWidth() > 0) {
            retval.setDateWidth(config.getDateColumnWidth());
        }
        if (config.getTracingMode() == TracingMode.COMPACT) {
            retval.setDurationWidth(config.getTimingStyle());
        }
        if (config.getPrintExceptionStack()) {
            retval.setPrintExcStack(true);
        }
        return retval;
    }

    private Appender configureAppender(TracingConfig config) {
        Object retval;
        try {
            if (config.getFileCreationMode() == FileCreationMode.STANDARD || !StringUtil.isEmptyOrNull(config.getFilePathOverride())) {
                retval = this.configureRollingAppender(config);
            } else {
                MultiplexingAppender a = this.createMultiplexingAppender(config);
                a.setBaseFilePath(this.getFilePath(config, true));
                a.setMaxFileSize(config.getMaxFileSize());
                a.setMaxBackupIndex(config.getMaxBackupIndex());
                retval = a;
            }
        }
        catch (IOException ioe) {
            DfLogger.error((Object)this, "Unable to configure log appender for trace. A console appender will be used instead", null, (Throwable)ioe);
            retval = new ConsoleAppender();
        }
        return retval;
    }

    private Appender configureRollingAppender(TracingConfig config) throws IOException {
        String traceFile = this.getFilePath(config, false);
        RollingFileAppender a = new RollingFileAppender();
        a.setFile(traceFile, false, false, 0);
        a.setMaxFileSize(config.getMaxFileSize());
        a.setMaxBackupIndex(config.getMaxBackupIndex());
        a.setEncoding("UTF-8");
        RollingFileAppender retval = a;
        DfLogger.debug((Object)this, "Tracing writing to the log {0}", new String[]{traceFile}, null);
        return retval;
    }

    private MultiplexingAppender createMultiplexingAppender(TracingConfig config) {
        if (config.getFileCreationMode() == FileCreationMode.THREAD) {
            return new PerThreadAppender();
        }
        return new PerUserAppender();
    }

    private void configureMethodTracer(TracingConfig config) {
        TracingMode tracingMode = config.getTracingMode();
        if (tracingMode == TracingMode.STANDARD) {
            this.m_isOneLine = false;
            TraceItemFactory itemFactory = this.createEnterExitItemFactory(config);
            this.m_methodTracer = new EnterAndExitTracer(this, itemFactory);
        } else if (tracingMode == TracingMode.COMPACT) {
            this.m_isOneLine = true;
            TraceItemFactory itemFactory = this.createOneLineItemFactory(config);
            this.m_methodTracer = new OneLineTracer(this, itemFactory);
        } else {
            throw new IllegalArgumentException("Bad tracing style argument");
        }
    }

    private TraceItemFactory createEnterExitItemFactory(TracingConfig config) {
        TraceItemFactory itemFactory;
        switch (config.getTimingStyle()) {
            case NANOSECONDS: {
                itemFactory = TraceItemFactory.TRACEITEMNANOSFACTORY;
                break;
            }
            case MILLISECONDS: {
                itemFactory = TraceItemFactory.TRACEITEMMILLISFACTORY;
                break;
            }
            case MILLISECONDS_FROM_START: {
                itemFactory = TraceItemFactory.TRACEITEMMILLISJVMSTARTFACTORY;
                break;
            }
            case SECONDS: {
                itemFactory = TraceItemFactory.TRACEITEMSECSFACTORY;
                break;
            }
            case DATE: {
                itemFactory = TraceItemFactory.TRACEITEMDATEFACTORY;
                break;
            }
            default: {
                DfLogger.warn((Object)this, "Illegal timing style ({0}) for tracing mode ({1}).  Will use {2} instead.", new String[]{config.getTimingStyle().toString(), TracingMode.STANDARD.toString(), TimingStyle.MILLISECONDS.toString()}, null);
                itemFactory = TraceItemFactory.TRACEITEMMILLISFACTORY;
            }
        }
        if (this.m_logger.getName().equals(EXTERNAL_LOGGER_NAME) || this.m_isDefaultLoggerDefined) {
            itemFactory = new TraceItemFactory.Log4jWrapperFactory(itemFactory, this.configureTracerLayout(config));
        }
        return itemFactory;
    }

    private TraceItemFactory createOneLineItemFactory(TracingConfig config) {
        TraceItemFactory itemFactory;
        switch (config.getTimingStyle()) {
            case SECONDS: {
                itemFactory = TraceItemFactory.TRACEITEMSECSFACTORY;
                break;
            }
            case MILLISECONDS: 
            case MILLISECONDS_FROM_START: {
                itemFactory = TraceItemFactory.TRACEITEMMILLISFACTORY;
                break;
            }
            case NANOSECONDS: {
                itemFactory = TraceItemFactory.TRACEITEMNANOSFACTORY;
                break;
            }
            default: {
                DfLogger.warn((Object)this, "Illegal timing style ({0}) for tracing mode ({1}).  Will use {2} instead.", new String[]{config.getTimingStyle().toString(), TracingMode.COMPACT.toString(), TimingStyle.MILLISECONDS.toString()}, null);
                itemFactory = TraceItemFactory.TRACEITEMMILLISFACTORY;
            }
        }
        if (this.m_logger.getName().equals(EXTERNAL_LOGGER_NAME) || this.m_isDefaultLoggerDefined) {
            itemFactory = new TraceItemFactory.Log4jWrapperFactory(itemFactory, this.configureTracerLayout(config));
        }
        return itemFactory;
    }

    private boolean isTriggered(MethodContext context, boolean isEntrance) {
        if (!Tracing.isEnabled()) {
            return false;
        }
        if (this.m_triggers == null) {
            return true;
        }
        return this.m_triggers.isTriggered(this, context, isEntrance);
    }

    private TriggerList getTriggers() {
        if (this.m_triggers == null) {
            this.m_triggers = new TriggerList();
        }
        return this.m_triggers;
    }

    public ThreadTraceContext getThreadTraceContext() {
        return s_context.get(this);
    }

    public void traceMethodEntrance(MethodContext methodContext) {
        this.disableIfExcluded(methodContext);
        if (this.isTriggered(methodContext, true)) {
            this.m_methodTracer.traceMethodEntrance(this, methodContext);
        }
        this.adjustCallDepth(1);
    }

    public void traceMethodExit(MethodContext methodContext) {
        this.adjustCallDepth(-1);
        if (this.isTriggered(methodContext, false)) {
            this.m_methodTracer.traceMethodExit(this, methodContext);
            this.getThreadTraceContext().postTrace(this);
        }
        this.enableIfExcluded(methodContext);
    }

    public void traceMethodException(MethodContext methodContext) {
        this.adjustCallDepth(-1);
        if (this.isTriggered(methodContext, false)) {
            this.m_methodTracer.traceMethodException(this, methodContext);
            this.getThreadTraceContext().postTrace(this);
        }
        this.enableIfExcluded(methodContext);
    }

    public void traceRpcEntrance(RpcContext rpcContext) {
        this.disableIfExcluded(rpcContext);
        if (this.m_includeRpcs && this.isTriggered(rpcContext, true)) {
            this.m_methodTracer.traceRpcEntrance(this, rpcContext);
        }
        this.adjustCallDepth(1);
        this.adjustRpcDepth(1);
    }

    public void traceRpcExit(RpcContext rpcContext) {
        this.adjustCallDepth(-1);
        this.adjustRpcDepth(-1);
        if (this.m_includeRpcs && this.isTriggered(rpcContext, false)) {
            this.m_methodTracer.traceRpcExit(this, rpcContext);
            this.getThreadTraceContext().postTrace(this);
        }
    }

    public void traceRpcException(RpcContext rpcContext) {
        this.adjustCallDepth(-1);
        this.adjustRpcDepth(-1);
        if (this.m_includeRpcs && this.isTriggered(rpcContext, false)) {
            this.m_methodTracer.traceRpcException(this, rpcContext);
            this.getThreadTraceContext().postTrace(this);
        }
    }

    public void traceLogEvent(LoggingEvent event) {
        LogEventContext eventContext = new LogEventContext(event);
        if (this.isTriggered(eventContext, false)) {
            this.m_methodTracer.traceLogEvent(this, eventContext);
        }
    }

    public int adjustCallDepth(int delta) {
        return ((ThreadTraceContext)s_context.get()).adjustCallDepth(delta);
    }

    public int adjustRpcDepth(int delta) {
        return ((ThreadTraceContext)s_context.get()).adjustRpcDepth(delta);
    }

    public int getCallDepth(boolean fromMark) {
        return s_context.get(this).getCallDepth(fromMark);
    }

    public int getRpcDepth(boolean fromMark) {
        return s_context.get(this).getRpcDepth(fromMark);
    }

    private void disableIfExcluded(MethodContext methodContext) {
        if (methodContext.isExcluded()) {
            this.getThreadTraceContext().disableTracing();
        }
    }

    private void enableIfExcluded(MethodContext methodContext) {
        if (methodContext.isExcluded()) {
            this.getThreadTraceContext().enableTracing();
        }
    }

    public void addCallDepthListener(CallDepthListener l) {
        this.m_callDepthListeners.add(l);
    }

    public int getTracerId() {
        return this.m_tracerId;
    }

    void notifyCallDepthListeners(CallDepthEvent event) {
        for (CallDepthListener l : this.m_callDepthListeners) {
            l.callDepthReached(event);
        }
    }

    void disableTracingOnThread() {
        this.getThreadTraceContext().disableTracing();
    }

    void enableTracingOnThread() {
        this.getThreadTraceContext().enableTracing();
    }

    boolean getCompleteUserInfo() {
        return this.m_needCompleteUserInfo;
    }

    private String getFilePath(TracingConfig config, boolean isBasePath) throws FileNotFoundException {
        if (!StringUtil.isEmptyOrNull(config.getFilePathOverride())) {
            return config.getFilePathOverride();
        }
        StringBuilder b = new StringBuilder(128);
        this.getLogDirectory(config, b);
        this.getTraceFileName(config, b, isBasePath);
        return b.toString();
    }

    private void getLogDirectory(TracingConfig config, StringBuilder b) throws FileNotFoundException {
        String sep = System.getProperty("file.separator");
        String traceDir = config.getTraceFileDirectory();
        if (traceDir == null || traceDir.length() == 0 || !this.checkDir(traceDir)) {
            traceDir = DfPreferences.access().getDataDirectory() + sep + "Logs";
            String msg = traceDir == null || traceDir.length() == 0 ? "No tracing directory was configured.  The tracer will attempt to use: {0}" : "The tracer could not use the configured directory.  It will attempt to use: {0}";
            DfLogger.warn((Object)this, msg, new String[]{traceDir}, null);
            if (!this.checkDir(traceDir)) {
                String oldDir = traceDir;
                traceDir = System.getProperty("user.dir");
                DfLogger.warn((Object)this, "The tracer could not use the directory {0}.  It will attempt to use the current working directory: {1}", new String[]{oldDir, traceDir}, null);
                if (!this.checkDir(traceDir)) {
                    traceDir = System.getProperty("java.io.tmpdir");
                    DfLogger.warn((Object)this, "The tracer could not use the current working directory.  It will attempt to use the temporary directory: {0}", new String[]{traceDir}, null);
                    if (!this.checkDir(traceDir)) {
                        throw new FileNotFoundException();
                    }
                }
            }
        }
        b.append(traceDir).append(sep);
    }

    private void getTraceFileName(TracingConfig config, StringBuilder b, boolean isBasePath) {
        b.append(config.getTraceFilePrefix()).append(".").append(System.currentTimeMillis());
        if (!isBasePath) {
            b.append(".log");
        }
    }

    private boolean checkDir(String dir) {
        boolean retval;
        File fDir = new File(dir);
        if (fDir.exists()) {
            retval = fDir.isDirectory() && this.canWrite(fDir);
        } else {
            boolean bl = retval = fDir.mkdirs() && this.canWrite(fDir);
        }
        if (!retval) {
            this.logDirectoryError(fDir);
        }
        return retval;
    }

    private boolean canWrite(File f) {
        if (f.canWrite()) {
            return true;
        }
        if (f.isDirectory()) {
            try {
                File f2 = new File(f.getCanonicalPath() + File.separator + "_trace_tmp");
                f2.createNewFile();
                f2.delete();
                return true;
            }
            catch (IOException e) {
                return false;
            }
        }
        return false;
    }

    private void logDirectoryError(File f) {
        String[] args = new String[]{f.getAbsolutePath()};
        if (!f.exists()) {
            DfLogger.warn((Object)this, "The directory {0} does not exist and it could not be created", args, null);
        } else if (!f.isDirectory()) {
            DfLogger.warn((Object)this, "The path specified as the trace log directory ({0}) is not a directory", args, null);
        } else if (!this.canWrite(f)) {
            DfLogger.warn((Object)this, "The tracer cannot use the configured directory {0} because it does not have permission to write to it", args, null);
        } else {
            DfLogger.warn((Object)this, "There was an unknown issue with the directory configured for tracing: {0}", args, null);
        }
    }

    private static int getNextId() {
        return s_tracerId++;
    }

    public String getFilePath() {
        return ((FileAppender)this.m_appender).getFile();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class ThreadTraceContextLocal
    extends ThreadLocal<ThreadTraceContext> {
        ThreadTraceContextLocal() {
        }

        @Override
        protected synchronized ThreadTraceContext initialValue() {
            return new ThreadTraceContext();
        }

        public ThreadTraceContext get(Tracer tracer) {
            ThreadTraceContext retval = (ThreadTraceContext)this.get();
            if (retval.getTracerId() != tracer.getTracerId()) {
                retval.reset(tracer);
            }
            return retval;
        }
    }

    static class TriggerList {
        private TracingTrigger m_first;
        private TracingTrigger m_last;

        public boolean isTriggered(Tracer tracer, MethodContext context, boolean isEntrance) {
            if (this.m_first == null) {
                return true;
            }
            return this.m_first.isTriggered(tracer, context, isEntrance);
        }

        public void reset() {
            if (this.m_first != null) {
                this.m_first.reset();
            }
        }

        public void add(TracingTrigger trigger) {
            if (this.m_first == null) {
                this.m_first = trigger;
                this.m_last = trigger;
            } else {
                this.m_last.addNext(trigger);
                this.m_last = trigger;
            }
        }
    }
}

