/*
 * Decompiled with CFR 0.152.
 */
package com.documentum.fc.tracing.impl;

import com.documentum.fc.impl.util.reflection.proxy.IProxyHandler;
import com.documentum.fc.tracing.ITraceString;
import com.documentum.fc.tracing.IUserTracingInfo;
import com.documentum.fc.tracing.impl.ITimingHelper;
import com.documentum.fc.tracing.impl.LogEventContext;
import com.documentum.fc.tracing.impl.MethodContext;
import com.documentum.fc.tracing.impl.TracerLayout;
import com.documentum.fc.tracing.impl.Tracing;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.Set;
import java.util.TreeSet;
import org.apache.log4j.spi.LoggingEvent;

public class TraceItem {
    protected Type m_type;
    protected MethodContext m_methodContext;
    protected int m_callDepth;
    protected int m_rpcDepth;
    protected Thread m_thread;
    protected ITimingHelper m_timingHelper;
    protected TracerLayout m_layout;
    private static Set<String> s_setPrimitiveNames;
    private static Set<String> s_setPrimitiveWrappers;
    private static final String DOTS = "..........................................................................................................................................................................................................................................................................................................................................................................................................................................................................................................................................................................................................................................................................................................................................................................................................................................................................................";
    private static final int DOTS_LENGTH;

    public TraceItem(Type type, MethodContext methodContext, int traceDepth, ITimingHelper timingHelper) {
        assert (methodContext != null) : "TraceItem created with null methodContext";
        this.m_type = type;
        this.m_methodContext = methodContext;
        this.m_callDepth = traceDepth;
        this.m_thread = Thread.currentThread();
        this.m_timingHelper = timingHelper;
        timingHelper.markBeginTime();
    }

    public Type getType() {
        return this.m_type;
    }

    public String getQualifiedClassName() {
        return this.m_methodContext.getTargetClassName();
    }

    public String getIdentityName() {
        return this.m_methodContext.getIdentityName();
    }

    public String getMethodName() {
        return this.m_methodContext.getMethodName();
    }

    public Object[] getArgs() {
        return this.m_methodContext.getArgs();
    }

    public String getArgsString() {
        return this.formatArgs(this.getArgs());
    }

    public int getCallDepth() {
        return this.m_callDepth;
    }

    public int getRpcDepth() {
        return this.m_rpcDepth;
    }

    public String getCallDepthString() {
        return DOTS.substring(0, Math.min(this.m_callDepth, DOTS_LENGTH));
    }

    public Object getReturnValue() {
        return this.m_methodContext.getReturnValue();
    }

    public String getReturnValueString() {
        return this.formatReturnArg();
    }

    public void setReturnValue(MethodContext methodContext) {
        this.m_methodContext.setReturnValue(methodContext);
        this.m_methodContext.setReturnType(methodContext);
    }

    public void setCallDepth(int callDepth) {
        this.m_callDepth = callDepth;
    }

    public void setRpcDepth(int rpcDepth) {
        this.m_rpcDepth = rpcDepth;
    }

    public Throwable getThrowable() {
        return this.m_methodContext.getThrowable();
    }

    public void setThrowable(MethodContext methodContext) {
        this.m_methodContext.setThrowable(methodContext);
    }

    public String getStackTraceString() {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(os);
        this.m_methodContext.getThrowable().printStackTrace(ps);
        ps.flush();
        return os.toString();
    }

    public static void appendThrowable(Throwable t, String indent, String nl, String throwableSep, StringWriter sw) {
        sw.append(indent).append(t.getClass().getName()).append(":");
        StackTraceElement[] elems = t.getStackTrace();
        sw.append(throwableSep);
        for (StackTraceElement elem : elems) {
            sw.append(nl).append(indent).append(elem.getClassName()).append(".").append(elem.getMethodName()).append('(');
            String fname = elem.getFileName();
            if (fname != null) {
                sw.append(fname).append(':').append(Integer.toString(elem.getLineNumber()));
            } else {
                sw.append("compiled code");
            }
            sw.append(')');
        }
    }

    public void setMethodContext(MethodContext methodContext) {
        this.m_methodContext = methodContext;
    }

    public String getThreadName() {
        if (this.m_methodContext instanceof LogEventContext) {
            return ((LoggingEvent)this.m_methodContext.getTarget()).getThreadName();
        }
        return this.m_thread.getName();
    }

    public String getMessage() {
        if (this.m_methodContext instanceof LogEventContext) {
            LoggingEvent event = (LoggingEvent)this.m_methodContext.getTarget();
            return event.getLevel().toString() + ": " + event.getMessage().toString();
        }
        return "";
    }

    public String getUser() {
        return this.m_methodContext.getUser(null);
    }

    public IUserTracingInfo getUserTracingInfo() {
        return this.m_methodContext.getUserInfo(null);
    }

    public void methodExited() {
        this.m_timingHelper.markEndTime();
    }

    public void addTimeAdjustment(long deltaTime) {
        this.m_timingHelper.addTimeAdjustment(deltaTime);
    }

    public String getTimestampString(SimpleDateFormat format) {
        return this.m_timingHelper.getTimestampString(format);
    }

    public long getDuration() {
        return this.m_timingHelper.getDuration();
    }

    public String getDurationString() {
        return this.m_timingHelper.getDurationString();
    }

    public void setLayout(TracerLayout layout) {
        this.m_layout = layout;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(256);
        this.m_layout.format(this, builder);
        return builder.toString();
    }

    static boolean canCallToString(String className) {
        boolean retval = false;
        if (s_setPrimitiveNames.contains(className) || className.startsWith("java.lang.") && s_setPrimitiveWrappers.contains(className.substring(10))) {
            retval = true;
        }
        return retval;
    }

    private String formatArgs(Object[] args) {
        if (args == null || args.length == 0) {
            return "";
        }
        StringBuilder b = new StringBuilder(args.length << 5);
        String sep = "";
        for (Object o : args) {
            b.append(sep);
            sep = ",";
            if (o == null) {
                b.append("null");
                continue;
            }
            String cn = o.getClass().getName();
            b.append(this.formatNonNullArg(o, cn));
        }
        return b.toString();
    }

    private String formatNonNullArg(Object o, String className) {
        if (className.equals("java.lang.String")) {
            return "\"" + o.toString() + "\"";
        }
        if (o instanceof ITraceString) {
            return ((ITraceString)o).toTraceString(Tracing.isVerbose());
        }
        if (TraceItem.canCallToString(className)) {
            return o.toString();
        }
        if (o instanceof IProxyHandler) {
            o = ((IProxyHandler)o).____getImp____();
            className = o.getClass().getName();
        }
        StringBuilder b = new StringBuilder(className.length() + 10);
        b.append(TraceItem.formatClassName(className, o)).append("@").append(Integer.toHexString(System.identityHashCode(o)));
        return b.toString();
    }

    String formatReturnArg() {
        Class returnType;
        Object returnValue;
        Object retval = this.m_methodContext.getReturnType() == Void.TYPE ? "<void>" : (this.m_methodContext.getThrowable() != null ? null : ((returnValue = this.m_methodContext.getReturnValue()) == null ? "null" : (returnValue == "******" ? "******" : ((returnType = this.m_methodContext.getReturnType()) == null ? "" : this.formatNonNullArg(returnValue, returnType.getName())))));
        return retval;
    }

    private static String formatClassName(String className, Object o) {
        if (className.startsWith("[") && className.endsWith(";")) {
            StringBuffer buf = new StringBuffer(16);
            int n = 0;
            Object eo = o;
            while (className.charAt(n) == '[') {
                buf.append('[');
                if (eo != null && eo instanceof Object[]) {
                    int length = ((Object[])eo).length;
                    buf.append(length);
                    eo = length > 0 ? ((Object[])eo)[0] : null;
                }
                buf.append(']');
                ++n;
            }
            if (className.charAt(n) == 'L') {
                ++n;
            }
            return className.substring(n, className.length() - 1) + buf.toString();
        }
        if (className.startsWith("java.lang.") && className.indexOf(46, 10) < 0) {
            return className.substring(10);
        }
        return className;
    }

    static {
        DOTS_LENGTH = DOTS.length();
        s_setPrimitiveNames = new TreeSet<String>();
        s_setPrimitiveNames.add(Boolean.TYPE.getName());
        s_setPrimitiveNames.add(Byte.TYPE.getName());
        s_setPrimitiveNames.add(Character.TYPE.getName());
        s_setPrimitiveNames.add(Double.TYPE.getName());
        s_setPrimitiveNames.add(Float.TYPE.getName());
        s_setPrimitiveNames.add(Integer.TYPE.getName());
        s_setPrimitiveNames.add(Long.TYPE.getName());
        s_setPrimitiveNames.add(Short.TYPE.getName());
        s_setPrimitiveWrappers = new TreeSet<String>();
        s_setPrimitiveWrappers.add("Boolean");
        s_setPrimitiveWrappers.add("Byte");
        s_setPrimitiveWrappers.add("Character");
        s_setPrimitiveWrappers.add("Double");
        s_setPrimitiveWrappers.add("Float");
        s_setPrimitiveWrappers.add("Integer");
        s_setPrimitiveWrappers.add("Long");
        s_setPrimitiveWrappers.add("Short");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        ENTRANCE,
        EXIT,
        EXCEPTION,
        ONE_LINE,
        RPC_ENTRANCE,
        RPC_EXIT,
        RPC_EXCEPTION,
        RPC_ONE_LINE,
        LOG_EVENT,
        COMPACT_LOG_EVENT;

    }
}

