/*
 * Decompiled with CFR 0.152.
 */
package com.documentum.fc.tracing.impl;

import com.documentum.fc.tracing.IUserTracingInfo;
import com.documentum.fc.tracing.impl.CallDepthEvent;
import com.documentum.fc.tracing.impl.TraceItem;
import com.documentum.fc.tracing.impl.Tracer;
import java.util.LinkedList;
import org.apache.log4j.Logger;

public final class ThreadTraceContext {
    private int m_tracerId = -1;
    private int m_depth = 0;
    private int m_markedDepth = -1;
    private int m_rpcDepth = 0;
    private int m_markedRpcDepth = -1;
    private Boolean m_isThreadTracingUser = null;
    private String m_threadUserName;
    private IUserTracingInfo m_threadUserInfo;
    private int m_disableCount = 0;
    private LinkedList<TraceItem> m_stackMethodsEntered = new LinkedList();
    private LinkedList<TraceItem> m_itemsToTrace = new LinkedList();
    public static final int NOT_MARKED = -1;

    public int getDepth() {
        return this.m_depth;
    }

    public int getRpcDepth() {
        return this.m_rpcDepth;
    }

    public int adjustCallDepth(int delta) {
        this.m_depth += delta;
        if (this.m_depth < 0) {
            this.m_depth = 0;
            this.m_markedDepth = -1;
        }
        return this.m_depth;
    }

    public int adjustRpcDepth(int delta) {
        this.m_rpcDepth += delta;
        if (this.m_rpcDepth < 0) {
            this.m_rpcDepth = 0;
            this.m_markedRpcDepth = -1;
        }
        return this.m_rpcDepth;
    }

    public void markCallDepth() {
        this.m_markedDepth = this.m_depth;
        this.m_markedRpcDepth = this.m_rpcDepth;
    }

    public boolean isDepthMarked() {
        return this.m_markedDepth != -1;
    }

    public int getCallDepth(boolean fromMark) {
        if (fromMark) {
            return this.m_markedDepth == -1 ? 0 : this.m_depth - this.m_markedDepth;
        }
        return this.m_depth;
    }

    public int getRpcDepth(boolean fromMark) {
        if (fromMark) {
            return this.m_markedRpcDepth == -1 ? 0 : this.m_rpcDepth - this.m_markedRpcDepth;
        }
        return this.m_rpcDepth;
    }

    public Boolean isThreadTracingUser() {
        return this.m_isThreadTracingUser;
    }

    public void setThreadTracingUser(Boolean isThreadTracingUser) {
        this.m_isThreadTracingUser = isThreadTracingUser;
    }

    public void clearThreadUser() {
        this.m_isThreadTracingUser = null;
        this.m_threadUserName = null;
        this.m_threadUserInfo = null;
    }

    public String getThreadUserName() {
        return this.m_threadUserName;
    }

    public void setThreadUserName(String user) {
        this.m_threadUserName = user;
    }

    public IUserTracingInfo getThreadUserInfo() {
        return this.m_threadUserInfo;
    }

    public void setThreadUserInfo(IUserTracingInfo info) {
        if (this.m_threadUserInfo == null) {
            this.m_threadUserInfo = info.clone();
        } else {
            this.m_threadUserInfo.update(info);
            this.m_threadUserInfo.setRpcCount(info.getRpcCount());
        }
        if (info.getUser() != null) {
            this.m_threadUserName = info.getUser();
        }
    }

    public void resetStack() {
        this.m_stackMethodsEntered = new LinkedList();
        this.m_itemsToTrace = new LinkedList();
    }

    public void pushMethodTraceItem(TraceItem traceItem) {
        this.m_stackMethodsEntered.add(traceItem);
        this.pushTraceItem(traceItem);
    }

    public void pushTraceItem(TraceItem traceItem) {
        this.m_itemsToTrace.add(traceItem);
    }

    public TraceItem popMethodTraceItem() {
        TraceItem retval = !this.m_stackMethodsEntered.isEmpty() ? this.m_stackMethodsEntered.removeLast() : null;
        return retval;
    }

    public void addTimeAdjustmentToSurroundingRpcTraceItems(long deltaTime) {
        for (TraceItem item : this.m_stackMethodsEntered) {
            if (item.getType() != TraceItem.Type.RPC_ONE_LINE) continue;
            item.addTimeAdjustment(deltaTime);
        }
    }

    public void trace(Logger logger) {
        if (this.m_stackMethodsEntered.size() == 0) {
            for (TraceItem traceItem : this.m_itemsToTrace) {
                logger.debug((Object)traceItem);
            }
            this.m_itemsToTrace.clear();
        }
    }

    public void postTrace(Tracer tracer) {
        if (this.m_depth == 0) {
            tracer.notifyCallDepthListeners(new CallDepthEvent(tracer, 0, this));
            this.clearThreadUser();
        }
        if (this.m_depth <= this.m_markedDepth) {
            this.m_markedDepth = -1;
            this.m_markedRpcDepth = -1;
        }
    }

    public boolean isDisabled() {
        return this.m_disableCount > 0;
    }

    public void disableTracing() {
        ++this.m_disableCount;
    }

    public void enableTracing() {
        --this.m_disableCount;
        if (this.m_disableCount < 0) {
            this.m_disableCount = 0;
        }
    }

    public void reset(Tracer tracer) {
        if (this.m_tracerId >= 0) {
            this.m_depth = 0;
            this.m_markedDepth = -1;
            this.m_rpcDepth = 0;
            this.m_markedRpcDepth = -1;
            this.m_isThreadTracingUser = null;
            this.m_threadUserName = null;
            this.m_threadUserInfo = null;
            this.m_disableCount = 0;
            this.m_stackMethodsEntered = new LinkedList();
            this.m_itemsToTrace = new LinkedList();
        }
        this.m_tracerId = tracer.getTracerId();
    }

    public int getTracerId() {
        return this.m_tracerId;
    }

    static class UserCount {
        public int count = 0;

        public UserCount(int initCount) {
            this.count = initCount;
        }
    }
}

