/*
 * Decompiled with CFR 0.152.
 */
package com.documentum.fc.tracing.impl;

import com.documentum.fc.client.impl.connection.docbase.IDocbaseRpcClient;
import com.documentum.fc.tracing.IUserTracingInfo;
import com.documentum.fc.tracing.impl.MethodContext;
import com.documentum.fc.tracing.impl.MethodTracer;
import com.documentum.fc.tracing.impl.RpcContext;
import com.documentum.fc.tracing.impl.ThreadTraceContext;
import com.documentum.fc.tracing.impl.TraceItem;
import com.documentum.fc.tracing.impl.TraceItemFactory;
import com.documentum.fc.tracing.impl.Tracer;
import org.apache.log4j.Logger;

class OneLineTracer
implements MethodTracer {
    private Tracer m_tracer;
    private Logger m_logger;
    private TraceItemFactory m_factory;
    private boolean m_hasMethodFilters;

    public OneLineTracer(Tracer tracer, TraceItemFactory factory) {
        this.m_factory = factory;
        this.m_tracer = tracer;
        this.m_logger = tracer.getLogger();
        this.m_hasMethodFilters = tracer.hasMethodFilters();
        tracer.getThreadTraceContext().resetStack();
    }

    public void traceMethodEntrance(Tracer tracer, MethodContext methodContext) {
        methodContext.getUserInfo(tracer);
        TraceItem item = this.m_factory.create(TraceItem.Type.ONE_LINE, methodContext, this.m_tracer.getCallDepth(this.m_hasMethodFilters));
        item.setMethodContext(methodContext);
        this.m_tracer.getThreadTraceContext().pushMethodTraceItem(item);
    }

    public void traceMethodExit(Tracer tracer, MethodContext methodContext) {
        ThreadTraceContext context = this.m_tracer.getThreadTraceContext();
        TraceItem item = context.popMethodTraceItem();
        if (item != null) {
            item.methodExited();
            item.setReturnValue(methodContext);
            methodContext.getUserInfo(tracer);
            IUserTracingInfo info = item.getUserTracingInfo();
            if (info != null) {
                info.update(tracer.getThreadUserInfo());
            }
            context.trace(this.m_logger);
        }
    }

    public void traceMethodException(Tracer tracer, MethodContext methodContext) {
        ThreadTraceContext context = this.m_tracer.getThreadTraceContext();
        TraceItem item = context.popMethodTraceItem();
        if (item != null) {
            item.methodExited();
            item.setThrowable(methodContext);
            methodContext.getUserInfo(tracer);
            IUserTracingInfo info = item.getUserTracingInfo();
            if (info != null) {
                info.update(tracer.getThreadUserInfo());
            }
            context.trace(this.m_logger);
        }
    }

    public void traceRpcEntrance(Tracer tracer, RpcContext rpcContext) {
        this.updateThreadRpcCount(tracer, rpcContext);
        rpcContext.getUserInfo(tracer);
        TraceItem item = this.m_factory.create(TraceItem.Type.RPC_ONE_LINE, rpcContext, this.m_tracer.getCallDepth(this.m_hasMethodFilters));
        item.setRpcDepth(this.m_tracer.getRpcDepth(this.m_hasMethodFilters));
        item.setMethodContext(rpcContext);
        this.m_tracer.getThreadTraceContext().pushMethodTraceItem(item);
    }

    public void traceRpcExit(Tracer tracer, RpcContext rpcContext) {
        this.updateThreadRpcCount(tracer, rpcContext);
        rpcContext.getUserInfo(tracer);
        ThreadTraceContext context = this.m_tracer.getThreadTraceContext();
        TraceItem item = context.popMethodTraceItem();
        if (item != null) {
            item.methodExited();
            item.setReturnValue(rpcContext);
            context.addTimeAdjustmentToSurroundingRpcTraceItems(item.getDuration());
            IUserTracingInfo info = item.getUserTracingInfo();
            if (info != null) {
                info.update(tracer.getThreadUserInfo());
            }
            context.trace(this.m_logger);
        }
    }

    public void traceRpcException(Tracer tracer, RpcContext rpcContext) {
        this.updateThreadRpcCount(tracer, rpcContext);
        rpcContext.getUserInfo(tracer);
        ThreadTraceContext context = this.m_tracer.getThreadTraceContext();
        TraceItem item = context.popMethodTraceItem();
        if (item != null) {
            item.methodExited();
            item.setThrowable(rpcContext);
            context.addTimeAdjustmentToSurroundingRpcTraceItems(item.getDuration());
            IUserTracingInfo info = item.getUserTracingInfo();
            if (info != null) {
                info.update(tracer.getThreadUserInfo());
            }
            context.trace(this.m_logger);
        }
    }

    public void traceLogEvent(Tracer tracer, MethodContext eventContext) {
        eventContext.getUserInfo(tracer);
        TraceItem item = this.m_factory.create(TraceItem.Type.COMPACT_LOG_EVENT, eventContext, this.m_tracer.getCallDepth(this.m_hasMethodFilters));
        ThreadTraceContext context = this.m_tracer.getThreadTraceContext();
        context.pushTraceItem(item);
        context.trace(this.m_logger);
    }

    private void updateThreadRpcCount(Tracer tracer, RpcContext rpcContext) {
        Object target = rpcContext.getTarget();
        if (target instanceof IDocbaseRpcClient) {
            int newRpcCount = ((IDocbaseRpcClient)target).getNumberOfSends();
            tracer.updateThreadRpcCount(newRpcCount);
        }
    }
}

