/*
 * Decompiled with CFR 0.152.
 */
package com.documentum.fc.tracing.impl;

import com.documentum.fc.tracing.IUserIdentifyingObject;
import com.documentum.fc.tracing.IUserTracingInfo;
import com.documentum.fc.tracing.impl.ThreadTraceContext;
import com.documentum.fc.tracing.impl.Tracer;
import com.documentum.fc.tracing.impl.Verbosity;
import com.documentum.fc.tracing.impl.annotation.Mask;
import com.documentum.fc.tracing.impl.annotation.TracingVerbosity;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.Arrays;

public class MethodContext {
    private static final String[] EMPTY_LIST = new String[0];
    protected Object m_target;
    protected Class m_targetClass;
    protected String m_methodName;
    protected AnnotatedElement m_annotatedElement;
    protected boolean m_excluded;
    protected Object[] m_args;
    protected Object m_returnValue;
    protected Class m_returnType;
    protected Throwable m_throwable;
    protected IUserIdentifyingObject m_userIdObject;
    protected String[] m_users;
    protected String m_user;
    protected IUserTracingInfo m_userInfo;
    public static final String MASKED_VALUE = "******";

    public MethodContext(Object target, Class targetClass, String methodName, AnnotatedElement annotatedElement, IUserIdentifyingObject uio, boolean exclude, Object[] args) {
        this(target, targetClass, methodName, annotatedElement, uio, exclude);
        this.m_args = args;
    }

    public MethodContext(Object target, Class targetClass, String methodName, AnnotatedElement annotatedElement, IUserIdentifyingObject uio, boolean exclude, Object returnValue, Class returnType) {
        this(target, targetClass, methodName, annotatedElement, uio, exclude);
        this.m_returnValue = returnValue;
        this.m_returnType = returnType;
    }

    public MethodContext(Object target, Class targetClass, String methodName, AnnotatedElement annotatedElement, IUserIdentifyingObject uio, boolean exclude, Throwable t) {
        this(target, targetClass, methodName, annotatedElement, uio, exclude);
        this.m_throwable = t;
    }

    private MethodContext(Object target, Class targetClass, String methodName, AnnotatedElement annotatedElement, IUserIdentifyingObject uio, boolean excluded) {
        this.m_target = target;
        this.m_targetClass = targetClass;
        this.m_methodName = methodName;
        this.m_annotatedElement = annotatedElement;
        this.m_excluded = excluded;
        this.m_userIdObject = uio;
    }

    public Object getTarget() {
        return this.m_target;
    }

    public Class getTargetClass() {
        return this.m_targetClass;
    }

    public String getIdentityName() {
        String qualifiedClassName = this.getTargetClassName();
        int hash = this.getIdentityHashcode();
        if (hash == 0) {
            return qualifiedClassName;
        }
        StringBuilder b = new StringBuilder(qualifiedClassName.length() + 12);
        b.append(qualifiedClassName).append('@').append(Integer.toHexString(hash));
        return b.toString();
    }

    public int getIdentityHashcode() {
        return System.identityHashCode(this.m_target);
    }

    public String getTargetClassName() {
        return this.m_targetClass.getName();
    }

    public String getMethodName() {
        return this.m_methodName;
    }

    public boolean hasTracingAnnotations() {
        return this.m_annotatedElement != null;
    }

    public boolean isExcluded() {
        return this.m_excluded;
    }

    public Object[] getArgs() {
        if (this.hasTracingAnnotations() && this.m_annotatedElement instanceof Method) {
            Annotation[][] annotations = ((Method)this.m_annotatedElement).getParameterAnnotations();
            int limit = this.m_args.length;
            for (int i = 0; i < limit; ++i) {
                for (Annotation annotation : annotations[i]) {
                    if (!(annotation instanceof Mask)) continue;
                    this.m_args[i] = MASKED_VALUE;
                }
            }
        }
        return this.m_args;
    }

    public Object getReturnValue() {
        return this.m_returnValue;
    }

    public void setReturnValue(MethodContext methodContext) {
        this.m_returnValue = this.isReturnValueMasked() ? MASKED_VALUE : methodContext.getReturnValue();
    }

    public Class getReturnType() {
        return this.m_returnType;
    }

    public void setReturnType(MethodContext methodContext) {
        this.m_returnType = methodContext.getReturnType();
    }

    public Throwable getThrowable() {
        return this.m_throwable;
    }

    public void setThrowable(MethodContext methodContext) {
        this.m_throwable = methodContext.getThrowable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getUsers(Tracer tracer) {
        if (this.m_users == null) {
            if (this.m_userIdObject != null && tracer != null) {
                tracer.disableTracingOnThread();
                try {
                    this.m_users = this.m_userIdObject.getUsersForTracing();
                }
                finally {
                    tracer.enableTracingOnThread();
                }
            }
            if (this.m_users == null) {
                if (tracer == null) {
                    return EMPTY_LIST;
                }
                this.m_users = EMPTY_LIST;
            } else if (this.m_users.length == 1) {
                this.m_user = this.m_users[0];
            }
        }
        return this.m_users;
    }

    public String getUser(Tracer tracer) {
        if (this.m_user == null) {
            this.getUserInfo(tracer);
        }
        return this.m_user;
    }

    public void setUser(String user) {
        this.m_user = user;
    }

    public void setUser(ThreadTraceContext context) {
        if (this.m_user == null) {
            this.m_user = context.getThreadUserName();
        } else if (context.getThreadUserName() == null) {
            context.setThreadUserName(this.m_user);
        }
    }

    public IUserTracingInfo getUserInfo(Tracer tracer) {
        if (this.m_userInfo == null && tracer != null) {
            IUserTracingInfo threadUserInfo;
            this.setUserInfoFromObject(tracer);
            if ((this.m_userInfo == null || this.m_user == null) && (threadUserInfo = tracer.getThreadUserInfo()) != null) {
                this.m_userInfo = threadUserInfo;
            }
            if (this.m_userInfo != null && this.m_user == null) {
                this.m_user = this.m_userInfo.getUser();
            }
        }
        return this.m_userInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setUserInfoFromObject(Tracer tracer) {
        if (this.m_userIdObject != null) {
            tracer.disableTracingOnThread();
            try {
                this.m_userInfo = this.m_userIdObject.getUserTracingInfo(this.m_user);
                if (this.m_userInfo != null) {
                    if (this.m_user == null) {
                        this.m_user = this.m_userInfo.getUser();
                    }
                    tracer.getThreadTraceContext().setThreadUserInfo(this.m_userInfo);
                }
            }
            finally {
                tracer.enableTracingOnThread();
            }
        }
    }

    public boolean isReturnValueMasked() {
        return this.hasTracingAnnotations() && this.m_annotatedElement.isAnnotationPresent(Mask.class);
    }

    public Verbosity getTracingVerbosity() {
        if (!this.hasTracingAnnotations()) {
            return null;
        }
        TracingVerbosity level = MethodContext.getVerbosityAnnotation(this.m_targetClass);
        if (level == null) {
            level = MethodContext.getVerbosityAnnotation(this.m_annotatedElement);
        }
        return level == null ? null : level.verbosity();
    }

    String dump() {
        String nl = System.getProperty("line.separator");
        StringBuilder b = new StringBuilder(512);
        b.append("Target: ").append(this.m_targetClass.getName()).append(nl);
        b.append("Method: ").append(this.m_methodName).append(nl);
        b.append("Args: ");
        this.getArgsAsString(b);
        b.append(nl);
        b.append("Return: ");
        this.getArgAsString(this.m_returnValue, b);
        b.append(nl);
        b.append("User ID Object: ");
        this.getArgAsString(this.m_userIdObject, b);
        b.append(nl);
        b.append("Users: ").append(Arrays.toString(this.m_users)).append(nl);
        b.append("User: ").append(this.m_user).append(nl);
        return b.toString();
    }

    private void getArgsAsString(StringBuilder b) {
        String sep = "";
        for (Object o : this.m_args) {
            b.append(sep);
            this.getArgAsString(o, b);
            sep = ",";
        }
    }

    private void getArgAsString(Object o, StringBuilder b) {
        if (o == null) {
            b.append("null");
        } else if (o.getClass().isPrimitive()) {
            b.append(o.toString());
        } else {
            b.append(o.getClass().getName()).append("@").append(System.identityHashCode(o));
        }
    }

    private static TracingVerbosity getVerbosityAnnotation(AnnotatedElement e) {
        return e.getAnnotation(TracingVerbosity.class);
    }
}

