/*
 * Decompiled with CFR 0.152.
 */
package com.documentum.fc.internal.util;

import java.util.StringTokenizer;

public class SoftwareVersion {
    public static final int COMPARISON_DEPTH_MAJOR = 0;
    public static final int COMPARISON_DEPTH_MINOR = 1;
    public static final int COMPARISON_DEPTH_MAINTENANCE = 2;
    public static final int COMPARISON_DEPTH_UPDATE = 3;
    private static final String VERSION_DELIMITER = ".";
    private String m_major = null;
    private String m_minor = null;
    private String m_maintenance = null;
    private String m_update = null;

    public SoftwareVersion(String formattedVersion) {
        StringTokenizer tokenizer = new StringTokenizer(formattedVersion, VERSION_DELIMITER);
        if (tokenizer.hasMoreTokens()) {
            this.m_major = (String)tokenizer.nextElement();
            if (tokenizer.hasMoreTokens()) {
                this.m_minor = (String)tokenizer.nextElement();
                if (tokenizer.hasMoreTokens()) {
                    this.m_maintenance = (String)tokenizer.nextElement();
                    if (tokenizer.hasMoreTokens()) {
                        this.m_update = (String)tokenizer.nextElement();
                    }
                }
            }
        }
    }

    public String getMajor() {
        return this.m_major;
    }

    public void setMajor(String major) {
        this.m_major = major;
    }

    public String getMinor() {
        return this.m_minor;
    }

    public void setMinor(String minor) {
        this.m_minor = minor;
    }

    public String getMaintenance() {
        return this.m_maintenance;
    }

    public void setMaintenance(String maintenance) {
        this.m_maintenance = maintenance;
    }

    public String getUpdate() {
        return this.m_update;
    }

    public void setUpdate(String update) {
        this.m_update = update;
    }

    public String getFormatted() {
        if (this.m_major == null) {
            return null;
        }
        if (this.m_minor == null) {
            return this.m_major;
        }
        if (this.m_maintenance == null) {
            return this.m_major + VERSION_DELIMITER + this.m_minor;
        }
        if (this.m_update == null) {
            return this.m_major + VERSION_DELIMITER + this.m_minor + VERSION_DELIMITER + this.m_maintenance;
        }
        return this.m_major + VERSION_DELIMITER + this.m_minor + VERSION_DELIMITER + this.m_maintenance + VERSION_DELIMITER + this.m_update;
    }

    public int compareTo(SoftwareVersion version) {
        return this.compareTo(version, 3);
    }

    public int compareTo(SoftwareVersion version, int comparisonDepth) {
        int compareResult = this.compareVersionLevel(this.m_major, version.getMajor());
        if (compareResult == 0 && comparisonDepth > 0 && (compareResult = this.compareVersionLevel(this.m_minor, version.getMinor())) == 0 && comparisonDepth > 1 && (compareResult = this.compareVersionLevel(this.m_maintenance, version.getMaintenance())) == 0 && comparisonDepth > 2) {
            compareResult = this.compareVersionLevel(this.m_update, version.getUpdate());
        }
        return compareResult;
    }

    public boolean equals(Object o) {
        if (o instanceof SoftwareVersion) {
            return this.compareTo((SoftwareVersion)o) == 0;
        }
        return false;
    }

    public int hashCode() {
        int result = -123;
        if (this.m_major != null) {
            result ^= this.m_major.hashCode();
        }
        if (this.m_minor != null) {
            result ^= this.m_minor.hashCode();
        }
        if (this.m_maintenance != null) {
            result ^= this.m_maintenance.hashCode();
        }
        if (this.m_update != null) {
            result ^= this.m_update.hashCode();
        }
        return result;
    }

    private int compareVersionLevel(String s, String s1) {
        int compareResult;
        block5: {
            try {
                int sIntVal = s != null && s.trim().length() != 0 ? Integer.parseInt(s) : 0;
                int s1IntVal = s1 != null && s1.trim().length() != 0 ? Integer.parseInt(s1) : 0;
                compareResult = sIntVal - s1IntVal;
                if (compareResult != 0) {
                    compareResult = compareResult <= 0 ? -1 : 1;
                }
            }
            catch (NumberFormatException e) {
                char c;
                int s1NumEnd;
                char c2;
                int sNumEnd;
                s = s == null ? "" : s;
                s1 = s1 == null ? "" : s1;
                int sLen = s.length();
                for (sNumEnd = 0; sNumEnd < sLen && (c2 = s.charAt(sNumEnd)) >= '0' && c2 <= '9'; ++sNumEnd) {
                }
                int s1Len = s1.length();
                for (s1NumEnd = 0; s1NumEnd < s1Len && (c = s1.charAt(s1NumEnd)) >= '0' && c <= '9'; ++s1NumEnd) {
                }
                compareResult = this.compareVersionLevel(s.substring(0, sNumEnd), s1.substring(0, s1NumEnd));
                if (compareResult != 0) break block5;
                compareResult = s.substring(sNumEnd, sLen).compareTo(s1.substring(s1NumEnd, s1Len));
            }
        }
        return compareResult;
    }
}

