/*
 * Decompiled with CFR 0.152.
 */
package com.documentum.fc.impl.util.reflection.proxy;

import com.documentum.fc.common.DfLogger;
import com.documentum.fc.impl.util.reflection.proxy.ProxyClassGenerator;
import com.documentum.thirdparty.javassist.CannotCompileException;
import com.documentum.thirdparty.javassist.NotFoundException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class ProxyClassLoader
extends ClassLoader {
    private Map m_proxyClasses;
    private String m_baseProxy;

    public ProxyClassLoader(ClassLoader parent, String baseProxy) {
        super(parent);
        this.m_baseProxy = baseProxy;
        this.m_proxyClasses = new HashMap();
    }

    public Class loadClass(String name) throws ClassNotFoundException {
        if (DfLogger.isDebugEnabled(this)) {
            DfLogger.debug((Object)this, "loadClass {0}", new String[]{name}, null);
        }
        return super.loadClass(name);
    }

    public synchronized Class loadProxyClass(Class impClass) throws ClassNotFoundException {
        Class proxyClass;
        String name = impClass.getName();
        if (DfLogger.isDebugEnabled(this)) {
            DfLogger.debug((Object)this, "loadProxyClass {0}", new String[]{name}, null);
        }
        if ((proxyClass = (Class)this.m_proxyClasses.get(name)) != null) {
            return proxyClass;
        }
        String proxyClassName = name + this.getProxySuffix();
        try {
            proxyClass = this.makeProxyClass(impClass, proxyClassName);
            this.m_proxyClasses.put(name, proxyClass);
            return proxyClass;
        }
        catch (NotFoundException e) {
            throw new ClassNotFoundException(proxyClassName, e);
        }
        catch (IOException e) {
            throw new ClassNotFoundException(proxyClassName, e);
        }
        catch (CannotCompileException e) {
            DfLogger.error((Object)this, "DFC_CORE_COULDNT_CREATE_PROXY", new String[]{name}, (Throwable)e);
            throw new ClassNotFoundException(proxyClassName, e);
        }
    }

    protected String getProxySuffix() {
        return "___PROXY";
    }

    protected ProxyClassGenerator getProxyGenerator() throws ClassNotFoundException {
        return new ProxyClassGenerator(this.m_baseProxy);
    }

    protected String getBaseProxy() {
        return this.m_baseProxy;
    }

    protected Class findClass(String name) throws ClassNotFoundException {
        if (DfLogger.isDebugEnabled(this)) {
            DfLogger.debug((Object)this, "findClass {0}", new String[]{name}, null);
        }
        return super.findClass(name);
    }

    private synchronized Class makeProxyClass(Class impClass, String proxyClassName) throws NotFoundException, CannotCompileException, ClassNotFoundException, IOException {
        ProxyClassGenerator generator = this.getProxyGenerator();
        byte[] b = generator.makeProxyByteCode(impClass, proxyClassName);
        return this.defineClass(proxyClassName, b, 0, b.length, this.getClass().getProtectionDomain());
    }
}

