/*
 * Decompiled with CFR 0.152.
 */
package com.documentum.fc.impl.util.reflection;

import com.documentum.fc.common.DfLogger;
import com.documentum.fc.common.DfPreferences;
import com.documentum.fc.common.DfRuntimeException;
import com.documentum.fc.impl.util.reflection.ClassReflectionUtil;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectStateCopier {
    private static final int MAX_FIELD_COUNT = 101;
    private static final Map<Class<? extends Object>, Map<String, Field>> s_classIndexes = Collections.synchronizedMap(new WeakHashMap());
    private static final IObjectProcessor s_listProcessor = new ListProcessor();
    private static final IObjectProcessor s_mapProcessor = new MapProcessor();
    private static final IObjectProcessor s_setProcessor = new SetProcessor();
    private static final IObjectProcessor s_assignableObjectProcessor = new AssignableObjectProcessor();
    private static final IObjectProcessor s_arrayProcessor = new ArrayProcessor();
    private static final IObjectProcessor s_nonAssignableObjectProcessor = new NonAssignableObjectProcessor();

    public static void deepObjectCopy(Object source, Object dest) {
        DfLogger.debug(ObjectStateCopier.class, "--------------- Start deepObjectCopy -----------------------", null, null);
        ObjectStateCopier.deepObjectCopy(source, dest, dest.getClass().getClassLoader(), new IdentityHashMap<Object, Object>());
    }

    private static void deepObjectCopy(Object source, Object dest, ClassLoader destClassLoader, Map<Object, Object> objectRegistry) {
        if (DfLogger.isDebugEnabled(ObjectStateCopier.class)) {
            if (source != null) {
                DfLogger.debug(ObjectStateCopier.class, "deepObjectCopy Source class ''{0}'' with classloader ''{1}''", new Object[]{source.getClass(), source.getClass().getClassLoader()}, null);
            }
            if (dest != null) {
                DfLogger.debug(ObjectStateCopier.class, "deepObjectCopy Destination class ''{0}'' with classloader ''{1}''", new Object[]{dest.getClass(), dest.getClass().getClassLoader()}, null);
            }
            DfLogger.debug(ObjectStateCopier.class, "deepObjectCopy Destination classloader ''{0}''", new Object[]{destClassLoader}, null);
        }
        ObjectStateCopier.register(source, dest, objectRegistry);
        if (dest != null) {
            Map<String, Field> sourceFieldsIndex = ObjectStateCopier.getClassFieldIndex(source.getClass());
            Map<String, Field> destFieldsIndex = ObjectStateCopier.getClassFieldIndex(dest.getClass());
            for (Map.Entry<String, Field> entry : sourceFieldsIndex.entrySet()) {
                Field destField = destFieldsIndex.get(entry.getKey());
                if (destField == null || !ObjectStateCopier.needProcessing(destField)) continue;
                ObjectStateCopier.setField(source, entry.getValue(), dest, destField, destClassLoader, objectRegistry);
            }
        }
    }

    private static boolean needProcessing(Field destField) {
        return !Modifier.isStatic(destField.getModifiers()) && !destField.isSynthetic();
    }

    private static void setField(Object source, Field sourceField, Object dest, Field destField, ClassLoader destClassLoader, Map<Object, Object> objectRegistry) {
        sourceField.setAccessible(true);
        destField.setAccessible(true);
        try {
            Object sourceValue = sourceField.get(source);
            if (sourceValue != null) {
                IObjectProcessor processor = ObjectStateCopier.getProcessor(sourceValue.getClass(), destField.getType());
                processor.copy(sourceValue, destField, destClassLoader, dest, objectRegistry);
            } else {
                ObjectStateCopier.setField(null, destField, dest, objectRegistry);
            }
        }
        catch (IllegalAccessException e) {
            DfLogger.error(ClassReflectionUtil.class, "DFC_BOF_INTERNAL_EXCEPTION", null, (Throwable)e);
            throw new DfRuntimeException("Unexpected: ", e);
        }
    }

    private static void setField(Object sourceValue, Field destField, Object dest, Map<Object, Object> objectRegistry) throws IllegalAccessException {
        ObjectStateCopier.register(sourceValue, sourceValue, objectRegistry);
        if (DfLogger.isDebugEnabled(ObjectStateCopier.class)) {
            DfLogger.debug(ObjectStateCopier.class, "setField destField ''{0}'' class ''{1}''  value ''{2}''", new Object[]{destField.getName(), destField.getDeclaringClass().getName(), sourceValue}, null);
            if (sourceValue != null) {
                DfLogger.debug(ObjectStateCopier.class, "setField classloaders destField ''{0}'' source ''{1}''", new Object[]{destField.getDeclaringClass().getClassLoader(), sourceValue.getClass().getClassLoader()}, null);
            }
        }
        destField.set(dest, sourceValue);
    }

    private static Object getDestValue(Object sourceValue, Field destField, ClassLoader destClassLoader, Map<Object, Object> objectRegistry) throws IllegalAccessException {
        Object destValue = null;
        if (sourceValue != null && (destValue = objectRegistry.get(sourceValue)) == null) {
            destValue = ObjectStateCopier.instantiateDestValue(sourceValue, destField, destClassLoader, sourceValue);
            IObjectProcessor processor = ObjectStateCopier.getProcessor(sourceValue.getClass(), destValue.getClass());
            destValue = processor.copy(sourceValue, destValue, destField, destClassLoader, objectRegistry);
            ObjectStateCopier.register(sourceValue, destValue, objectRegistry);
        }
        return destValue;
    }

    private static Object instantiateDestValue(Object sourceValue, Field destField, ClassLoader destClassLoader, Object defaultDestValue) throws IllegalAccessException {
        Object destValue;
        block11: {
            destValue = defaultDestValue;
            try {
                Class<?> destClass;
                ClassLoader targetClassLoader = destField.getDeclaringClass().getClassLoader();
                if (targetClassLoader == null) {
                    targetClassLoader = destClassLoader;
                }
                if ((destClass = targetClassLoader.loadClass(sourceValue.getClass().getName())).isArray()) {
                    destValue = Array.newInstance(destClass.getComponentType(), Array.getLength(sourceValue));
                } else {
                    Constructor<?> constructor = destClass.getConstructor(null);
                    constructor.setAccessible(true);
                    destValue = constructor.newInstance(null);
                }
            }
            catch (ClassNotFoundException e) {
                if (defaultDestValue == null) {
                    ObjectStateCopier.warnAboutUninitializedField(destField, e);
                }
            }
            catch (InstantiationException e) {
                if (defaultDestValue == null) {
                    ObjectStateCopier.warnAboutUninitializedField(destField, e);
                }
            }
            catch (NoSuchMethodException e) {
                if (defaultDestValue == null) {
                    ObjectStateCopier.warnAboutUninitializedField(destField, e);
                }
            }
            catch (InvocationTargetException e) {
                if (defaultDestValue != null) break block11;
                ObjectStateCopier.warnAboutUninitializedField(destField, e.getTargetException());
            }
        }
        return destValue;
    }

    private static void warnAboutUninitializedField(Field destField, Throwable e) {
        if (DfPreferences.access().areResourceDiagnosticsEnabled()) {
            DfLogger.warn(ClassReflectionUtil.class, "DFC_BOF_UNINITIALIZED_FIELD", new Object[]{destField.getName(), destField.getDeclaringClass().getName()}, e);
        }
    }

    private static boolean isAssignable(Class sourceClass, Class destClass) {
        return destClass.isAssignableFrom(sourceClass) || destClass.isPrimitive() || sourceClass.isPrimitive();
    }

    private static Map<String, Field> getClassFieldIndex(Class<? extends Object> clazz) {
        Map<String, Field> sourceFieldsIndex = s_classIndexes.get(clazz);
        if (sourceFieldsIndex == null) {
            sourceFieldsIndex = new HashMap<String, Field>(101);
            ObjectStateCopier.indexAllFields(clazz, sourceFieldsIndex);
            s_classIndexes.put(clazz, sourceFieldsIndex);
        }
        return sourceFieldsIndex;
    }

    private static void indexAllFields(Class<? extends Object> clazz, Map<String, Field> fieldsIndex) {
        if (!clazz.equals(Object.class)) {
            Field[] fields = clazz.getDeclaredFields();
            for (int i = 0; i < fields.length; ++i) {
                Field field = fields[i];
                fieldsIndex.put(ObjectStateCopier.generateKey(clazz, field), field);
            }
            ObjectStateCopier.indexAllFields(clazz.getSuperclass(), fieldsIndex);
        }
    }

    private static void register(Object sourceValue, Object destObject, Map<Object, Object> objectRegistry) {
        if (sourceValue != null) {
            objectRegistry.put(sourceValue, destObject);
        }
    }

    static IObjectProcessor getProcessor(Class sourceClass, Class destClass) {
        IObjectProcessor processor = null;
        processor = List.class.isAssignableFrom(sourceClass) ? s_listProcessor : (Map.class.isAssignableFrom(sourceClass) ? s_mapProcessor : (Set.class.isAssignableFrom(sourceClass) ? s_setProcessor : (ObjectStateCopier.isAssignable(sourceClass, destClass) ? s_assignableObjectProcessor : (sourceClass.isArray() ? s_arrayProcessor : s_nonAssignableObjectProcessor))));
        return processor;
    }

    private static String generateKey(Class<? extends Object> clazz, Field field) {
        return clazz.getName() + '|' + field.getName();
    }

    private ObjectStateCopier() {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class NonAssignableObjectProcessor
    implements IObjectProcessor {
        NonAssignableObjectProcessor() {
        }

        @Override
        public void copy(Object source, Field destField, ClassLoader destClassLoader, Object dest, Map<Object, Object> objectRegistry) throws IllegalAccessException {
            Object destValue = objectRegistry.get(source);
            if (destValue != null) {
                ObjectStateCopier.setField(destValue, destField, dest, objectRegistry);
            } else {
                destValue = destField.get(dest);
                if (destValue == null) {
                    destValue = ObjectStateCopier.instantiateDestValue(source, destField, destClassLoader, null);
                    ObjectStateCopier.setField(destValue, destField, dest, objectRegistry);
                }
                ObjectStateCopier.deepObjectCopy(source, destValue, destClassLoader, objectRegistry);
            }
        }

        @Override
        public Object copy(Object source, Object dest, Field destField, ClassLoader destClassLoader, Map<Object, Object> objectRegistry) throws IllegalAccessException {
            ObjectStateCopier.deepObjectCopy(source, dest, destClassLoader, objectRegistry);
            return dest;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ArrayProcessor
    implements IObjectProcessor {
        ArrayProcessor() {
        }

        @Override
        public void copy(Object source, Field destField, ClassLoader destClassLoader, Object dest, Map<Object, Object> objectRegistry) throws IllegalAccessException {
            Object[] sourceArray = (Object[])source;
            Object[] destArray = (Object[])destField.get(dest);
            if (destArray == null) {
                destArray = (Object[])ObjectStateCopier.instantiateDestValue(sourceArray, destField, destClassLoader, destArray);
            }
            ObjectStateCopier.setField(this.copy((Object)sourceArray, destArray, destField, destClassLoader, objectRegistry), destField, dest, objectRegistry);
        }

        @Override
        public Object copy(Object source, Object dest, Field destField, ClassLoader destClassLoader, Map<Object, Object> objectRegistry) throws IllegalAccessException {
            Object[] sourceArray = (Object[])source;
            Object[] destArray = (Object[])dest;
            assert (destArray != null);
            if (sourceArray.length != destArray.length) {
                destArray = (Object[])Array.newInstance(destArray.getClass().getComponentType(), sourceArray.length);
            }
            for (int i = 0; i < sourceArray.length; ++i) {
                destArray[i] = ObjectStateCopier.getDestValue(sourceArray[i], destField, destClassLoader, objectRegistry);
            }
            return destArray;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class AssignableObjectProcessor
    implements IObjectProcessor {
        AssignableObjectProcessor() {
        }

        @Override
        public void copy(Object source, Field destField, ClassLoader destClassLoader, Object dest, Map<Object, Object> objectRegistry) throws IllegalAccessException {
            ObjectStateCopier.register(source, source, objectRegistry);
            destField.set(dest, source);
        }

        @Override
        public Object copy(Object source, Object dest, Field destField, ClassLoader destClassLoader, Map<Object, Object> objectRegistry) throws IllegalAccessException {
            return source;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class MapProcessor
    implements IObjectProcessor {
        MapProcessor() {
        }

        @Override
        public void copy(Object source, Field destField, ClassLoader destClassLoader, Object dest, Map<Object, Object> objectRegistry) throws IllegalAccessException {
            Map sourceMap = (Map)source;
            Map destMap = (Map)destField.get(dest);
            if (destMap == null) {
                destMap = (Map)ObjectStateCopier.instantiateDestValue(sourceMap, destField, destClassLoader, destMap);
                destField.set(dest, destMap);
            }
            this.copy((Object)sourceMap, destMap, destField, destClassLoader, objectRegistry);
        }

        @Override
        public Object copy(Object source, Object dest, Field destField, ClassLoader destClassLoader, Map<Object, Object> objectRegistry) throws IllegalAccessException {
            Map sourceMap = (Map)source;
            Map destMap = (Map)dest;
            assert (destMap != null);
            destMap.clear();
            for (Map.Entry entry : sourceMap.entrySet()) {
                Object sourceItemKey = entry.getKey();
                Object sourceItemValue = entry.getValue();
                Object destItemKey = ObjectStateCopier.getDestValue(sourceItemKey, destField, destClassLoader, objectRegistry);
                Object destItemValue = ObjectStateCopier.getDestValue(sourceItemValue, destField, destClassLoader, objectRegistry);
                if (sourceItemKey != null && destItemKey == null || sourceItemValue != null && destItemValue == null) continue;
                destMap.put(destItemKey, destItemValue);
            }
            return dest;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class SetProcessor
    implements IObjectProcessor {
        SetProcessor() {
        }

        @Override
        public void copy(Object source, Field destField, ClassLoader destClassLoader, Object dest, Map<Object, Object> objectRegistry) throws IllegalAccessException {
            Set sourceSet = (Set)source;
            Set destSet = (Set)destField.get(dest);
            if (destSet == null) {
                destSet = (Set)ObjectStateCopier.instantiateDestValue(sourceSet, destField, destClassLoader, destSet);
                destField.set(dest, destSet);
            }
            this.copy((Object)sourceSet, destSet, destField, destClassLoader, objectRegistry);
        }

        @Override
        public Object copy(Object source, Object dest, Field destField, ClassLoader destClassLoader, Map<Object, Object> objectRegistry) throws IllegalAccessException {
            Set sourceSet = (Set)source;
            Set destSet = (Set)dest;
            assert (destSet != null);
            destSet.clear();
            for (Object sourceItemValue : sourceSet) {
                Object destItemValue = ObjectStateCopier.getDestValue(sourceItemValue, destField, destClassLoader, objectRegistry);
                if (sourceItemValue != null && destItemValue == null) continue;
                destSet.add(destItemValue);
            }
            return destSet;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ListProcessor
    implements IObjectProcessor {
        ListProcessor() {
        }

        @Override
        public void copy(Object source, Field destField, ClassLoader destClassLoader, Object dest, Map<Object, Object> objectRegistry) throws IllegalAccessException {
            List sourceList = (List)source;
            List destList = (List)destField.get(dest);
            if (destList == null) {
                destList = (List)ObjectStateCopier.instantiateDestValue(sourceList, destField, destClassLoader, destList);
                destField.set(dest, destList);
            }
            this.copy((Object)sourceList, destList, destField, destClassLoader, objectRegistry);
        }

        @Override
        public Object copy(Object source, Object dest, Field destField, ClassLoader destClassLoader, Map<Object, Object> objectRegistry) throws IllegalAccessException {
            List sourceList = (List)source;
            List destList = (List)dest;
            assert (destList != null);
            destList.clear();
            for (Object sourceItemValue : sourceList) {
                Object destItemValue = ObjectStateCopier.getDestValue(sourceItemValue, destField, destClassLoader, objectRegistry);
                if (sourceItemValue != null && destItemValue == null) continue;
                destList.add(destItemValue);
            }
            return destList;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static interface IObjectProcessor {
        public void copy(Object var1, Field var2, ClassLoader var3, Object var4, Map<Object, Object> var5) throws IllegalAccessException;

        public Object copy(Object var1, Object var2, Field var3, ClassLoader var4, Map<Object, Object> var5) throws IllegalAccessException;
    }
}

