/*
 * Decompiled with CFR 0.152.
 */
package com.documentum.fc.impl.util.reflection;

import com.documentum.fc.common.DfRuntimeException;
import com.documentum.thirdparty.javassist.CtClass;

public class MethodMangling {
    private static final String OPEN_CLOSE_BRACKET = "[][][][][][][][][][][][][][][][][][][][][][][][][][][][][][][][][][][][][][][][][][][][][][][][][][][][][][][][][][][][][][][][][][][][][][][][][][][][][][][][][][][][]";

    public static String getJavaType(Class type) {
        String name = type.getName();
        if (!type.isArray()) {
            return name;
        }
        return MethodMangling.translate(name);
    }

    public static String getJavaType(CtClass type) {
        return type.getName();
    }

    private static String translate(String name) {
        int count = 0;
        while (name.charAt(count++) == '[') {
        }
        StringBuffer buf = new StringBuffer(32);
        switch (name.charAt(--count)) {
            case 'L': {
                buf.append(name.substring(count + 1, name.length() - 1));
                break;
            }
            case 'I': {
                buf.append("int");
                break;
            }
            case 'Z': {
                buf.append("boolean");
                break;
            }
            case 'B': {
                buf.append("byte");
                break;
            }
            case 'C': {
                buf.append("char");
                break;
            }
            case 'D': {
                buf.append("double");
                break;
            }
            case 'F': {
                buf.append("float");
                break;
            }
            case 'J': {
                buf.append("long");
                break;
            }
            case 'S': {
                buf.append("short");
                break;
            }
            default: {
                throw new DfRuntimeException("Unknown type: " + name.charAt(count) + "   " + name);
            }
        }
        buf.append(OPEN_CLOSE_BRACKET.substring(0, 2 * count));
        return buf.toString();
    }
}

