/*
 * Decompiled with CFR 0.152.
 */
package com.documentum.fc.impl.util.reflection;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ClassReflectionUtil {
    private static final int MAX_INTERFACE_COUNT = 31;

    public static Class[] getAllInterfaces(Class clazz) {
        ArrayList<Class> interfList = new ArrayList<Class>(31);
        HashSet<Class> index = new HashSet<Class>(31);
        ClassReflectionUtil.appendInterfaces(interfList, index, clazz);
        Class[] interfaces = new Class[interfList.size()];
        int i = 0;
        for (Class anInterface : interfList) {
            interfaces[i++] = anInterface;
        }
        return interfaces;
    }

    public static Class[] getAllInterfaces(Object obj) {
        return ClassReflectionUtil.getAllInterfaces(obj.getClass());
    }

    public static String getConstantName(Class<?> myClass, int constantValue) {
        Field[] fields = myClass.getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            Field field = fields[i];
            int modifiers = field.getModifiers();
            String fieldType = "int";
            try {
                if (!Modifier.isPublic(modifiers) || !Modifier.isStatic(modifiers) || !field.getType().getName().equals(fieldType) || field.getInt(myClass) != constantValue) continue;
                return field.getName();
            }
            catch (IllegalAccessException e) {
                assert (false) : e.toString();
                continue;
            }
        }
        return null;
    }

    private static void appendInterfaces(List<Class> interfaces, Set<Class> index, Class clazz) {
        if (clazz != null) {
            ClassReflectionUtil.appendInterface(clazz, index, interfaces);
            Class<?>[] classes = clazz.getInterfaces();
            for (int i = 0; i < classes.length; ++i) {
                Class<?> item = classes[i];
                ClassReflectionUtil.appendInterface(clazz, index, interfaces);
                ClassReflectionUtil.appendInterfaces(interfaces, index, item);
            }
            ClassReflectionUtil.appendInterfaces(interfaces, index, clazz.getSuperclass());
        }
    }

    private static void appendInterface(Class clazz, Set<Class> index, List<Class> interfaces) {
        if (clazz.isInterface() && !index.contains(clazz)) {
            interfaces.add(clazz);
            index.add(clazz);
        }
    }

    private ClassReflectionUtil() {
    }
}

