/*
 * Decompiled with CFR 0.152.
 */
package com.documentum.fc.impl.util.io;

import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;

public final class StreamUtility {
    private static final int BUFFER_SIZE = 4096;

    private StreamUtility() {
    }

    public static void copyContents(InputStream input, OutputStream output) throws IOException {
        StreamUtility.copyContents(input, output, true, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyContents(InputStream input, OutputStream output, boolean closeInput, boolean closeOutput) throws IOException {
        try {
            int amountRead;
            byte[] buffer = new byte[4096];
            while ((amountRead = input.read(buffer)) > 0) {
                output.write(buffer, 0, amountRead);
            }
            output.flush();
            if (closeInput) {
                closeInput = false;
                input.close();
            }
            if (closeOutput) {
                closeOutput = false;
                output.close();
            }
        }
        finally {
            if (closeInput) {
                StreamUtility.closeSilently(input);
            }
            if (closeOutput) {
                StreamUtility.closeSilently(output);
            }
        }
    }

    public static void copyContents(Reader input, Writer output) throws IOException {
        StreamUtility.copyContents(input, output, true, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyContents(Reader input, Writer output, boolean closeInput, boolean closeOutput) throws IOException {
        try {
            int amountRead;
            char[] buffer = new char[4096];
            while ((amountRead = input.read(buffer)) > 0) {
                output.write(buffer, 0, amountRead);
            }
            output.flush();
            if (closeInput) {
                closeInput = false;
                input.close();
            }
            if (closeOutput) {
                closeOutput = false;
                output.close();
            }
        }
        finally {
            if (closeInput) {
                StreamUtility.closeSilently(input);
            }
            if (closeOutput) {
                StreamUtility.closeSilently(output);
            }
        }
    }

    public static void closeSilently(InputStream stream) {
        try {
            stream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void closeSilently(OutputStream stream) {
        try {
            stream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void closeSilently(Reader reader) {
        try {
            reader.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void closeSilently(Writer writer) {
        try {
            writer.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static long getSize(InputStream stream) {
        try {
            if (stream instanceof FileInputStream) {
                return ((FileInputStream)stream).getChannel().size();
            }
            if (stream instanceof ByteArrayInputStream) {
                return stream.available();
            }
            return -1L;
        }
        catch (IOException e) {
            return -1L;
        }
    }
}

