/*
 * Decompiled with CFR 0.152.
 */
package com.documentum.fc.impl.util.io;

import com.documentum.fc.common.DfLogger;
import com.documentum.fc.common.DfPreferences;
import com.documentum.fc.common.impl.preferences.IPreferencesObserver;
import com.documentum.fc.common.impl.preferences.TypedPreferences;
import com.documentum.fc.impl.util.ThrowableStack;
import com.documentum.fc.internal.reshousekeeper.IDisposableResource;
import com.documentum.fc.internal.reshousekeeper.ResourceHousekeeper;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public final class InputStreamHandle
extends FilterInputStream {
    private final DisposableData m_disposableData;
    private static boolean s_saveStacks;

    public InputStreamHandle(InputStream stream) {
        super(stream);
        assert (stream != null);
        this.m_disposableData = new DisposableData();
        this.m_disposableData.m_stream = stream;
        this.m_disposableData.m_open = true;
        if (s_saveStacks) {
            this.m_disposableData.m_constructionStack = new ThrowableStack("Stack when stream was created", InputStreamHandle.class);
        }
        ResourceHousekeeper.registerForCleanup(this, this.m_disposableData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        try {
            this.m_disposableData.m_stream.close();
        }
        finally {
            this.m_disposableData.m_open = false;
        }
    }

    static {
        new PreferencesObserver();
    }

    private static final class PreferencesObserver
    implements IPreferencesObserver {
        PreferencesObserver() {
            DfPreferences.getInstance().addObserver(this);
            this.update(DfPreferences.getInstance(), null);
        }

        public void update(TypedPreferences preferences, String preferenceName) {
            s_saveStacks = ((DfPreferences)preferences).areResourceDiagnosticsEnabled();
        }
    }

    private static final class DisposableData
    implements IDisposableResource {
        private boolean m_open;
        private InputStream m_stream;
        private ThrowableStack m_constructionStack;

        private DisposableData() {
        }

        public void dispose() {
            if (this.m_open) {
                DfLogger.error((Object)this, "DFC_STREAM_NOT_CLOSED", new Object[]{this.m_stream}, (Throwable)this.m_constructionStack);
                try {
                    this.m_stream.close();
                }
                catch (IOException e) {
                    DfLogger.warn((Object)this, "DFC_STREAM_CLOSE_ERROR", new Object[]{this.m_stream}, (Throwable)e);
                }
            }
        }
    }
}

